/*
 * Decompiled with CFR 0.152.
 */
package generator;

import animal.exchange.AnimationImporter;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.MessageDisplay;
import generator.CustomFileFilter;
import generator.Generator;
import generator.GeneratorBundle;
import generator.GeneratorPropertiesEditor;
import generator.GeneratorTreeNode;
import generator.PropertiesPanel;
import generator.properties.tree.PropertiesTreeModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;
import translator.Translator;

public class GeneratorTree
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private char separator = File.separatorChar;
    public static HashMap<Integer, String> packageMapper = new HashMap(23);
    JFrame myFrame = null;
    private HashMap<String, ClassLoader> generatorDummies = new HashMap(23);
    AbstractButton quitButton;
    AbstractButton confirmButton;
    AbstractButton backButton;
    private HashMap<String, DefaultMutableTreeNode> generators = new HashMap(101);
    private static Translator trans = new Translator("generator", Locale.US);
    private GeneratorPropertiesEditor editor = null;
    JTree myTree;
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode child;
    Generator currentGenerator;
    public static final String MAIN_PANEL = "Main";
    public static final String PROPS_PANEL = "Properties";
    public static final String FILE_CHOICE_PANEL = "File Choice";
    private JEditorPane editorPane = null;
    PropertiesPanel propsPanel;
    String activeCard = "Main";
    private JTextField txtFileName = new JTextField();
    JPanel mainContentPanel;
    private Animal myAnimalInstance;
    public HashMap<String, Vector<String>> contentAuthors = new HashMap(237);
    public static final String BASE_DIRECTORY_NAME = "generatorImplementations";
    private int nrGenerators = 0;

    static {
        packageMapper.put(256, "generatorImplementations.backtracking");
        packageMapper.put(64, "generatorImplementations.compression");
        packageMapper.put(128, "generatorImplementations.cryptography");
        packageMapper.put(16, "generatorImplementations.datastructures");
        packageMapper.put(8, "generatorImplementations.graph");
        packageMapper.put(32, "generatorImplementations.hashing");
        packageMapper.put(0x40000000, "generatorImplementations.misc");
        packageMapper.put(2, "generatorImplementations.searching");
        packageMapper.put(1, "generatorImplementations.sorting");
        packageMapper.put(4, "generatorImplementations.tree");
    }

    public static void main(String[] av) {
        new GeneratorTree();
    }

    public GeneratorTree() {
        this.myFrame = new JFrame(trans.translateMessage("mainWindowTitle"));
        Container cp = this.myFrame.getContentPane();
        cp.setLayout(new BorderLayout());
        this.init();
        this.setupGUI();
    }

    public GeneratorTree(Animal animalInstance) {
        this();
        this.myAnimalInstance = animalInstance;
    }

    private void init() {
        this.root = this.addCategory("Generators", "/", null);
        this.myTree = new JTree(this.root);
        this.createGenerators();
    }

    private void createGenerators() {
        this.nrGenerators = 0;
        this.createGeneratorsForPackage(BASE_DIRECTORY_NAME);
        for (String key : packageMapper.values()) {
            this.createGeneratorsForPackage(key);
        }
    }

    private void createGeneratorsForPackage(String packageName) {
        int count = 0;
        try {
            Class<?> generatorDummy = Class.forName(String.valueOf(packageName) + ".DummyGenerator");
            try {
                Object dummy = generatorDummy.newInstance();
                if (dummy instanceof GeneratorBundle) {
                    Vector<Generator> localGens = ((GeneratorBundle)dummy).getGenerators();
                    for (Generator g : localGens) {
                        this.insertGenerator(g);
                        ++count;
                    }
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    private void createGeneratorsForPackageManually(String packageName) {
        URL url = null;
        Class<?> generatorDummy = null;
        ClassLoader generatorLoader = null;
        String localPath = packageName.replace('.', this.separator);
        if (this.generatorDummies.get(packageName) == null) {
            try {
                generatorDummy = Class.forName(String.valueOf(packageName) + ".DummyGenerator");
                generatorLoader = generatorDummy.getClassLoader();
                this.generatorDummies.put(packageName, generatorLoader);
                System.err.println(this.generatorDummies.toString());
            }
            catch (ClassNotFoundException cfe) {
                System.err.println(String.valueOf(packageName) + ".DummyGenerator could not be found!");
            }
        } else {
            generatorLoader = this.generatorDummies.get(packageName);
        }
        if (generatorLoader != null && generatorLoader != null) {
            url = generatorLoader.getResource(localPath);
        }
        if (url == null) {
            return;
        }
        String path = url.toString();
        if (path == null) {
            return;
        }
        if (path.startsWith("jar:")) {
            this.createGeneratorsFromJAR(generatorLoader, path, packageName);
        } else {
            this.createGeneratorsFromFileSystem(url, path, packageName);
        }
        this.addExtraGenerators();
    }

    private void addExtraGenerators() {
        try {
            Properties config = null;
            InputStream in = this.getClass().getResourceAsStream("/generators.dat");
            if (in != null) {
                BufferedInputStream bins = new BufferedInputStream(in);
                config = new Properties();
                config.load(bins);
                bins.close();
                in.close();
                Enumeration<?> keys = config.propertyNames();
                while (keys.hasMoreElements()) {
                    String elementKey = (String)config.get(keys.nextElement());
                    this.createFullyQualifiedGeneratorByName(elementKey, "default");
                }
            }
        }
        catch (IOException ioex) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("genSpecMissing"), 4);
        }
    }

    private void createGeneratorsFromFileSystem(URL url, String path, String packageName) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return;
        }
        if (f == null) {
            return;
        }
        String[] files = f.list();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".class")) {
                this.createFullyQualifiedGeneratorByName(String.valueOf(packageName) + '.' + files[i].substring(0, files[i].length() - 6), packageName);
            }
            ++i;
        }
    }

    private void createGeneratorsFromJAR(ClassLoader loader, String path, String packageName) {
        String actualPath = path;
        if (actualPath.endsWith(".jar")) {
            actualPath = actualPath.substring(4, actualPath.indexOf(".jar") + 4);
        } else if (actualPath.indexOf("!") > 0) {
            actualPath = actualPath.substring(4, actualPath.indexOf("!"));
        }
        ZipInputStream jf = null;
        try {
            try {
                JarEntry entry;
                jf = new JarInputStream(new URL(actualPath).openConnection().getInputStream());
                String rewrittenName = packageName.replace('.', this.separator);
                while ((entry = ((JarInputStream)jf).getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (!name.startsWith(rewrittenName) || !name.endsWith(".class") || name.indexOf(36) != -1 || name.substring(rewrittenName.length() + 1).indexOf(this.separator) != -1 || name.length() < 31) continue;
                    name = name.substring(0, name.length() - 6);
                    String loadName = name.replace(this.separator, '.');
                    this.createFullyQualifiedGeneratorByName(loadName, packageName);
                }
            }
            catch (Exception e) {
                System.err.println(String.valueOf(e.getClass().getName()) + " // " + e.getMessage());
                try {
                    jf.close();
                }
                catch (IOException ioe) {
                    System.err.println(String.valueOf(ioe.getClass().getName()) + " // " + ioe.getMessage());
                }
            }
        }
        finally {
            try {
                jf.close();
            }
            catch (IOException ioe) {
                System.err.println(String.valueOf(ioe.getClass().getName()) + " // " + ioe.getMessage());
            }
        }
    }

    protected void createGeneratorByName(String className) {
        this.createFullyQualifiedGeneratorByName(className, "default");
    }

    protected void createFullyQualifiedGeneratorByName(String fullClassName, String packageName) {
        Object object = null;
        if (fullClassName == null || fullClassName.equals("")) {
            return;
        }
        try {
            Class<?> genClass = Class.forName(fullClassName);
            boolean isOK = false;
            Class<?>[] classArray = genClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                if (c.getName().startsWith("generator.Generator")) {
                    isOK = true;
                    break;
                }
                ++n2;
            }
            if (isOK) {
                object = genClass.newInstance();
                if (object instanceof Generator) {
                    this.insertGenerator(object);
                } else if (object instanceof GeneratorBundle) {
                    Vector<Generator> generators = ((GeneratorBundle)object).getGenerators();
                    for (Generator gen : generators) {
                        this.insertGenerator(gen);
                    }
                }
            }
        }
        catch (InstantiationException genClass) {
        }
        catch (IllegalAccessException e) {
            System.err.println("IllegalAccessException: " + fullClassName + ", " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.err.println("ClassNotFoundException: " + fullClassName + ", " + e.getMessage());
        }
    }

    public void insertGenerator(Generator gen) {
        if (gen == null) {
            return;
        }
        int generatorType = gen.getGeneratorType().getType();
        String plUsed = gen.getOutputLanguage();
        String languageCode = gen.getContentLocale().getLanguage();
        String algoBaseName = gen.getAlgorithmName();
        StringBuilder genPath = new StringBuilder(64);
        genPath.append('/').append(languageCode).append('/').append(plUsed).append('/');
        genPath.append(trans.translateMessage(String.valueOf(generatorType)));
        genPath.append('/').append(algoBaseName);
        DefaultMutableTreeNode parent = this.findOrCreatePath(languageCode, plUsed, trans.translateMessage(String.valueOf(generatorType)), algoBaseName);
        this.addGenerator(gen, genPath.toString(), parent);
    }

    private DefaultMutableTreeNode findOrCreatePath(String ... pathInfo) {
        DefaultMutableTreeNode current = this.generators.get("/");
        DefaultMutableTreeNode lookup = null;
        StringBuilder sb = new StringBuilder(128);
        String[] stringArray = pathInfo;
        int n = pathInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append('/').append(s);
            lookup = this.generators.get(sb.toString());
            if (lookup == null) {
                lookup = this.addCategory(s, sb.toString(), current);
            }
            current = lookup;
            ++n2;
        }
        return current;
    }

    public void setupGUI() {
        this.myTree.addTreeSelectionListener(this);
        Container cp = this.myFrame.getContentPane();
        JSplitPane mainPanel = this.getMainPanel();
        this.propsPanel = this.getPropertiesPanel();
        JPanel fileChoicePanel = this.getFileChoicePanel();
        this.mainContentPanel = new JPanel(new CardLayout());
        this.mainContentPanel.add((Component)mainPanel, MAIN_PANEL);
        this.mainContentPanel.add((Component)this.propsPanel, PROPS_PANEL);
        this.mainContentPanel.add((Component)fileChoicePanel, FILE_CHOICE_PANEL);
        cp.add((Component)this.mainContentPanel, "Center");
        JPanel buttonPanel = new JPanel();
        TranslatableGUIElement generator = trans.getGenerator();
        this.backButton = generator.generateJButton("backGen");
        buttonPanel.add("South", this.backButton);
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorTree.this.activeCard == GeneratorTree.PROPS_PANEL) {
                    GeneratorTree.this.activeCard = GeneratorTree.MAIN_PANEL;
                    ((CardLayout)GeneratorTree.this.mainContentPanel.getLayout()).show(GeneratorTree.this.mainContentPanel, GeneratorTree.MAIN_PANEL);
                    GeneratorTree.this.propsPanel.updateRightPanelGeneral();
                    GeneratorTree.this.backButton.setEnabled(true);
                } else if (GeneratorTree.this.activeCard == GeneratorTree.FILE_CHOICE_PANEL) {
                    GeneratorTree.this.activeCard = GeneratorTree.PROPS_PANEL;
                    ((CardLayout)GeneratorTree.this.mainContentPanel.getLayout()).show(GeneratorTree.this.mainContentPanel, GeneratorTree.PROPS_PANEL);
                    GeneratorTree.this.propsPanel.updateRightPanelGeneral();
                }
            }
        });
        this.confirmButton = generator.generateJButton("confirmGen");
        buttonPanel.add("South", this.confirmButton);
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratorTree.this.activeCard == GeneratorTree.MAIN_PANEL) {
                    ((CardLayout)GeneratorTree.this.mainContentPanel.getLayout()).show(GeneratorTree.this.mainContentPanel, GeneratorTree.PROPS_PANEL);
                    GeneratorTree.this.updatePropertiesPanel();
                    JTree aNewTree = new JTree();
                    PropertiesTreeModel ptm = new PropertiesTreeModel();
                    aNewTree.setModel(ptm);
                    if (GeneratorTree.this.currentGenerator != null) {
                        StringBuilder buf = new StringBuilder(64);
                        buf.append(GeneratorTree.this.currentGenerator.getClass().getPackage().getName());
                        buf.append("/");
                        buf.append(GeneratorTree.this.currentGenerator.getClass().getSimpleName());
                        String basename = buf.toString();
                        try {
                            String fname = PropertiesTreeModel.cleanString(String.valueOf(basename) + ".xml", "xml");
                            ptm.loadFromXMLFile(fname, true);
                        }
                        catch (Exception e2) {
                            try {
                                String fname = PropertiesTreeModel.cleanString(String.valueOf(basename) + ".ptm", "ptm");
                                ptm.loadFromXMLFile(String.valueOf(fname) + ".ptm", true);
                            }
                            catch (Exception e3) {
                                System.err.println(e3.getMessage());
                            }
                            System.err.println(e2.getMessage());
                        }
                    }
                    GeneratorTree.this.activeCard = GeneratorTree.PROPS_PANEL;
                    GeneratorTree.this.propsPanel.clearSelection();
                    GeneratorTree.this.backButton.setEnabled(true);
                } else if (GeneratorTree.this.activeCard == GeneratorTree.PROPS_PANEL) {
                    ((CardLayout)GeneratorTree.this.mainContentPanel.getLayout()).show(GeneratorTree.this.mainContentPanel, GeneratorTree.FILE_CHOICE_PANEL);
                    GeneratorTree.this.propsPanel.clearSelection();
                    GeneratorTree.this.activeCard = GeneratorTree.FILE_CHOICE_PANEL;
                    GeneratorTree.this.backButton.setEnabled(true);
                } else if (GeneratorTree.this.activeCard == GeneratorTree.FILE_CHOICE_PANEL) {
                    GeneratorTree.this.generateGeneratorContent();
                    GeneratorTree.this.backButton.setEnabled(false);
                }
            }
        });
        this.quitButton = generator.generateJButton("quitGen");
        buttonPanel.add(this.quitButton);
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneratorTree.this.myFrame.setVisible(false);
                GeneratorTree.this.myFrame.dispose();
                GeneratorTree.this.myTree.setSelectionRow(0);
                ((CardLayout)GeneratorTree.this.mainContentPanel.getLayout()).show(GeneratorTree.this.mainContentPanel, GeneratorTree.MAIN_PANEL);
                GeneratorTree.this.activeCard = GeneratorTree.MAIN_PANEL;
            }
        });
        this.confirmButton.setEnabled(false);
        cp.add("South", buttonPanel);
        this.myFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GeneratorTree.this.myFrame.setVisible(false);
                GeneratorTree.this.myFrame.dispose();
            }
        });
        this.myFrame.pack();
        this.myFrame.setVisible(true);
        cp.add((Component)new JLabel("#total: " + this.nrGenerators), "North");
        this.generateEditorPaneContent(0, null);
    }

    private PropertiesPanel getPropertiesPanel() {
        this.editor = new GeneratorPropertiesEditor(this.currentGenerator);
        this.editor.fillPropertiesForGenerator();
        PropertiesPanel p = this.editor.getPropertiesPanel();
        return p;
    }

    void updatePropertiesPanel() {
        if (this.editor == null) {
            this.editor = new GeneratorPropertiesEditor(this.currentGenerator);
        } else {
            this.editor.setGenerator(this.currentGenerator);
        }
        this.editor.fillPropertiesForGenerator();
    }

    private String createContent() {
        PropertiesTreeModel aModel = (PropertiesTreeModel)this.editor.getPropertiesPanel().getTree().getModel();
        return this.currentGenerator.generate(aModel.getPropertiesContainer(), aModel.getPrimitivesContainer());
    }

    boolean generateGeneratorContent() {
        int choice;
        String animalGenerator;
        block20: {
            animalGenerator = trans.translateMessage("animalGenerator");
            File selFile = new File(this.txtFileName.getText());
            boolean directWriteToAnimal = this.txtFileName.getText().length() == 0 && this.myAnimalInstance != null;
            this.activeCard = MAIN_PANEL;
            if (!directWriteToAnimal && selFile.exists()) {
                if (!selFile.canWrite()) {
                    JOptionPane.showMessageDialog(this.myFrame, trans.translateMessage("invalidFilename", selFile.getPath()), animalGenerator, 0);
                    return false;
                }
                int ret = JOptionPane.showConfirmDialog(this.myFrame, trans.translateMessage("overwriteFile", selFile.getPath()), animalGenerator, 0);
                if (ret == 1) {
                    return false;
                }
            }
            if (!directWriteToAnimal) {
                BufferedWriter buf = null;
                try {
                    try {
                        FileWriter out = new FileWriter(selFile);
                        buf = new BufferedWriter(out);
                        buf.write(this.createContent());
                        buf.flush();
                        buf.close();
                        break block20;
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(this.myFrame, trans.translateMessage("errorWriting", selFile.getPath()), animalGenerator, 0);
                        try {
                            if (buf != null) {
                                buf.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return false;
                    }
                }
                finally {
                    try {
                        if (buf != null) {
                            buf.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            String format = "animation/animalscript";
            AnimationImporter animationImporter = null;
            animationImporter = AnimationImporter.getImporterFor(format);
            Animation animation = null;
            String animContent = this.createContent();
            if (animationImporter != null) {
                animation = animationImporter.importAnimationFrom(null, animContent);
            }
            if (animation != null) {
                this.myAnimalInstance.setAnimation(animation);
                this.myAnimalInstance.setAnimalScriptCode(animContent);
            }
        }
        if ((choice = JOptionPane.showConfirmDialog(this.myFrame, trans.translateMessage("exitNow"), animalGenerator, 0, 3)) == 0) {
            this.myFrame.dispose();
            ((CardLayout)this.mainContentPanel.getLayout()).show(this.mainContentPanel, MAIN_PANEL);
            this.myTree.setSelectionRow(0);
        }
        ((CardLayout)this.mainContentPanel.getLayout()).show(this.mainContentPanel, MAIN_PANEL);
        this.confirmButton.setEnabled(true);
        return true;
    }

    public void setSelectionPath(String[] p) {
        if (p == null) {
            return;
        }
        StringBuffer pathToDisplay = new StringBuffer(256);
        String[] stringArray = p;
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            pathToDisplay.append("/").append(path);
            ++n2;
        }
        System.err.println(pathToDisplay);
        DefaultMutableTreeNode node = this.generators.get(pathToDisplay.toString());
        if (node == null) {
            if (p.length > 0) {
                String[] np = new String[p.length - 1];
                System.arraycopy(p, 0, np, 0, p.length - 1);
                this.setSelectionPath(np);
            } else {
                return;
            }
        }
        Object[] pathToNode = node.getPath();
        TreePath tp = new TreePath(pathToNode);
        this.myTree.setExpandsSelectedPaths(true);
        this.myTree.setSelectionPath(tp);
        this.myTree.makeVisible(tp);
        this.myTree.scrollPathToVisible(tp);
        this.myTree.expandPath(tp);
    }

    private DefaultMutableTreeNode addCategory(String category, String chainPath, DefaultMutableTreeNode baseNode) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(category);
        this.generators.put(chainPath, node);
        if (baseNode != null) {
            baseNode.add(node);
        }
        return node;
    }

    private void addGenerator(Generator generator, String chainPath, DefaultMutableTreeNode parent) {
        GeneratorTreeNode node = new GeneratorTreeNode(generator);
        this.generators.put(String.valueOf(chainPath) + "/" + generator.getName(), node);
        if (parent != null) {
            parent.add(node);
        }
        String authorKey = generator.getAnimationAuthor();
        Vector<Object> targetVector = null;
        if (!this.contentAuthors.containsKey(authorKey)) {
            targetVector = new Vector(80, 50);
            this.contentAuthors.put(authorKey, targetVector);
        } else {
            targetVector = this.contentAuthors.get(authorKey);
        }
        StringBuilder contentEntry = new StringBuilder(100);
        contentEntry.append("<li>").append(generator.getName());
        contentEntry.append("</li>");
        targetVector.add(contentEntry.toString());
        ++this.nrGenerators;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath currentPath = e.getPath();
        if (currentPath != null) {
            this.generateEditorPaneContent(currentPath.getPathCount(), currentPath.getLastPathComponent());
        }
    }

    private void addDefaultHTMLStart(StringBuilder sb) {
        sb.append(trans.translateMessage("htmlHead"));
    }

    private void addDefaultHTMLEnd(StringBuilder sb) {
        sb.append("\n</body>\n</html>");
    }

    public void setVisible(boolean visibleMode) {
        this.myFrame.setVisible(visibleMode);
    }

    public void setGeneratorLocale(Locale targetLocale) {
        System.err.println("Updating locale from " + trans.getCurrentLocale() + " to " + targetLocale);
        trans.setTranslatorLocale(targetLocale);
        System.err.println("new locale is now " + trans.getCurrentLocale());
    }

    private void generateEditorPaneContent(int pathLength, Object lastPathComponent) {
        this.confirmButton.setEnabled(false);
        this.currentGenerator = null;
        StringBuilder contentBuffer = new StringBuilder(4096);
        if (pathLength < 5 || pathLength == 6) {
            this.addDefaultHTMLStart(contentBuffer);
        }
        switch (pathLength) {
            case 0: 
            case 1: {
                contentBuffer.append(trans.translateMessage("Generators"));
                break;
            }
            case 2: {
                contentBuffer.append(trans.translateMessage("languageChoice", new Object[]{lastPathComponent, trans.translateMessage(lastPathComponent.toString())}));
                break;
            }
            case 3: {
                contentBuffer.append(trans.translateMessage("plChoice", trans.translateMessage(lastPathComponent.toString())));
                break;
            }
            case 4: {
                contentBuffer.append(trans.translateMessage(lastPathComponent.toString()));
                break;
            }
            case 5: {
                contentBuffer.append(trans.translateMessage("seeConcreteGenerator", lastPathComponent.toString()));
                break;
            }
            case 6: {
                Generator generator;
                if (!(lastPathComponent instanceof GeneratorTreeNode)) break;
                GeneratorTreeNode generatorNode = (GeneratorTreeNode)lastPathComponent;
                this.currentGenerator = generator = generatorNode.getGenerator();
                contentBuffer.append(trans.translateMessage("algoTemplate", generator.getName(), generator.getAlgorithmName(), generator.getOutputLanguage(), generator.getContentLocale().toString(), generator.getFileExtension(), generator.getAnimationAuthor(), generator.getDescription(), generator.getCodeExample()));
                this.confirmButton.setEnabled(true);
            }
        }
        if (pathLength < 5 || pathLength == 6) {
            this.addDefaultHTMLEnd(contentBuffer);
        }
        this.editorPane.setText(contentBuffer.toString());
        this.editorPane.setCaretPosition(0);
    }

    private JSplitPane getMainPanel() {
        Dimension minSize = new Dimension(200, 288);
        JScrollPane treeScrollPane = new JScrollPane(this.myTree);
        treeScrollPane.setMinimumSize(minSize);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        JScrollPane editorScrollPane = new JScrollPane(this.editorPane);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(treeScrollPane);
        splitPane.setRightComponent(editorScrollPane);
        splitPane.setDividerLocation(200);
        this.editorPane.setMinimumSize(minSize);
        splitPane.setResizeWeight(0.2);
        return splitPane;
    }

    public String getContentAuthors() {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("\n<h2>Animation Generator Authors</h2>\n\n<dl>");
        Object[] keys = this.contentAuthors.keySet().toArray();
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Vector<String> currentVector = this.contentAuthors.get(key);
            if (currentVector != null && currentVector.size() > 0) {
                sb.append("\n<dt>").append(key).append("</dt>\n<dd><ul>");
                Object[] entries = currentVector.toArray();
                Arrays.sort(entries);
                Object[] objectArray2 = entries;
                int n3 = entries.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object entry = objectArray2[n4];
                    sb.append(entry);
                    ++n4;
                }
                sb.append("\n</ul>\n</dd>");
            }
            ++n2;
        }
        sb.append("\n</dl>\n");
        return sb.toString();
    }

    private JPanel getFileChoicePanel() {
        JPanel p = new JPanel();
        JPanel panelTextField = new JPanel();
        panelTextField.setLayout(new BorderLayout(8, 8));
        JLabel helperLabel = new JLabel(trans.translateMessage("fileHelp"));
        p.add(helperLabel);
        p.add(Box.createRigidArea(new Dimension(0, 16)));
        JLabel filenameLabel = new JLabel(trans.translateMessage("filenamePrompt"));
        panelTextField.add((Component)filenameLabel, "Before");
        panelTextField.add((Component)this.txtFileName, "Center");
        int txtHeight = this.txtFileName.getPreferredSize().height;
        panelTextField.setPreferredSize(new Dimension(300, txtHeight + 5));
        panelTextField.setMaximumSize(new Dimension(600, txtHeight + 5));
        p.add(panelTextField);
        p.add(Box.createRigidArea(new Dimension(0, 16)));
        JPanel panelButton = new JPanel();
        panelButton.setLayout(new BorderLayout(8, 8));
        JButton but = new JButton(trans.translateMessage("browse"));
        but.setActionCommand("browse");
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneratorTree.this.browseForFilename();
            }
        });
        panelButton.add((Component)but, "After");
        int butHeight = but.getPreferredSize().height;
        but.setPreferredSize(new Dimension(200, butHeight + 5));
        panelButton.setPreferredSize(new Dimension(300, butHeight + 5));
        panelButton.setMaximumSize(new Dimension(600, butHeight + 5));
        p.add(panelButton);
        return p;
    }

    void browseForFilename() {
        JFileChooser fc;
        if (this.txtFileName.getText().length() > 0) {
            File start = new File(this.txtFileName.getText());
            fc = new JFileChooser(start.getParent());
        } else {
            fc = new JFileChooser();
        }
        fc.addChoosableFileFilter(new CustomFileFilter(this.currentGenerator.getFileExtension()));
        int result = fc.showSaveDialog(this.myFrame);
        if (result != 0) {
            return;
        }
        File selFile = fc.getSelectedFile();
        try {
            String strFile = selFile.getCanonicalPath();
            if (selFile.getName().indexOf(".") == -1) {
                strFile = strFile.concat("." + this.currentGenerator.getFileExtension());
            }
            this.txtFileName.setText(strFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

