/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.Generator;
import generator.properties.AnimationPropertiesContainer;
import generator.properties.tree.PropertiesTreeModel;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class GeneratorInterceptor {
    public void runFromArguments(String[] args) {
        if (args == null || args.length < 3) {
            return;
        }
        String generatorName = args[0];
        Generator generator = this.createGenerator(generatorName);
        if (generator == null) {
            return;
        }
        PropertiesTreeModel model = this.loadPropertiesFor(generator, generatorName);
        String arrayName = args[1];
        int[] array = this.createArrayFromString(args[2]);
        AnimationPropertiesContainer container = model.getPropertiesContainer();
        Hashtable<String, Object> primitives = model.getPrimitivesContainer();
        primitives.put(arrayName, array);
        String content = generator.generate(container, primitives);
        BufferedWriter buf = null;
        try {
            try {
                FileWriter out = new FileWriter("demo.asu");
                buf = new BufferedWriter(out);
                buf.write(content);
                buf.flush();
                buf.close();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, "Error writing", null, 0);
                try {
                    if (buf != null) {
                        buf.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (buf != null) {
                    buf.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private int[] createArrayFromString(String arrayString) {
        if (arrayString == null) {
            return null;
        }
        StringTokenizer stok = new StringTokenizer(arrayString, ", ");
        int[] tmp = new int[arrayString.length()];
        int pos = 0;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            try {
                Integer i = Integer.parseInt(token);
                tmp[pos++] = i;
            }
            catch (NumberFormatException nfe) {
                System.err.println(String.valueOf(token) + " could not be coded as an int");
            }
        }
        int[] result = new int[pos];
        System.arraycopy(tmp, 0, result, 0, pos);
        return result;
    }

    private PropertiesTreeModel loadPropertiesFor(Generator generator, String generatorName) {
        if (generator == null) {
            return null;
        }
        PropertiesTreeModel ptm = new PropertiesTreeModel();
        StringBuilder buf = new StringBuilder(64);
        buf.append(generator.getClass().getPackage().getName());
        buf.append("/");
        buf.append(generator.getClass().getSimpleName());
        String basename = buf.toString();
        try {
            String fname = PropertiesTreeModel.cleanString(String.valueOf(basename) + ".xml", "xml");
            ptm.loadFromXMLFile(fname, true);
        }
        catch (Exception e2) {
            try {
                String fname = PropertiesTreeModel.cleanString(String.valueOf(basename) + ".ptm", "ptm");
                ptm.loadFromXMLFile(String.valueOf(fname) + ".ptm", true);
            }
            catch (Exception e3) {
                System.err.println(e3.getMessage());
            }
            System.err.println(e2.getMessage());
        }
        return ptm;
    }

    private Generator createGenerator(String className) {
        Object object = null;
        try {
            Class<?> genClass = Class.forName(className);
            object = genClass.newInstance();
            if (object instanceof Generator) {
                return object;
            }
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        new GeneratorInterceptor().runFromArguments(args);
    }
}

