/*
 * Decompiled with CFR 0.152.
 */
package generator;

import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class CustomFileFilter
extends FileFilter {
    private String myExtension;

    public CustomFileFilter(String newExtension) {
        this.myExtension = newExtension != null ? newExtension : "asu";
        this.myExtension = newExtension.trim();
        while (this.myExtension.length() > 1 && this.myExtension.charAt(0) == '.') {
            this.myExtension = this.myExtension.substring(1);
        }
        if (this.myExtension.length() == 0) {
            this.myExtension = "asu";
        }
    }

    private static String getExtension(File f) {
        if (f == null) {
            return null;
        }
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase(Locale.US);
        }
        return ext;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String ext = CustomFileFilter.getExtension(f);
        if (ext == null) {
            return false;
        }
        return ext.equalsIgnoreCase(this.myExtension);
    }

    @Override
    public String getDescription() {
        return "Show only " + this.myExtension + "-Files";
    }
}

