/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen.property;

import de.ahrgr.animal.kohnert.asugen.Color;
import de.ahrgr.animal.kohnert.asugen.Font;
import de.ahrgr.animal.kohnert.asugen.property.Property;

public class FontProperty
extends Property {
    protected Color color;
    protected Color defaultColor;
    protected Font font;
    protected Font defaultFont;

    public FontProperty(String aKey, String aDescription, Color theDefaultColor, Font theDefaultFont) {
        super(aKey, aDescription);
        this.defaultColor = theDefaultColor;
        this.color = theDefaultColor;
        this.defaultFont = theDefaultFont;
        this.font = theDefaultFont;
    }

    public FontProperty(String aKey, String theDescription, String theDefaultText) {
        this(aKey, theDescription, Color.BLACK, Font.FT_DEFAULT);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color aColor) {
        this.color = aColor;
    }

    public void setColor(String colors) {
        this.color = Color.createFromString(colors);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font theFont) {
        this.font = theFont;
    }

    public void setFont(String fonts) {
        this.font = Font.createFromString(fonts);
    }

    @Override
    public void setToDefaultValue() {
        this.color = this.defaultColor;
        this.font = this.defaultFont;
    }

    public String toString() {
        return "\"" + this.getKey() + "\" = Font(\"" + this.getFont().toAnimalString() + "\", " + this.getColor() + ")";
    }
}

