/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.IntegerTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class MatrixInputTable
extends JScrollPane {
    public static final char MATRIX_TYPE_INTEGER = '\u0001';
    public static final char MATRIX_TYPE_STRING = '\u0002';
    private char arrayType = '\u0001';
    private static final long serialVersionUID = -2264273704590965509L;
    private JTable myTable;
    private int iNumberOfColumns = 3;
    private int iNumberOfRows = 3;
    private String strLocalHeader = "Column";

    public MatrixInputTable() {
        this.iNumberOfRows = 3;
        this.iNumberOfColumns = 3;
        this.init();
    }

    public MatrixInputTable(int numRows, int numColumns) {
        this.iNumberOfRows = numRows < 1 ? 3 : numRows;
        this.iNumberOfColumns = numColumns < 1 ? 3 : numColumns;
        this.init();
    }

    public MatrixInputTable(int[][] newValues) {
        this.iNumberOfRows = 3;
        this.arrayType = '\u0001';
        this.iNumberOfColumns = 3;
        this.init();
        this.setValues(newValues);
    }

    public MatrixInputTable(String[][] newValues) {
        this.iNumberOfRows = 3;
        this.arrayType = (char)2;
        this.iNumberOfColumns = 3;
        this.init();
        this.setValues(newValues);
    }

    public void setNumberOfColumns(int numColumns) {
        if (numColumns < 1) {
            return;
        }
        this.iNumberOfColumns = numColumns;
        this.changeDimensions(this.iNumberOfRows, numColumns);
    }

    public int getNumberOfColumns() {
        return this.iNumberOfColumns;
    }

    public void setNumberOfRows(int numRows) {
        if (numRows < 1) {
            return;
        }
        this.iNumberOfRows = numRows;
        this.changeDimensions(numRows, this.iNumberOfColumns);
    }

    public int getNumberOfRows() {
        return this.iNumberOfRows;
    }

    public void setValues(int[][] newValues) {
        if (newValues == null) {
            return;
        }
        int iNewRows = newValues.length;
        if (iNewRows == 0) {
            return;
        }
        int iNewColumns = newValues[0].length;
        if (iNewColumns == 0) {
            return;
        }
        this.changeDimensions(iNewRows, iNewColumns);
        int i = 0;
        while (i < iNewRows) {
            int j = 0;
            while (j < iNewColumns) {
                if (newValues[i].length >= j - 1) {
                    Integer intObj = new Integer(newValues[i][j]);
                    this.myTable.setValueAt(intObj, i, j);
                } else {
                    this.myTable.setValueAt(new Integer(0), i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void setValues(String[][] newValues) {
        if (newValues == null) {
            return;
        }
        int iNewRows = newValues.length;
        if (iNewRows == 0) {
            return;
        }
        int iNewColumns = newValues[0].length;
        if (iNewColumns == 0) {
            return;
        }
        this.changeDimensions(iNewRows, iNewColumns);
        int i = 0;
        while (i < iNewRows) {
            int j = 0;
            while (j < iNewColumns) {
                if (newValues[i].length >= j - 1) {
                    String cVal = new String(newValues[i][j]);
                    this.myTable.setValueAt(cVal, i, j);
                } else {
                    this.myTable.setValueAt("0", i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public int[][] getIntMatrixValues() {
        int[][] retval = new int[this.iNumberOfRows][this.iNumberOfColumns];
        int i = 0;
        while (i < this.iNumberOfRows) {
            int j = 0;
            while (j < this.iNumberOfColumns) {
                retval[i][j] = (Integer)this.myTable.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        return retval;
    }

    public String[][] getStringMatrixValues() {
        String[][] retval = new String[this.iNumberOfRows][this.iNumberOfColumns];
        int i = 0;
        while (i < this.iNumberOfRows) {
            int j = 0;
            while (j < this.iNumberOfColumns) {
                retval[i][j] = (String)this.myTable.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        return retval;
    }

    public void setLocalHeaderString(String strNewLocalHeader) {
        if (strNewLocalHeader == null) {
            return;
        }
        String localHeader = strNewLocalHeader.trim();
        if (this.strLocalHeader.equals(localHeader)) {
            return;
        }
        this.strLocalHeader = localHeader;
        int i = 0;
        while (i < this.myTable.getColumnCount()) {
            TableColumn column = this.myTable.getColumnModel().getColumn(i);
            column.setHeaderValue((String.valueOf(localHeader) + " " + Integer.toString(i)).trim());
            ++i;
        }
    }

    public String getLocalHeaderString() {
        return this.strLocalHeader;
    }

    public void changeDimensions(int numRows, int numColumns) {
        int j;
        if (numRows < 1 || numColumns < 1) {
            return;
        }
        System.err.println(String.valueOf(this.myTable.getRowCount()) + " x " + this.myTable.getColumnCount());
        int iOldCols = this.myTable.getColumnCount();
        int iOldRows = this.myTable.getRowCount();
        Object[][] oldData = new Object[numRows][numColumns];
        int i = 0;
        while (i < numRows) {
            oldData[i] = new Object[numColumns];
            j = 0;
            while (j < numColumns) {
                oldData[i][j] = i >= iOldRows || j >= iOldCols ? (this.arrayType == '\u0001' ? new Integer(0) : "") : this.myTable.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        this.iNumberOfRows = numRows;
        this.iNumberOfColumns = numColumns;
        this.init();
        i = 0;
        while (i < numRows) {
            j = 0;
            while (j < numColumns) {
                this.myTable.setValueAt(oldData[i][j], i, j);
                ++j;
            }
            ++i;
        }
    }

    private void init() {
        int j;
        int i;
        this.setPreferredSize(new Dimension(200, 200));
        Object[] columnNames = new String[this.iNumberOfColumns];
        Object[][] data = null;
        if (this.arrayType == '\u0001') {
            data = new Integer[this.iNumberOfRows][this.iNumberOfColumns];
            i = 0;
            while (i < this.iNumberOfColumns) {
                columnNames[i] = (String.valueOf(this.strLocalHeader) + " " + Integer.toString(i)).trim();
                j = 0;
                while (j < this.iNumberOfRows) {
                    data[j][i] = new Integer(0);
                    ++j;
                }
                ++i;
            }
        } else if (this.arrayType == '\u0002') {
            data = new String[this.iNumberOfRows][this.iNumberOfColumns];
            i = 0;
            while (i < this.iNumberOfColumns) {
                columnNames[i] = (String.valueOf(this.strLocalHeader) + " " + Integer.toString(i)).trim();
                j = 0;
                while (j < this.iNumberOfRows) {
                    data[j][i] = "";
                    ++j;
                }
                ++i;
            }
        }
        this.myTable = new JTable();
        this.myTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (this.arrayType == '\u0001') {
            this.myTable.setModel(new IntegerTableModel((Integer[][])data, columnNames));
        } else {
            this.myTable.setModel(new DefaultTableModel((String[][])data, columnNames));
        }
        if (this.arrayType == '\u0001') {
            i = 0;
            while (i < this.myTable.getColumnCount()) {
                TableColumn column = this.myTable.getColumnModel().getColumn(i);
                IntegerCellEditor editor = new IntegerCellEditor();
                column.setCellEditor(editor);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.myTable.getColumnCount()) {
                TableColumn column = this.myTable.getColumnModel().getColumn(i);
                StringCellEditor editor = new StringCellEditor(new JTextField());
                column.setCellEditor(editor);
                ++i;
            }
        }
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setAutoResizeMode(0);
        this.setViewportView(this.myTable);
    }

    static class IntegerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -6725001766631532850L;
        private IntegerTextField textField = new IntegerTextField();

        IntegerCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (table == null || row < 0 || column < 0) {
                return null;
            }
            if (value instanceof Integer && (Integer)value != null) {
                this.textField.setText(((Integer)value).toString());
                this.textField.setDefaultValue((Integer)value);
            } else {
                this.textField.setText("0");
                this.textField.setDefaultValue(new Integer(0));
            }
            if (isSelected || !isSelected) {
                this.textField.setBackground(new Color(255, 255, 128));
            }
            this.textField.setBorder(BorderFactory.createEmptyBorder());
            return this.textField;
        }

        @Override
        public boolean stopCellEditing() {
            super.stopCellEditing();
            return true;
        }
    }

    private static class IntegerTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 4270055943157017558L;

        public IntegerTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public Class<Integer> getColumnClass(int column) {
            return Integer.class;
        }
    }

    private static class StringCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8203744556751380673L;
        private JTextField textField = new JTextField();

        public StringCellEditor(JTextField theTextField) {
            super(theTextField);
            this.setClickCountToStart(1);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.textField.getText().length() == 0) {
                return new String("A");
            }
            return this.textField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (table == null || row < 0 || column < 0) {
                return null;
            }
            if (value instanceof String && (String)value != null) {
                this.textField.setText((String)value);
            } else {
                this.textField.setText("A");
            }
            if (isSelected || !isSelected) {
                this.textField.setBackground(new Color(255, 255, 128));
            }
            this.textField.setBorder(BorderFactory.createEmptyBorder());
            return this.textField;
        }

        @Override
        public boolean stopCellEditing() {
            super.stopCellEditing();
            return true;
        }
    }
}

