/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class EnumerationChooserComboBox
extends JComboBox
implements ActionListener {
    private static final long serialVersionUID = 1252859137398793065L;
    private String[] possibleValues = null;
    private EnumerationChooserComboBoxRenderer renderer = new EnumerationChooserComboBoxRenderer();
    private String strSelected = null;
    private Object[][] values;
    private boolean bChangeByComponent = false;

    public EnumerationChooserComboBox() {
        this.init();
    }

    public EnumerationChooserComboBox(String strNew) {
        this.init();
        this.setChosenElement(strNew);
    }

    public EnumerationChooserComboBox(Vector<String> newChoice) {
        this.possibleValues = new String[newChoice.size() - 1];
        int i = 1;
        while (i < newChoice.size()) {
            this.possibleValues[i - 1] = newChoice.elementAt(i);
            ++i;
        }
        this.init();
        this.setChosenElement(newChoice.elementAt(0));
    }

    public void setChosenElement(String strNew) {
        if (strNew == null) {
            return;
        }
        String newString = strNew.trim().toLowerCase();
        int iNewIndex = -1;
        int i = 0;
        while (i < this.possibleValues.length) {
            if (newString.equals(this.possibleValues[i].toLowerCase())) {
                this.strSelected = this.possibleValues[i];
                iNewIndex = i;
            }
            ++i;
        }
        if (iNewIndex == -1) {
            return;
        }
        this.bChangeByComponent = true;
        this.setSelectedIndex(iNewIndex);
        this.bChangeByComponent = false;
        this.repaint();
    }

    public String getElementSelectedAsString() {
        return this.strSelected;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (this.bChangeByComponent) {
            return;
        }
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.possibleValues.length) {
            return;
        }
        this.strSelected = this.possibleValues[index];
    }

    private void init() {
        if (this.values == null) {
            this.values = new String[this.possibleValues.length][2];
        }
        int i = 0;
        while (i < this.possibleValues.length) {
            this.values[i][0] = this.possibleValues[i];
            this.values[i][1] = this.possibleValues[i];
            this.addItem(this.values[i]);
            ++i;
        }
        this.setRenderer(this.renderer);
        this.addActionListener(this);
        this.strSelected = this.possibleValues[0];
    }

    private static class EnumerationChooserComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3266835247180289721L;

        public EnumerationChooserComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null || value == null) {
                this.setText("?");
                return this;
            }
            if ((isSelected || cellHasFocus) && index != -1) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!(value instanceof Object[])) {
                return this;
            }
            Object[] itemValues = (Object[])value;
            if (!(itemValues[0] instanceof String) || !(itemValues[1] instanceof String)) {
                return this;
            }
            String strDisplay = (String)itemValues[0];
            this.setFont(new Font(strDisplay, 0, 20));
            this.setText((String)itemValues[1]);
            return this;
        }
    }
}

