/*
 * Decompiled with CFR 0.152.
 */
package avinteraction.patterns;

import avinteraction.patterns.PatternUpdate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPanel
implements ActionListener {
    protected JPanel panel;
    protected SpringLayout layout;
    protected JScrollPane treePane;
    protected JLabel deleteL;
    protected JComboBox deleteBox;
    protected JButton delete;
    protected PatternUpdate updater;
    protected JTree tree;
    protected Node patterns;

    public XMLPanel(PatternUpdate updater) {
        updater.setXMLPanel(this);
        this.updater = updater;
        this.panel = new JPanel();
        this.layout = new SpringLayout();
        this.panel.setLayout(this.layout);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject("InteractionPatterns.xml");
        this.patterns = updater.getRoot();
        this.buildTreeModelByTreeWalk(this.patterns, root);
        this.tree = new JTree(root);
        this.treePane = new JScrollPane(this.tree);
        this.treePane.setPreferredSize(new Dimension(615, 370));
        String[] state = updater.getUids();
        this.deleteBox = new JComboBox<String>(state);
        if (state.length != 0) {
            this.deleteBox.setSelectedIndex(0);
        }
        this.deleteL = new JLabel("Select Pattern");
        this.delete = new JButton("Delete Interaction Pattern");
        this.delete.setMnemonic(68);
        this.delete.addActionListener(this);
        this.layout.putConstraint("West", (Component)this.treePane, 5, "West", (Component)this.panel);
        this.layout.putConstraint("North", (Component)this.treePane, 5, "North", (Component)this.panel);
        this.layout.putConstraint("West", (Component)this.deleteL, 10, "West", (Component)this.panel);
        this.layout.putConstraint("North", (Component)this.deleteL, 16, "South", (Component)this.treePane);
        this.layout.putConstraint("West", (Component)this.deleteBox, 20, "East", (Component)this.deleteL);
        this.layout.putConstraint("North", (Component)this.deleteBox, 12, "South", (Component)this.treePane);
        this.layout.putConstraint("East", (Component)this.delete, 0, "East", (Component)this.treePane);
        this.layout.putConstraint("North", (Component)this.delete, 12, "South", (Component)this.treePane);
        this.panel.add(this.treePane);
        this.panel.add(this.deleteL);
        this.panel.add(this.deleteBox);
        this.panel.add(this.delete);
    }

    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.updater.delete((String)this.deleteBox.getSelectedItem());
        this.update();
    }

    private void buildTreeModelByTreeWalk(Node node, DefaultMutableTreeNode parentTreeNode) {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();
        switch (node.getNodeType()) {
            case 8: {
                treeNode.setUserObject(node.getTextContent());
                break;
            }
            case 1: {
                if (node.getParentNode().equals(this.patterns)) {
                    treeNode.setUserObject("[" + node.getNodeName() + "] " + node.getAttributes().getNamedItem("uid").getNodeValue());
                    break;
                }
                treeNode.setUserObject(node.getNodeName());
                break;
            }
            case 3: {
                String textContent = node.getTextContent().trim();
                if (textContent.equals("")) {
                    return;
                }
                treeNode.setUserObject(textContent);
            }
        }
        parentTreeNode.add(treeNode);
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int i = 0;
            int len = list.getLength();
            while (i < len) {
                this.buildTreeModelByTreeWalk(list.item(i), treeNode);
                ++i;
            }
        }
    }

    public void update() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject("InteractionPatterns.xml");
        this.patterns = this.updater.getRoot();
        this.buildTreeModelByTreeWalk(this.patterns, root);
        this.tree = new JTree(root);
        this.treePane.setViewportView(this.tree);
        String[] state = this.updater.getUids();
        this.deleteBox.removeAllItems();
        int j = 0;
        while (j < state.length) {
            this.deleteBox.addItem(state[j]);
            ++j;
        }
    }
}

