/*
 * Decompiled with CFR 0.152.
 */
package avinteraction.patterns;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PatternParser {
    private Validator validator;
    private Schema schemaXSD;
    private DocumentBuilder parser;
    private SchemaFactory schemaFactory;
    private String filename;
    private Document document;
    private NodeList interactions = null;
    private Element root;

    public PatternParser(String schema, String file) {
        try {
            this.filename = file;
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schemaXSD = this.schemaFactory.newSchema(new File(schema));
            this.validator = this.schemaXSD.newValidator();
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parse();
        }
        catch (SAXException saxe) {
            System.err.println(saxe.toString());
        }
        catch (ParserConfigurationException pce) {
            System.err.println(pce.toString());
        }
    }

    public void parse() {
        try {
            this.document = this.parser.parse(new File(this.filename));
            this.validator.validate(new DOMSource(this.document));
            this.root = this.document.getDocumentElement();
            this.interactions = this.root.getChildNodes();
        }
        catch (SAXException saxe) {
            System.err.println(saxe.toString());
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            System.exit(-2);
        }
    }

    public Element getRoot() {
        return this.root;
    }

    public Element getInteraction(String pattern) {
        int i = 0;
        while (i < this.interactions.getLength()) {
            Node temp = this.interactions.item(i);
            if (temp.hasAttributes() && temp.getAttributes().getNamedItem("uid").getNodeValue().equalsIgnoreCase(pattern)) {
                return (Element)temp;
            }
            ++i;
        }
        System.err.println("No Interaction Pattern \"" + pattern + "\" was found.");
        return null;
    }

    public Vector<String> getUids() {
        Vector<String> tmp = new Vector<String>();
        int i = 0;
        while (i < this.interactions.getLength()) {
            Node temp = this.interactions.item(i);
            if (temp.hasAttributes()) {
                tmp.add(temp.getAttributes().getNamedItem("uid").getNodeValue());
            }
            ++i;
        }
        return tmp;
    }

    public boolean isUidExisting(String uid) {
        int i = 0;
        while (i < this.interactions.getLength()) {
            Node temp = this.interactions.item(i);
            if (temp.hasAttributes() && temp.getAttributes().getNamedItem("uid").getNodeValue().equalsIgnoreCase(uid)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getType(String uid) {
        int i = 0;
        while (i < this.interactions.getLength()) {
            Node temp = this.interactions.item(i);
            if (temp.hasAttributes() && temp.getAttributes().getNamedItem("uid").getNodeValue().equalsIgnoreCase(uid)) {
                return temp.getNodeName();
            }
            ++i;
        }
        return null;
    }
}

