/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.ColorChanger;
import animal.animator.Move;
import animal.animator.SetFont;
import animal.animator.TimedShow;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTStringMatrix;
import animal.misc.MessageDisplay;
import animalscript.core.BasicParser;
import animalscript.extensions.GridMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MatrixProducer
extends BasicParser {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_MATRIX = 1;
    public static final int STYLE_TABLE = 2;
    public static final int ALIGN_LEFT = 110;
    public static final int ALIGN_CENTER = 111;
    public static final int ALIGN_RIGHT = 112;
    public static final int DEFAULT_INT = -1;
    public static final Color DEFAULT_COLOR = null;
    public static final Font DEFAULT_FONT = null;
    public static final String DEFAULT_UNIT = null;

    private static final String gridLocationKey(String gridName) {
        return String.valueOf(gridName) + ".location";
    }

    private static final String gridStyleKey(String gridName) {
        return String.valueOf(gridName) + ".style";
    }

    private static final String gridSizeKey(String gridName) {
        return String.valueOf(gridName) + ".size";
    }

    private static final String gridDepthKey(String gridName) {
        return String.valueOf(gridName) + ".depth";
    }

    private static final String gridCellWidthKey(String gridName) {
        return String.valueOf(gridName) + ".cellWidth";
    }

    private static final String gridMaxCellWidthKey(String gridName) {
        return String.valueOf(gridName) + ".maxCellWidth";
    }

    private static final String gridCellHeightKey(String gridName) {
        return String.valueOf(gridName) + ".cellHeight";
    }

    private static final String gridMaxCellHeightKey(String gridName) {
        return String.valueOf(gridName) + ".maxCellHeight";
    }

    private static final String gridTextKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text";
    }

    private static final String gridTextStringKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.string";
    }

    private static final String gridTextFontKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.font";
    }

    private static final String gridTextPositionKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.position";
    }

    private static final String gridBackKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].background";
    }

    private static final String gridBackPositionKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].background.position";
    }

    private static final String gridBackSizeKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].background.size";
    }

    private static final String gridBracketKey(String gridName, int part) {
        return String.valueOf(gridName) + ".bracket[" + part + "]";
    }

    private static final String gridBracketPositionKey(String gridName, int part) {
        return String.valueOf(gridName) + ".bracket[" + part + "].position";
    }

    private static final String gridTextAlignmentKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].text.alignment";
    }

    private static final String gridTextColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].textColor";
    }

    private static final String gridHighlightTextColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].hlTextColor";
    }

    private static final String gridFillColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].fillColor";
    }

    private static final String gridHighlightFillColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].hlFillColor";
    }

    private static final String gridBorderColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].borderColor";
    }

    private static final String gridHighlightBorderColorKey(String gridName, int line, int column) {
        return String.valueOf(gridName) + ".cell[" + line + "][" + column + "].hlBorderColor";
    }

    private static void collectObjectMovements(int objectID, int dx, int dy, Hashtable<String, Vector<Integer>> objects) {
        if (dx == 0 && dy == 0) {
            return;
        }
        Vector<Integer> objectsToMove = new Vector<Integer>();
        if (objects.containsKey(String.valueOf(dx) + "," + dy)) {
            objectsToMove = objects.get(String.valueOf(dx) + "," + dy);
        }
        objectsToMove.add(new Integer(objectID));
        objects.put(String.valueOf(dx) + "," + dy, objectsToMove);
    }

    public static void makeGrid(String gridName, Point basePoint, int lines, int cols, int cellWidth, int maxCellWidth, int cellHeight, int maxCellHeight, boolean fixedCellSize, Color genericColor, Color textColor, Color fillColor, Color borderColor, Color hTextColor, Color hFillColor, Color hBorderColor, int style, Font font, int alignment, int depth, int delay, int duration, String unit) {
        PTStringMatrix matrix = new PTStringMatrix(lines, cols);
        matrix.setLocation(basePoint);
        matrix.setColor(genericColor);
        matrix.setDepth(depth);
        matrix.setFillColor(fillColor);
        matrix.setFilled(true);
        matrix.setFont(font);
        matrix.setHighlightColor(hFillColor);
        matrix.setTextColor(textColor);
        BasicParser.addGraphicObject(matrix, anim);
        MatrixProducer.getObjectIDs().put(gridName, matrix.getNum(false));
        System.err.println(MatrixProducer.getObjectIDs().getIntProperty(gridName));
        TimedShow showMatrix = new TimedShow(currentStep, matrix.getNum(false), duration, "show", delay >= 0);
        showMatrix.setOffset(delay);
        if (unit == null) {
            unit = "ticks";
        }
        showMatrix.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
        matrix.setElementAt(0, 0, "Hello World");
        matrix.setElementAt(0, 1, "256");
        BasicParser.addAnimatorToAnimation(showMatrix, anim);
    }

    public static void setGridValue(String gridName, int line, int column, String value, int step, int duration, int offset, String unit, boolean refresh) {
        int gridID = MatrixProducer.getObjectIDs().getIntProperty(gridName);
        PTGraphicObject ptgo = animState.getCloneByNum(gridID);
        if (!(ptgo instanceof PTStringMatrix)) {
            return;
        }
        PTStringMatrix matrix = (PTStringMatrix)ptgo;
        if (matrix.getMaxColumnCount() >= column && matrix.getRowCount() >= line) {
            matrix.setElementAt(line, column, value);
        }
    }

    public static void setGridColor(String gridName, int line, int column, Color genericColor, Color textColor, Color fillColor, Color borderColor, Color highlightTextColor, Color highlightFillColor, Color highlightBorderColor, int step, int duration, int offset, String unit) {
        int[] size = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        if (textColor == null) {
            textColor = genericColor;
        }
        if (line == -1) {
            if (column == -1) {
                int c;
                int[] textNumsToColor = new int[size[0] * size[1]];
                int[] cellNumsToColor = new int[size[0] * size[1]];
                int l = 0;
                while (l < size[0]) {
                    c = 0;
                    while (c < size[1]) {
                        textNumsToColor[l * size[1] + c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, c));
                        cellNumsToColor[l * size[1] + c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, c));
                        ++c;
                    }
                    ++l;
                }
                if (textColor != null) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextColorKey(gridName, l, c), textColor);
                            ++c;
                        }
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (fillColor != null) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            MatrixProducer.getObjectProperties().put(MatrixProducer.gridFillColorKey(gridName, l, c), fillColor);
                            ++c;
                        }
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (borderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            MatrixProducer.getObjectProperties().put(MatrixProducer.gridBorderColorKey(gridName, l, c), borderColor);
                            ++c;
                        }
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (highlightTextColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightTextColorKey(gridName, l, c), highlightTextColor);
                            ++c;
                        }
                        ++l;
                    }
                }
                if (highlightFillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightFillColorKey(gridName, l, c), highlightFillColor);
                            ++c;
                        }
                        ++l;
                    }
                }
                if (highlightBorderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        c = 0;
                        while (c < size[1]) {
                            MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightBorderColorKey(gridName, l, c), highlightBorderColor);
                            ++c;
                        }
                        ++l;
                    }
                }
            } else {
                int[] textNumsToColor = new int[size[0]];
                int[] cellNumsToColor = new int[size[0]];
                int l = 0;
                while (l < size[0]) {
                    textNumsToColor[l] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, column));
                    cellNumsToColor[l] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, column));
                    ++l;
                }
                if (textColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextColorKey(gridName, l, column), textColor);
                        ++l;
                    }
                }
                if (fillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridFillColorKey(gridName, l, column), fillColor);
                        ++l;
                    }
                }
                if (textColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextColorKey(gridName, l, column), textColor);
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (fillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridFillColorKey(gridName, l, column), fillColor);
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (borderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridBorderColorKey(gridName, l, column), borderColor);
                        ++l;
                    }
                    ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                    setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                    setColorAnimator.setOffset(offset);
                    BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
                }
                if (highlightTextColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightTextColorKey(gridName, l, column), highlightTextColor);
                        ++l;
                    }
                }
                if (highlightFillColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightFillColorKey(gridName, l, column), highlightFillColor);
                        ++l;
                    }
                }
                if (highlightBorderColor != DEFAULT_COLOR) {
                    l = 0;
                    while (l < size[0]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightBorderColorKey(gridName, l, column), highlightBorderColor);
                        ++l;
                    }
                }
            }
        } else if (column == -1) {
            int[] textNumsToColor = new int[size[1]];
            int[] cellNumsToColor = new int[size[1]];
            int c = 0;
            while (c < size[1]) {
                textNumsToColor[c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, c));
                cellNumsToColor[c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, c));
                ++c;
            }
            if (textColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextColorKey(gridName, line, c), textColor);
                    ++c;
                }
                ColorChanger setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (fillColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridFillColorKey(gridName, line, c), fillColor);
                    ++c;
                }
                ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (borderColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridBorderColorKey(gridName, line, c), borderColor);
                    ++c;
                }
                ColorChanger setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (highlightTextColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightTextColorKey(gridName, line, c), highlightTextColor);
                    ++c;
                }
            }
            if (highlightFillColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightFillColorKey(gridName, line, c), highlightFillColor);
                    ++c;
                }
            }
            if (highlightBorderColor != DEFAULT_COLOR) {
                c = 0;
                while (c < size[1]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightBorderColorKey(gridName, line, c), highlightBorderColor);
                    ++c;
                }
            }
        } else {
            ColorChanger setColorAnimator;
            int[] textNumsToColor = new int[]{MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, column))};
            int[] cellNumsToColor = new int[]{MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, column))};
            if (textColor != DEFAULT_COLOR) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextColorKey(gridName, line, column), textColor);
                setColorAnimator = new ColorChanger(step, textNumsToColor, duration, "color", textColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (fillColor != DEFAULT_COLOR) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridFillColorKey(gridName, line, column), fillColor);
                setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "fillcolor", fillColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (borderColor != DEFAULT_COLOR) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridBorderColorKey(gridName, line, column), borderColor);
                setColorAnimator = new ColorChanger(step, cellNumsToColor, duration, "color", borderColor);
                setColorAnimator.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                setColorAnimator.setOffset(offset);
                BasicParser.addAnimatorToAnimation(setColorAnimator, anim);
            }
            if (highlightTextColor != DEFAULT_COLOR) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightTextColorKey(gridName, line, column), highlightTextColor);
            }
            if (highlightFillColor != DEFAULT_COLOR) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightFillColorKey(gridName, line, column), highlightFillColor);
            }
            if (highlightBorderColor != DEFAULT_COLOR) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridHighlightBorderColorKey(gridName, line, column), highlightBorderColor);
            }
        }
    }

    public static void swapGridValues(String gridName1, int line1, int col1, String gridName2, int line2, int col2, int step, int duration, int offset, String unit, boolean refresh) {
        int[] objects2;
        int[] objects1;
        int[] size1 = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName1));
        int[] size2 = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName2));
        if (line1 >= size1[0] || col1 >= size1[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName1 + "[" + line1 + "][" + col1 + "] is out of bounds. Valid cells are [0.." + size1[0] + "][0.." + size1[1], 4);
            return;
        }
        if (line2 >= size2[0] || col2 >= size2[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName2 + "[" + line2 + "][" + col2 + "] is out of bounds. Valid cells are [0.." + size2[0] + "][0.." + size2[1], 4);
            return;
        }
        if (line1 * line2 < 0 || col1 * col2 < 0) {
            MessageDisplay.errorMsg("Invalid coordinates for swapgridvalues. Maybe you try to swap a value and a column.", 4);
            return;
        }
        if (line1 == -1) {
            int l;
            if (col1 == -1) {
                if (size1[0] != size2[0] || size1[1] != size2[1]) {
                    MessageDisplay.errorMsg("Cannot swap all values of '" + gridName1 + "' and '" + gridName2 + "' because of different gridsizes", 4);
                    return;
                }
                objects1 = new int[size1[0] * size1[1]];
                objects2 = new int[size1[0] * size1[1]];
                l = 0;
                while (l < size1[0]) {
                    int c = 0;
                    while (c < size1[1]) {
                        String value1 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName1, l, c));
                        String value2 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName2, l, c));
                        MatrixProducer.setGridValue(gridName1, l, c, value2, step, 0, duration + offset, unit, false);
                        MatrixProducer.setGridValue(gridName2, l, c, value1, step, 0, duration + offset, unit, false);
                        objects1[l + c * size1[0]] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName1, l, c));
                        objects2[l + c * size1[0]] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName2, l, c));
                        ++c;
                    }
                    ++l;
                }
            } else {
                if (size1[0] != size2[0]) {
                    MessageDisplay.errorMsg("Cannot swap column '" + col1 + "' of '" + gridName1 + "' and column '" + col1 + "' of '" + gridName2 + "' because of different sizes", 4);
                    return;
                }
                objects1 = new int[size1[0]];
                objects2 = new int[size1[0]];
                l = 0;
                while (l < size1[0]) {
                    String value1 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName1, l, col1));
                    String value2 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName2, l, col2));
                    MatrixProducer.setGridValue(gridName1, l, col1, value2, step, 0, duration + offset, unit, false);
                    MatrixProducer.setGridValue(gridName2, l, col2, value1, step, 0, duration + offset, unit, false);
                    objects1[l] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName1, l, col1));
                    objects2[l] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName2, l, col2));
                    ++l;
                }
            }
        } else if (col1 == -1) {
            if (size1[1] != size2[1]) {
                MessageDisplay.errorMsg("Cannot swap line '" + line1 + "' of '" + gridName1 + "' and line '" + line1 + "' of '" + gridName2 + "' because of different sizes", 4);
                return;
            }
            objects1 = new int[size1[1]];
            objects2 = new int[size1[1]];
            int c = 0;
            while (c < size1[1]) {
                String value1 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName1, line1, c));
                String value2 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName2, line2, c));
                MatrixProducer.setGridValue(gridName1, line1, c, value2, step, 0, duration + offset, unit, false);
                MatrixProducer.setGridValue(gridName2, line2, c, value1, step, 0, duration + offset, unit, false);
                objects1[c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName1, line1, c));
                objects2[c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName2, line2, c));
                ++c;
            }
        } else {
            String value1 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName1, line1, col1));
            String value2 = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName2, line2, col2));
            MatrixProducer.setGridValue(gridName1, line1, col1, value2, step, 0, duration + offset, unit, false);
            MatrixProducer.setGridValue(gridName2, line2, col2, value1, step, 0, duration + offset, unit, false);
            objects1 = new int[]{MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName1, line1, col1))};
            objects2 = new int[]{MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName2, line2, col2))};
        }
        if (line1 < 0) {
            line1 = 0;
        }
        if (line2 < 0) {
            line2 = 0;
        }
        if (col1 < 0) {
            col1 = 0;
        }
        if (col2 < 0) {
            col2 = 0;
        }
        if (duration > 0) {
            PTPoint location1 = new PTPoint(MatrixProducer.getObjectProperties().getPointProperty(MatrixProducer.gridTextPositionKey(gridName1, line1, col1)));
            PTPoint location2 = new PTPoint(MatrixProducer.getObjectProperties().getPointProperty(MatrixProducer.gridTextPositionKey(gridName2, line2, col2)));
            PTPolyline moveBase1to2 = new PTPolyline();
            moveBase1to2.addNode(location1);
            moveBase1to2.addNode(location2);
            moveBase1to2.setColor(new Color(1.0f, 1.0f, 0.0f));
            moveBase1to2.setDepth(0);
            int mb12Num = moveBase1to2.getNum(true);
            MatrixProducer.getObjectIDs().put("mb12_step" + step, mb12Num);
            MatrixProducer.getObjectTypes().put("mb12_step" + step, "polyline");
            BasicParser.addGraphicObject(moveBase1to2, anim);
            PTPolyline moveBase2to1 = new PTPolyline();
            moveBase2to1.addNode(location2);
            moveBase2to1.addNode(location1);
            moveBase2to1.setColor(new Color(1.0f, 1.0f, 0.0f));
            moveBase2to1.setDepth(0);
            int mb21Num = moveBase2to1.getNum(true);
            MatrixProducer.getObjectIDs().put("mb21_step" + step, mb21Num);
            MatrixProducer.getObjectTypes().put("mb21_step" + step, "polyline");
            BasicParser.addGraphicObject(moveBase2to1, anim);
            Move move1to2 = new Move(step, objects1, duration, "translate", mb12Num);
            move1to2.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            move1to2.setOffset(offset);
            Move move2to1 = new Move(step, objects2, duration, "translate", mb21Num);
            move2to1.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            move2to1.setOffset(offset);
            BasicParser.addAnimatorToAnimation(move1to2, anim);
            BasicParser.addAnimatorToAnimation(move2to1, anim);
            Move back2to1 = new Move(step, objects1, 0, "translate", mb21Num);
            back2to1.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            back2to1.setOffset(offset + duration);
            Move back1to2 = new Move(step, objects2, 0, "translate", mb12Num);
            back1to2.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            back1to2.setOffset(offset + duration);
            BasicParser.addAnimatorToAnimation(back1to2, anim);
            BasicParser.addAnimatorToAnimation(back2to1, anim);
        }
        if (refresh) {
            MatrixProducer.refreshGrid(gridName1, step, duration, offset, unit);
            MatrixProducer.refreshGrid(gridName2, step, duration, offset, unit);
        }
    }

    public static void highlightGridCell(String gridName, int line, int column, int step, int duration, int offset, String unit) {
        String currentBorderHLColor;
        String currentTextHLColor;
        String currentBackHLColor;
        int[] size = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        Hashtable backgroundsToHighlight = new Hashtable();
        Hashtable textObjectsToHighlight = new Hashtable();
        Hashtable bordersToHighlight = new Hashtable();
        if (line == -1) {
            int l;
            if (column == -1) {
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, l, c)).getRGB());
                        if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                            backgroundsToHighlight.put(currentBackHLColor, new Vector());
                        }
                        ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, c)));
                        currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, l, c)).getRGB());
                        if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                            textObjectsToHighlight.put(currentTextHLColor, new Vector());
                        }
                        ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, c)));
                        currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, l, c)).getRGB());
                        if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                            bordersToHighlight.put(currentBorderHLColor, new Vector());
                        }
                        ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, c)));
                        ++c;
                    }
                    ++l;
                }
            } else {
                l = 0;
                while (l < size[0]) {
                    currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, l, column)).getRGB());
                    if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                        backgroundsToHighlight.put(currentBackHLColor, new Vector());
                    }
                    ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, column)));
                    currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, l, column)).getRGB());
                    if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                        textObjectsToHighlight.put(currentTextHLColor, new Vector());
                    }
                    ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, column)));
                    currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, l, column)).getRGB());
                    if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                        bordersToHighlight.put(currentBorderHLColor, new Vector());
                    }
                    ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, column)));
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, line, c)).getRGB());
                if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                    backgroundsToHighlight.put(currentBackHLColor, new Vector());
                }
                ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, c)));
                currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, line, c)).getRGB());
                if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                    textObjectsToHighlight.put(currentTextHLColor, new Vector());
                }
                ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, c)));
                currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, line, c)).getRGB());
                if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                    bordersToHighlight.put(currentBorderHLColor, new Vector());
                }
                ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, c)));
                ++c;
            }
        } else {
            currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, line, column)).getRGB());
            if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                backgroundsToHighlight.put(currentBackHLColor, new Vector());
            }
            ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, column)));
            currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, line, column)).getRGB());
            if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                textObjectsToHighlight.put(currentTextHLColor, new Vector());
            }
            ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, column)));
            currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, line, column)).getRGB());
            if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                bordersToHighlight.put(currentBorderHLColor, new Vector());
            }
            ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, column)));
        }
        Enumeration collectedBackgroundHighlightColorKeys = backgroundsToHighlight.keys();
        while (collectedBackgroundHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBackgroundHighlightColorKeys.nextElement();
            Vector backgrounds = (Vector)backgroundsToHighlight.get(currentHLColor);
            int[] backgroundIDs = new int[backgrounds.size()];
            int i = 0;
            while (i < backgroundIDs.length) {
                backgroundIDs[i] = (Integer)backgrounds.get(i);
                ++i;
            }
            ColorChanger backgroundHL = new ColorChanger(step, backgroundIDs, duration, "fillcolor", new Color(Integer.parseInt(currentHLColor)));
            backgroundHL.setOffset(offset);
            backgroundHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(backgroundHL, anim);
        }
        Enumeration collectedTextObjectHighlightColorKeys = textObjectsToHighlight.keys();
        while (collectedTextObjectHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedTextObjectHighlightColorKeys.nextElement();
            Vector textObjects = (Vector)textObjectsToHighlight.get(currentHLColor);
            int[] textObjectIDs = new int[textObjects.size()];
            int i = 0;
            while (i < textObjectIDs.length) {
                textObjectIDs[i] = (Integer)textObjects.get(i);
                ++i;
            }
            ColorChanger textObjectHL = new ColorChanger(step, textObjectIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            textObjectHL.setOffset(offset);
            textObjectHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(textObjectHL, anim);
        }
        Enumeration collectedBorderHighlightColorKeys = bordersToHighlight.keys();
        while (collectedBorderHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBorderHighlightColorKeys.nextElement();
            Vector borders = (Vector)bordersToHighlight.get(currentHLColor);
            int[] borderIDs = new int[borders.size()];
            int i = 0;
            while (i < borderIDs.length) {
                borderIDs[i] = (Integer)borders.get(i);
                ++i;
            }
            ColorChanger borderHL = new ColorChanger(step, borderIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            borderHL.setOffset(offset);
            borderHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(borderHL, anim);
        }
    }

    public static void highlightGridElem(String gridName, int line, int column, int step, int duration, int offset, String unit) {
        String currentBorderHLColor;
        String currentTextHLColor;
        String currentBackHLColor;
        int[] size = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        Hashtable backgroundsToHighlight = new Hashtable();
        Hashtable textObjectsToHighlight = new Hashtable();
        Hashtable bordersToHighlight = new Hashtable();
        if (line == -1) {
            int l;
            if (column == -1) {
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, l, c)).getRGB());
                        if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                            backgroundsToHighlight.put(currentBackHLColor, new Vector());
                        }
                        ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, c)));
                        currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, l, c)).getRGB());
                        if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                            textObjectsToHighlight.put(currentTextHLColor, new Vector());
                        }
                        ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, c)));
                        currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, l, c)).getRGB());
                        if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                            bordersToHighlight.put(currentBorderHLColor, new Vector());
                        }
                        ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, c)));
                        ++c;
                    }
                    ++l;
                }
            } else {
                l = 0;
                while (l < size[0]) {
                    currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, l, column)).getRGB());
                    if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                        backgroundsToHighlight.put(currentBackHLColor, new Vector());
                    }
                    ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, column)));
                    currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, l, column)).getRGB());
                    if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                        textObjectsToHighlight.put(currentTextHLColor, new Vector());
                    }
                    ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, column)));
                    currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, l, column)).getRGB());
                    if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                        bordersToHighlight.put(currentBorderHLColor, new Vector());
                    }
                    ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, column)));
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, line, c)).getRGB());
                if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                    backgroundsToHighlight.put(currentBackHLColor, new Vector());
                }
                ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, c)));
                currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, line, c)).getRGB());
                if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                    textObjectsToHighlight.put(currentTextHLColor, new Vector());
                }
                ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, c)));
                currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, line, c)).getRGB());
                if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                    bordersToHighlight.put(currentBorderHLColor, new Vector());
                }
                ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, c)));
                ++c;
            }
        } else {
            currentBackHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightFillColorKey(gridName, line, column)).getRGB());
            if (!backgroundsToHighlight.containsKey(currentBackHLColor)) {
                backgroundsToHighlight.put(currentBackHLColor, new Vector());
            }
            ((Vector)backgroundsToHighlight.get(currentBackHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, column)));
            currentTextHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightTextColorKey(gridName, line, column)).getRGB());
            if (!textObjectsToHighlight.containsKey(currentTextHLColor)) {
                textObjectsToHighlight.put(currentTextHLColor, new Vector());
            }
            ((Vector)textObjectsToHighlight.get(currentTextHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, column)));
            currentBorderHLColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridHighlightBorderColorKey(gridName, line, column)).getRGB());
            if (!bordersToHighlight.containsKey(currentBorderHLColor)) {
                bordersToHighlight.put(currentBorderHLColor, new Vector());
            }
            ((Vector)bordersToHighlight.get(currentBorderHLColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, column)));
        }
        Enumeration collectedBackgroundHighlightColorKeys = backgroundsToHighlight.keys();
        while (collectedBackgroundHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBackgroundHighlightColorKeys.nextElement();
            Vector backgrounds = (Vector)backgroundsToHighlight.get(currentHLColor);
            int[] backgroundIDs = new int[backgrounds.size()];
            int i = 0;
            while (i < backgroundIDs.length) {
                backgroundIDs[i] = (Integer)backgrounds.get(i);
                ++i;
            }
            ColorChanger backgroundHL = new ColorChanger(step, backgroundIDs, duration, "fillcolor", new Color(Integer.parseInt(currentHLColor)));
            backgroundHL.setOffset(offset);
            backgroundHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(backgroundHL, anim);
        }
        Enumeration collectedTextObjectHighlightColorKeys = textObjectsToHighlight.keys();
        while (collectedTextObjectHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedTextObjectHighlightColorKeys.nextElement();
            Vector textObjects = (Vector)textObjectsToHighlight.get(currentHLColor);
            int[] textObjectIDs = new int[textObjects.size()];
            int i = 0;
            while (i < textObjectIDs.length) {
                textObjectIDs[i] = (Integer)textObjects.get(i);
                ++i;
            }
            ColorChanger textObjectHL = new ColorChanger(step, textObjectIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            textObjectHL.setOffset(offset);
            textObjectHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(textObjectHL, anim);
        }
        Enumeration collectedBorderHighlightColorKeys = bordersToHighlight.keys();
        while (collectedBorderHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBorderHighlightColorKeys.nextElement();
            Vector borders = (Vector)bordersToHighlight.get(currentHLColor);
            int[] borderIDs = new int[borders.size()];
            int i = 0;
            while (i < borderIDs.length) {
                borderIDs[i] = (Integer)borders.get(i);
                ++i;
            }
            ColorChanger borderHL = new ColorChanger(step, borderIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            borderHL.setOffset(offset);
            borderHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(borderHL, anim);
        }
    }

    public static void unhighlightGridCell(String gridName, int line, int column, int step, int duration, int offset, String unit) {
        String currentBorderColor;
        String currentTextColor;
        String currentFillColor;
        int[] size = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        Hashtable backgroundsToUnhighlight = new Hashtable();
        Hashtable textObjectsToUnhighlight = new Hashtable();
        Hashtable bordersToUnhighlight = new Hashtable();
        if (line == -1) {
            int l;
            if (column == -1) {
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        currentFillColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridFillColorKey(gridName, l, c)).getRGB());
                        if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                            backgroundsToUnhighlight.put(currentFillColor, new Vector());
                        }
                        ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, c)));
                        currentTextColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridTextColorKey(gridName, l, c)).getRGB());
                        if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                            textObjectsToUnhighlight.put(currentTextColor, new Vector());
                        }
                        ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, c)));
                        currentBorderColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridBorderColorKey(gridName, l, c)).getRGB());
                        if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                            bordersToUnhighlight.put(currentBorderColor, new Vector());
                        }
                        ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, c)));
                        ++c;
                    }
                    ++l;
                }
            } else {
                l = 0;
                while (l < size[0]) {
                    currentFillColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridFillColorKey(gridName, l, column)).getRGB());
                    if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                        backgroundsToUnhighlight.put(currentFillColor, new Vector());
                    }
                    ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, column)));
                    currentTextColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridTextColorKey(gridName, l, column)).getRGB());
                    if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                        textObjectsToUnhighlight.put(currentTextColor, new Vector());
                    }
                    ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, column)));
                    currentBorderColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridBorderColorKey(gridName, l, column)).getRGB());
                    if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                        bordersToUnhighlight.put(currentBorderColor, new Vector());
                    }
                    ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l, column)));
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                currentFillColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridFillColorKey(gridName, line, c)).getRGB());
                if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                    backgroundsToUnhighlight.put(currentFillColor, new Vector());
                }
                ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, c)));
                currentTextColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridTextColorKey(gridName, line, c)).getRGB());
                if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                    textObjectsToUnhighlight.put(currentTextColor, new Vector());
                }
                ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, c)));
                currentBorderColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridBorderColorKey(gridName, line, c)).getRGB());
                if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                    bordersToUnhighlight.put(currentBorderColor, new Vector());
                }
                ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, c)));
                ++c;
            }
        } else {
            currentFillColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridFillColorKey(gridName, line, column)).getRGB());
            if (!backgroundsToUnhighlight.containsKey(currentFillColor)) {
                backgroundsToUnhighlight.put(currentFillColor, new Vector());
            }
            ((Vector)backgroundsToUnhighlight.get(currentFillColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, column)));
            currentTextColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridTextColorKey(gridName, line, column)).getRGB());
            if (!textObjectsToUnhighlight.containsKey(currentTextColor)) {
                textObjectsToUnhighlight.put(currentTextColor, new Vector());
            }
            ((Vector)textObjectsToUnhighlight.get(currentTextColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, column)));
            currentBorderColor = String.valueOf(MatrixProducer.getObjectProperties().getColorProperty(MatrixProducer.gridBorderColorKey(gridName, line, column)).getRGB());
            if (!bordersToUnhighlight.containsKey(currentBorderColor)) {
                bordersToUnhighlight.put(currentBorderColor, new Vector());
            }
            ((Vector)bordersToUnhighlight.get(currentBorderColor)).add(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, line, column)));
        }
        Enumeration collectedBackgroundHighlightColorKeys = backgroundsToUnhighlight.keys();
        while (collectedBackgroundHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBackgroundHighlightColorKeys.nextElement();
            Vector backgrounds = (Vector)backgroundsToUnhighlight.get(currentHLColor);
            int[] backgroundIDs = new int[backgrounds.size()];
            int i = 0;
            while (i < backgroundIDs.length) {
                backgroundIDs[i] = (Integer)backgrounds.get(i);
                ++i;
            }
            ColorChanger backgroundUnHL = new ColorChanger(step, backgroundIDs, duration, "fillcolor", new Color(Integer.parseInt(currentHLColor)));
            backgroundUnHL.setOffset(offset);
            backgroundUnHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(backgroundUnHL, anim);
        }
        Enumeration collectedTextObjectHighlightColorKeys = textObjectsToUnhighlight.keys();
        while (collectedTextObjectHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedTextObjectHighlightColorKeys.nextElement();
            Vector textObjects = (Vector)textObjectsToUnhighlight.get(currentHLColor);
            int[] textObjectIDs = new int[textObjects.size()];
            int i = 0;
            while (i < textObjectIDs.length) {
                textObjectIDs[i] = (Integer)textObjects.get(i);
                ++i;
            }
            ColorChanger textObjectUnHL = new ColorChanger(step, textObjectIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            textObjectUnHL.setOffset(offset);
            textObjectUnHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(textObjectUnHL, anim);
        }
        Enumeration collectedBorderHighlightColorKeys = bordersToUnhighlight.keys();
        while (collectedBorderHighlightColorKeys.hasMoreElements()) {
            String currentHLColor = (String)collectedBorderHighlightColorKeys.nextElement();
            Vector borders = (Vector)bordersToUnhighlight.get(currentHLColor);
            int[] borderIDs = new int[borders.size()];
            int i = 0;
            while (i < borderIDs.length) {
                borderIDs[i] = (Integer)borders.get(i);
                ++i;
            }
            ColorChanger borderUnHL = new ColorChanger(step, borderIDs, duration, "color", new Color(Integer.parseInt(currentHLColor)));
            borderUnHL.setOffset(offset);
            borderUnHL.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addAnimatorToAnimation(borderUnHL, anim);
        }
    }

    public static void alignGridValue(String gridName, int line, int column, int alignment, int step, int duration, int offset, String unit) {
        int[] size = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        if (line == -1) {
            if (column == -1) {
                int l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (c < size[1]) {
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextAlignmentKey(gridName, l, c), alignment);
                        ++c;
                    }
                    ++l;
                }
            } else {
                int l = 0;
                while (l < size[0]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextAlignmentKey(gridName, l, column), alignment);
                    ++l;
                }
            }
        } else if (column == -1) {
            int c = 0;
            while (c < size[1]) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextAlignmentKey(gridName, line, c), alignment);
                ++c;
            }
        } else {
            MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextAlignmentKey(gridName, line, column), alignment);
        }
        MatrixProducer.refreshGrid(gridName, step, duration, offset, unit);
    }

    public static void setGridFont(String gridName, int line, int column, Font newFont, int step, int duration, int offset, String unit, boolean refresh) {
        int[] cellFontsToUpdate;
        int[] size = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName));
        if (line >= size[0] || column >= size[1]) {
            MessageDisplay.errorMsg("Grid index " + gridName + "[" + line + "][" + column + "] is out of bounds. Valid cells are [0.." + size[0] + "][0.." + size[1], 4);
            return;
        }
        if (line == -1) {
            int l;
            if (column == -1) {
                cellFontsToUpdate = new int[size[0] * size[1]];
                l = 0;
                while (l < size[0]) {
                    int c = 0;
                    while (l < size[1]) {
                        cellFontsToUpdate[l * size[1] + c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, c));
                        MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextFontKey(gridName, l, c), newFont);
                        ++c;
                    }
                    ++l;
                }
            } else {
                cellFontsToUpdate = new int[size[0]];
                l = 0;
                while (l < size[0]) {
                    MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextFontKey(gridName, l, column), newFont);
                    cellFontsToUpdate[l] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l, column));
                    ++l;
                }
            }
        } else if (column == -1) {
            cellFontsToUpdate = new int[size[1]];
            int c = 0;
            while (c < size[1]) {
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextFontKey(gridName, line, c), newFont);
                cellFontsToUpdate[c] = MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, c));
                ++c;
            }
        } else {
            cellFontsToUpdate = new int[]{MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, line, column))};
            MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextFontKey(gridName, line, column), newFont);
        }
        SetFont setFont = new SetFont(step, cellFontsToUpdate, 0, offset + duration, unit, newFont);
        BasicParser.addAnimatorToAnimation(setFont, anim);
        if (refresh) {
            MatrixProducer.refreshGrid(gridName, step, duration, offset, unit);
        }
    }

    public static void refreshGrid(String gridName, int step, int duration, int offset, String unit) {
        Point currentCoords;
        Point location = MatrixProducer.getObjectProperties().getPointProperty(MatrixProducer.gridLocationKey(gridName));
        int style = MatrixProducer.getObjectProperties().getIntProperty(MatrixProducer.gridStyleKey(gridName));
        int minHeight = MatrixProducer.getObjectProperties().getIntProperty(MatrixProducer.gridCellHeightKey(gridName));
        int maxHeight = MatrixProducer.getObjectProperties().getIntProperty(MatrixProducer.gridMaxCellHeightKey(gridName));
        int minWidth = MatrixProducer.getObjectProperties().getIntProperty(MatrixProducer.gridCellWidthKey(gridName));
        int maxWidth = MatrixProducer.getObjectProperties().getIntProperty(MatrixProducer.gridMaxCellWidthKey(gridName));
        int[] size = MatrixProducer.getObjectProperties().getIntArrayProperty(MatrixProducer.gridSizeKey(gridName));
        int[] lineHeights = new int[size[0]];
        int[] colWidths = new int[size[1]];
        String[][] values = new String[size[0]][size[1]];
        Font[][] fonts = new Font[size[0]][size[1]];
        int[][] alignments = new int[size[0]][size[1]];
        int[][][] textPositions = new int[size[0]][size[1]][2];
        int[][][] backPositions = new int[size[0]][size[1]][4];
        int[][] bracketPositions = new int[6][6];
        int l = 0;
        while (l < size[0]) {
            int c = 0;
            while (c < size[1]) {
                Font currentFont = MatrixProducer.getObjectProperties().getFontProperty(MatrixProducer.gridTextFontKey(gridName, l, c));
                String currentValue = MatrixProducer.getObjectProperties().getProperty(MatrixProducer.gridTextStringKey(gridName, l, c));
                if (currentFont == null) {
                    System.err.println("Font unter Key '" + MatrixProducer.gridTextFontKey(gridName, l, c) + "' gleich null");
                    System.err.println("Existiert Key? " + MatrixProducer.getObjectProperties().containsKey(MatrixProducer.gridTextFontKey(gridName, l, c)));
                }
                fonts[l][c] = currentFont;
                values[l][c] = currentValue;
                alignments[l][c] = MatrixProducer.getObjectProperties().getIntProperty(MatrixProducer.gridTextAlignmentKey(gridName, l, c));
                ++c;
            }
            ++l;
        }
        GridMath.calculateLineHeights(lineHeights, fonts, minHeight, maxHeight, style);
        GridMath.calculateColumnWidths(colWidths, values, fonts, minWidth, maxWidth, style);
        GridMath.calculateTextPositions(textPositions, values, fonts, alignments, colWidths, lineHeights, location, style);
        GridMath.calculateBackgroundPositions(backPositions, colWidths, lineHeights, location, style);
        GridMath.calculateBracketPositions(bracketPositions, colWidths, lineHeights, location, style);
        Hashtable<String, Vector<Integer>> collectedMoves = new Hashtable<String, Vector<Integer>>();
        Hashtable<String, Vector<Integer>> collectedResizes = new Hashtable<String, Vector<Integer>>();
        int l2 = 0;
        while (l2 < size[0]) {
            int c = 0;
            while (c < size[1]) {
                currentCoords = MatrixProducer.getObjectProperties().getPointProperty(MatrixProducer.gridTextPositionKey(gridName, l2, c));
                MatrixProducer.collectObjectMovements(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridTextKey(gridName, l2, c)), textPositions[l2][c][0] - currentCoords.x, textPositions[l2][c][1] - currentCoords.y, collectedMoves);
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridTextPositionKey(gridName, l2, c), new Point(textPositions[l2][c][0], textPositions[l2][c][1]));
                currentCoords = MatrixProducer.getObjectProperties().getPointProperty(MatrixProducer.gridBackPositionKey(gridName, l2, c));
                MatrixProducer.collectObjectMovements(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l2, c)), backPositions[l2][c][0] - currentCoords.x, backPositions[l2][c][1] - currentCoords.y, collectedMoves);
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridBackPositionKey(gridName, l2, c), new Point(backPositions[l2][c][0], backPositions[l2][c][1]));
                currentCoords = MatrixProducer.getObjectProperties().getPointProperty(MatrixProducer.gridBackSizeKey(gridName, l2, c));
                MatrixProducer.collectObjectMovements(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBackKey(gridName, l2, c)), backPositions[l2][c][2] - currentCoords.x, backPositions[l2][c][3] - currentCoords.y, collectedResizes);
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridBackSizeKey(gridName, l2, c), new Point(backPositions[l2][c][2], backPositions[l2][c][3]));
                ++c;
            }
            ++l2;
        }
        if (style == 1) {
            int dy = bracketPositions[2][1] - MatrixProducer.getObjectProperties().getPointProperty((String)MatrixProducer.gridBracketPositionKey((String)gridName, (int)2)).y;
            int p = 0;
            while (p < 6) {
                currentCoords = MatrixProducer.getObjectProperties().getPointProperty(MatrixProducer.gridBracketPositionKey(gridName, p));
                MatrixProducer.collectObjectMovements(MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBracketKey(gridName, p)), bracketPositions[p][0] - currentCoords.x, bracketPositions[p][1] - currentCoords.y, collectedMoves);
                MatrixProducer.getObjectProperties().put(MatrixProducer.gridBracketPositionKey(gridName, p), new Point(bracketPositions[p][0], bracketPositions[p][1]));
                ++p;
            }
            if (dy != 0) {
                int[] nArray = new int[2];
                nArray[1] = dy;
                PTPolyline bracketStrechMoveBase = new PTPolyline(new int[2], nArray);
                Move bracketStrech = new Move(step, new int[]{MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBracketKey(gridName, 1)), MatrixProducer.getObjectIDs().getIntProperty(MatrixProducer.gridBracketKey(gridName, 4))}, duration, "translateNodes 2", bracketStrechMoveBase.getNum(true));
                bracketStrech.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
                BasicParser.addGraphicObject(bracketStrechMoveBase, anim);
                BasicParser.addAnimatorToAnimation(bracketStrech, anim);
            }
        }
        Enumeration collectedMoveKeys = collectedMoves.keys();
        while (collectedMoveKeys.hasMoreElements()) {
            String currentMovementS = (String)collectedMoveKeys.nextElement();
            Vector objectIDsToMoveV = (Vector)collectedMoves.get(currentMovementS);
            String[] currentMovementArray = currentMovementS.split(",");
            int[] nArray = new int[2];
            nArray[1] = Integer.parseInt(currentMovementArray[0]);
            int[] nArray2 = new int[2];
            nArray2[1] = Integer.parseInt(currentMovementArray[1]);
            PTPolyline currentMoveBase = new PTPolyline(nArray, nArray2);
            currentMoveBase.setDepth(10);
            currentMoveBase.getNum(true);
            int[] objectIDsToMoveA = new int[objectIDsToMoveV.size()];
            int i = 0;
            while (i < objectIDsToMoveA.length) {
                objectIDsToMoveA[i] = (Integer)objectIDsToMoveV.get(i);
                ++i;
            }
            Move currentMoveAnimation = new Move(step, objectIDsToMoveA, duration, "translate", currentMoveBase.getNum(true));
            currentMoveAnimation.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addGraphicObject(currentMoveBase, anim);
            BasicParser.addAnimatorToAnimation(currentMoveAnimation, anim);
        }
        Enumeration collectedResizeKeys = collectedResizes.keys();
        while (collectedResizeKeys.hasMoreElements()) {
            String currentMovementS = (String)collectedResizeKeys.nextElement();
            Vector objectIDsToMoveV = (Vector)collectedResizes.get(currentMovementS);
            String[] currentMovementArray = currentMovementS.split(",");
            int[] nArray = new int[2];
            nArray[1] = Integer.parseInt(currentMovementArray[0]);
            PTPolyline currentMoveBaseX = new PTPolyline(nArray, new int[]{2, 2});
            currentMoveBaseX.setDepth(10);
            currentMoveBaseX.getNum(true);
            currentMoveBaseX.setColor(new Color(0.5f, 0.75f, 0.25f));
            PTPolyline currentMoveBaseY = new PTPolyline(new int[]{3, 3}, new int[]{4, 4 + Integer.parseInt(currentMovementArray[1])});
            currentMoveBaseY.setDepth(10);
            currentMoveBaseY.getNum(true);
            currentMoveBaseY.setColor(new Color(0.5f, 0.75f, 0.25f));
            int[] objectIDsToMoveA = new int[objectIDsToMoveV.size()];
            int i = 0;
            while (i < objectIDsToMoveA.length) {
                objectIDsToMoveA[i] = (Integer)objectIDsToMoveV.get(i);
                ++i;
            }
            Move currentMoveAnimationX = new Move(step, objectIDsToMoveA, duration, "translateNodes 3 4", currentMoveBaseX.getNum(true));
            Move currentMoveAnimationY = new Move(step, objectIDsToMoveA, duration, "translateNodes 2 3", currentMoveBaseY.getNum(true));
            currentMoveAnimationX.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            currentMoveAnimationY.setUnitIsTicks(unit.equalsIgnoreCase("ticks"));
            BasicParser.addGraphicObject(currentMoveBaseX, anim);
            BasicParser.addGraphicObject(currentMoveBaseY, anim);
            BasicParser.addAnimatorToAnimation(currentMoveAnimationX, anim);
            BasicParser.addAnimatorToAnimation(currentMoveAnimationY, anim);
        }
    }
}

