/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.io.IOException;
import java.util.Hashtable;

public class AssertionSupport
extends BasicParser
implements AnimalScriptInterface {
    private static final int IDENTITY = 0;
    private static final int EQUALS = 1;
    private static final int LESS_THAN = 2;
    private static final int GREATER_THAN = 4;
    private static final int INEQUALITY = 16;
    private static final int AND = 64;
    private static final int OR = 128;
    private static final String NUMERIC_TYPE = "numeric";
    private static final String STRING_TYPE = "String";

    public AssertionSupport() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("variable", "parseVariableDeclaration");
        this.rulesHash.put("variable", "variable <id>");
        this.handledKeywords.put("assign", "parseVariableAssignment");
        this.rulesHash.put("assign", "assign <id> = <double> | \"text\"");
        this.handledKeywords.put("assert", "parseAssertion");
        this.handledKeywords.put("check", "parseAssertion");
        this.rulesHash.put("assert", "assert <expression>");
        this.rulesHash.put("check", "see rule for 'assert'");
        this.rulesHash.put("<expression>", "<id> | \"text\" | <expression> && <expression> | <expression> || <expression> | <expression> <comparator> <expression>");
        this.rulesHash.put("<comparator>", "< | <= | == | > | >= | !=");
    }

    @Override
    public boolean generateNewStep(String command) {
        return false;
    }

    public void parseVariableDeclaration() throws IOException {
        ParseSupport.parseWord(stok, "Variable declaration type").toLowerCase();
        String variableName = AnimalParseSupport.parseText(stok, "Variable object name");
        if (ParseSupport.parseOptionalWord(stok, "variable type keyword 'type'", "type")) {
            if (ParseSupport.parseOptionalWord(stok, "variable type", "int")) {
                AssertionSupport.getObjectProperties().put(String.valueOf(variableName) + ".subType", "int");
            } else if (ParseSupport.parseOptionalWord(stok, "variable type", "double")) {
                AssertionSupport.getObjectProperties().put(String.valueOf(variableName) + ".subType", "double");
            } else if (ParseSupport.parseOptionalWord(stok, "variable type", STRING_TYPE)) {
                AssertionSupport.getObjectProperties().put(String.valueOf(variableName) + ".subType", STRING_TYPE);
            }
        }
        AssertionSupport.getObjectProperties().put(String.valueOf(variableName) + ".value", "0");
        AssertionSupport.getObjectTypes().put(variableName, AssertionSupport.getTypeIdentifier("variable"));
    }

    public void parseVariableAssignment() throws IOException {
        String variableValue;
        ParseSupport.parseWord(stok, "Variable assignment type").toLowerCase();
        String variableName = AnimalParseSupport.parseText(stok, "Variable name");
        ParseSupport.parseMandatoryChar(stok, "assignment '=' operator", '=');
        double numericValue = ParseSupport.parseOptionalNumber(stok, "variable assignment value");
        if (numericValue != Double.MAX_VALUE) {
            variableValue = String.valueOf(numericValue);
            AssertionSupport.getObjectProperties().put(String.valueOf(variableName) + ".type", NUMERIC_TYPE);
        } else {
            variableValue = AnimalParseSupport.parseText(stok, "Variable value");
            AssertionSupport.getObjectProperties().put(String.valueOf(variableName) + ".type", STRING_TYPE);
        }
        AssertionSupport.getObjectProperties().put(String.valueOf(variableName) + ".value", variableValue);
    }

    public void parseAssertion() throws IOException {
        int operator = 0;
        ParseSupport.parseWord(stok, "data structure-specific operator");
        StringBuilder operatorString = new StringBuilder(200);
        boolean result = false;
        boolean connectorIsAnd = true;
        boolean useConnector = false;
        boolean lastResult = false;
        while (stok.nextToken() != 10) {
            String compValue;
            stok.pushBack();
            if (ParseSupport.parseOptionalChar(stok, "assertion operator '&&'", '&')) {
                ParseSupport.parseMandatoryChar(stok, "assertion operator '&&'", '&');
                operator = 64;
                connectorIsAnd = true;
                useConnector = true;
                operatorString.append(" && ");
                continue;
            }
            if (ParseSupport.parseOptionalChar(stok, "assertion operator '||'", '|')) {
                ParseSupport.parseMandatoryChar(stok, "assertion operator '||'", '|');
                operator = 128;
                connectorIsAnd = false;
                useConnector = true;
                operatorString.append(" || ");
                continue;
            }
            String variableName = AnimalParseSupport.parseText(stok, "Variable name");
            operatorString.append(variableName).append(" [");
            operatorString.append(AssertionSupport.getObjectProperties().getProperty(String.valueOf(variableName) + ".value", "?"));
            operatorString.append("] ");
            if (ParseSupport.parseOptionalChar(stok, "assertion operator '=='", '=')) {
                ParseSupport.parseMandatoryChar(stok, "assertion operator '=='", '=');
                operator = 0;
                operatorString.append("== ");
            } else if (ParseSupport.parseOptionalChar(stok, "assertion operator '!='", '!')) {
                ParseSupport.parseMandatoryChar(stok, "assertion operator '!='", '=');
                operator = 16;
                operatorString.append("!= ");
            } else if (ParseSupport.parseOptionalChar(stok, "assertion operator '< / <='", '<')) {
                operator = 2;
                operatorString.append('<');
                if (ParseSupport.parseOptionalChar(stok, "assertion operator '<='", '=')) {
                    ++operator;
                    operatorString.append('=');
                }
                operatorString.append(' ');
            } else if (ParseSupport.parseOptionalChar(stok, "assertion operator '> / >='", '>')) {
                operator = 4;
                operatorString.append('>');
                if (ParseSupport.parseOptionalChar(stok, "assertion operator '>='", '=')) {
                    ++operator;
                    operatorString.append('=');
                }
                operatorString.append(' ');
            }
            double numberValue = ParseSupport.parseOptionalNumber(stok, "comparisonValue");
            if (numberValue != Double.MAX_VALUE) {
                compValue = String.valueOf(numberValue);
                operatorString.append(compValue);
            } else {
                compValue = AnimalParseSupport.parseText(stok, "Variable value");
                operatorString.append("\"").append(compValue).append("\"");
            }
            String baseValue = AssertionSupport.getObjectProperties().getProperty(String.valueOf(variableName) + ".value", "0");
            switch (operator) {
                case 0: {
                    result = baseValue.equals(compValue);
                    break;
                }
                case 16: {
                    result = !baseValue.equals(compValue);
                    break;
                }
                case 4: {
                    result = baseValue.compareTo(compValue) > 0;
                    break;
                }
                case 5: {
                    result = baseValue.compareTo(compValue) >= 0;
                    break;
                }
                case 2: {
                    result = baseValue.compareTo(compValue) < 0;
                    break;
                }
                case 3: {
                    result = baseValue.compareTo(compValue) <= 0;
                    break;
                }
                default: {
                    System.err.println("Don't know what to do with operator " + operatorString.toString());
                }
            }
            if (useConnector) {
                result = connectorIsAnd ? result && lastResult : result || lastResult;
                useConnector = false;
            }
            lastResult = result;
        }
        stok.pushBack();
        this.assertionMessage(operatorString.toString(), result);
    }

    private void assertionMessage(String operatorString, boolean assertionResult) {
        MessageDisplay.message("# assertion [" + stok.lineno() + "]: " + operatorString + (assertionResult ? " *passed*" : " ***failed***"));
    }
}

