/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.main.AnimationWindow;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import animalscript.extensions.ExternalActionSupport;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import translator.AnimalTranslator;
import translator.ResourceLocator;

public class AnimalScriptParser
extends BasicParser
implements AnimalScriptInterface {
    public static String HANDLERS_FILENAME = "handlers.dat";
    public static String TYPES_FILENAME = "types.dat";
    private static final String ERROR_MESSAGE_STRING = "Animal detected some unknown commands while parsing the file.\n\nThis may be due to the following reasons:\n\n  * mistyped commands(wrong spelling),\n\n  * missing or incorrect entries in the local 'handlers.dat' file\n    All handlers must be entered in this file with their full class name,\n    e.g. animalscript.core.BaseAdminParser\n    Animal looks for the file in the local directory and will then search\n    the CLASSPATH.  Make sure that the correct 'handlers.dat'\n    was loaded; if needed, change the directory for this purpose.\n\n  * missing or invalid extension classes\n    Animal must be able to locate the classes from the CLASSPATH.\n\nIf after checking these hints you still believe Animal is wrong,\n    query the Animal WWW server which has a full listing of all\n    currently registered.  The URL is\n\n  http://www.informatik.uni-siegen.de/~roesslin/Animal/checkKW.pm\n";
    private boolean isCompressed = false;
    private String author;
    private String title;
    public static StringBuilder fileContents = null;
    private long startTime;
    private String currentFilename;
    public static String[] registeredHandlers = null;
    private Hashtable<String, String> unknownCommands;

    public AnimalScriptParser() {
        this.handledKeywords = new Hashtable();
        String[] knownElementTypes = this.readSupportedTypes();
        if (registeredTypes != null) {
            registeredTypes.clear();
        }
        int i = 0;
        while (i < knownElementTypes.length) {
            registeredTypes.put(knownElementTypes[i], knownElementTypes[i]);
            knownElementTypes[i] = null;
            ++i;
        }
        knownElementTypes = null;
        registeredHandlers = this.getRegisteredHandlers();
        if (registeredKeywords != null) {
            registeredKeywords.clear();
        } else {
            registeredKeywords = new Hashtable(503);
        }
        if (registeredRules != null) {
            registeredRules.clear();
        } else {
            registeredRules = new Hashtable(503);
        }
        i = 0;
        while (i < registeredHandlers.length) {
            if (registeredHandlers[i] != null) {
                AnimalScriptParser.addScriptingHandler(registeredHandlers[i]);
            }
            ++i;
        }
    }

    public String[] getRegisteredHandlers() {
        if (registeredHandlers == null) {
            registeredHandlers = this.readHandlersFromFile();
        }
        return registeredHandlers;
    }

    public static void removeScriptingHandler(String handlerName) {
        AnimalScriptInterface asi = (AnimalScriptInterface)currentHandlers.get(handlerName);
        if (asi == null) {
            asi = AnimalScriptParser.getHandlerForName(handlerName);
        }
        if (asi != null) {
            Enumeration<String> keywords;
            Enumeration<Object> enumerate = asi.getHandledRules();
            String command = null;
            if (enumerate != null) {
                while (enumerate.hasMoreElements()) {
                    command = ((String)enumerate.nextElement()).toLowerCase();
                    registeredRules.remove(command);
                }
            }
            if ((keywords = asi.getHandledKeywords()) != null) {
                while (keywords.hasMoreElements()) {
                    command = keywords.nextElement().toLowerCase();
                    registeredKeywords.remove(command);
                }
            }
        }
    }

    public static void addScriptingHandler(String handlerName) {
        try {
            Class<?> loadedClass = Class.forName(handlerName);
            AnimalScriptInterface o = (AnimalScriptInterface)loadedClass.newInstance();
            String currentRule = null;
            String command = null;
            Enumeration<Object> enumerate = o.getHandledRules();
            if (enumerate != null) {
                while (enumerate.hasMoreElements()) {
                    command = ((String)enumerate.nextElement()).toLowerCase();
                    currentRule = o.getRuleFor(command);
                    if (currentRule == null) {
                        System.err.println("*****Rule for '" + command + "' is null *****");
                        continue;
                    }
                    if (registeredRules.containsKey(command)) {
                        MessageDisplay.errorMsg("!!! conflict in class " + handlerName + ": '" + command + "' already assigned to " + (String)registeredRules.get(command), 4);
                        continue;
                    }
                    registeredRules.put(command, currentRule);
                }
            }
            if ((enumerate = o.getHandledKeywords()) != null) {
                while (enumerate.hasMoreElements()) {
                    command = ((String)enumerate.nextElement()).toLowerCase();
                    if (registeredKeywords.containsKey(command)) {
                        MessageDisplay.errorMsg("!!! conflict in class " + handlerName + ": '" + command + "' already assigned to " + (String)registeredKeywords.get(command), 4);
                        continue;
                    }
                    registeredKeywords.put(command, handlerName);
                }
            }
        }
        catch (ClassNotFoundException classNotFound) {
            MessageDisplay.errorMsg("Class '" + handlerName + "' not found!!!", 4);
            MessageDisplay.errorMsg(classNotFound.getMessage(), 4);
        }
        catch (IllegalAccessException illegalAccess) {
            MessageDisplay.errorMsg("Class '" + handlerName + "' has illegal access!!!", 4);
            MessageDisplay.errorMsg(illegalAccess.getMessage(), 4);
        }
        catch (InstantiationException instantiationException) {
            MessageDisplay.errorMsg("Class '" + handlerName + "' has instantiation exception access!!!", 4);
            MessageDisplay.errorMsg(instantiationException.getMessage(), 4);
        }
    }

    public String[] readSupportedTypes() {
        String s;
        Vector<String> handledTypes = new Vector<String>(20, 10);
        try {
            ResourceLocator resLoc = ResourceLocator.getResourceLocator();
            InputStreamReader in = new InputStreamReader(resLoc.getResourceStream(TYPES_FILENAME, AnimalFrame.runsInApplet, AnimalFrame.baseURL));
            BufferedReader is = new BufferedReader(in);
            while ((s = is.readLine()) != null) {
                handledTypes.addElement(s.toLowerCase());
            }
            is.close();
        }
        catch (FileNotFoundException e) {
            MessageDisplay.errorMsg("File " + e.getMessage() + " not found", 4);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("Error while closing " + e.getMessage(), 16);
        }
        s = null;
        Object[] handledElements = new String[handledTypes.size()];
        handledTypes.copyInto(handledElements);
        handledTypes.removeAllElements();
        handledTypes = null;
        return handledElements;
    }

    public String[] readHandlersFromFile() {
        Properties props = AnimalConfiguration.getDefaultConfiguration().getEntriesForPrefix("animalscript.");
        String[] handlers = new String[props.size()];
        Enumeration<Object> propElems = props.keys();
        int pos = 0;
        while (propElems.hasMoreElements()) {
            handlers[pos++] = props.getProperty((String)propElems.nextElement());
        }
        return handlers;
    }

    public Animation programImport(String filename) {
        return this.importAnimationFrom(filename, true);
    }

    public Animation programImport(String filename, boolean useFileMode) {
        if (useFileMode) {
            return this.importAnimationFrom(filename, true);
        }
        if (stok == null) {
            System.err.println("using String-based mode... creating new stream tokenizer...");
            this.generateStreamTokenizer(filename, false);
        }
        return this.importAnimationFrom(new StringReader(filename), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Animation importAnimationFrom(String filename, boolean createNewAnimation) {
        Animation tmpAnimation = null;
        try {
            int index;
            InputStream in = null;
            if (filename.startsWith("http:") || filename.startsWith("https:") || filename.startsWith("file:")) {
                URL targetURL = new URL(filename);
                if (targetURL == null) {
                    return null;
                }
                in = targetURL.openStream();
            } else {
                in = new FileInputStream(filename);
            }
            if (filename != null && in != null && (index = filename.lastIndexOf(System.getProperty("file.separator"))) != -1) {
                AnimalConfiguration.getDefaultConfiguration().setCurrentDirectory(filename.substring(0, index));
            }
            tmpAnimation = this.importAnimationFrom(in, filename, createNewAnimation);
            in.close();
            return tmpAnimation;
        }
        catch (FileNotFoundException fnfe) {
            MessageDisplay.errorMsg("File not found: " + filename, 4);
            return tmpAnimation;
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("IO-Error while reading " + e.getMessage(), 4);
            e.printStackTrace();
        }
        return tmpAnimation;
    }

    public Animation importAnimationFrom(InputStream in, String filename, boolean createNewAnimation) {
        Reader isr = null;
        try {
            if (in != null) {
                isr = this.isCompressed ? new InputStreamReader((InputStream)new GZIPInputStream(in), "utf-8") : new InputStreamReader(in, "utf-8");
            } else if (filename.startsWith("%Animal")) {
                isr = new StringReader(filename);
            }
        }
        catch (IOException e) {
            System.err.println("Conversion to utf 8 failed!");
        }
        return this.importAnimationFrom(isr, filename, createNewAnimation);
    }

    public Animation importAnimationFrom(Reader reader, String filename, boolean createNewAnimation) {
        employsQuestions = false;
        this.currentFilename = filename;
        Animation tmpAnimation = null;
        this.startTime = System.currentTimeMillis();
        BufferedReader br = null;
        try {
            br = new BufferedReader(reader);
            fileContents = new StringBuilder(65536);
            String currentLine = null;
            while ((currentLine = br.readLine()) != null) {
                fileContents.append(currentLine).append("\n");
            }
            br.close();
            this.generateStreamTokenizer(fileContents.toString(), false);
            tmpAnimation = this.importAnimationFrom(new StringReader(fileContents.toString()), createNewAnimation);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("IO-Error while reading " + e.getMessage(), 4);
            e.printStackTrace();
            return null;
        }
        employsQuestions = false;
        return tmpAnimation;
    }

    public Animation importAnimationFrom(Reader br, boolean createNewAnimation) {
        Animation tmpAnimation;
        ExternalActionSupport extActionSupport = (ExternalActionSupport)this.getHandlerForCommand("interactiondefinition");
        double localWidth = -1.0;
        double localHeight = -1.0;
        try {
            this.initializeTables();
            this.unknownCommands = new Hashtable(43);
            int token = stok.nextToken();
            if (token == 37) {
                ParseSupport.parseMandatoryWord(stok, "Protocol header '%Animal <version>", "Animal");
                ParseSupport.parseInt(stok, "Animal version");
                localWidth = ParseSupport.parseOptionalNumber(stok, "Animation width");
                if (localWidth > 0.0 && localWidth != Double.MAX_VALUE) {
                    ParseSupport.parseMandatoryChar(stok, "anim size separator '*'", '*');
                    localHeight = ParseSupport.parseOptionalNumber(stok, "Animation width");
                }
                ParseSupport.consumeIncludingEOL(stok, "Animal I/O header");
            } else {
                stok.pushBack();
            }
            token = stok.nextToken();
            if (token == -3 && AnimalScriptParser.stok.sval.equalsIgnoreCase("title")) {
                this.title = AnimalParseSupport.parseText(stok, "Animation title");
                ParseSupport.consumeIncludingEOL(stok, "EOL after animation title");
            } else {
                stok.pushBack();
            }
            token = stok.nextToken();
            if (token == -3 && AnimalScriptParser.stok.sval.equalsIgnoreCase("author")) {
                this.author = AnimalParseSupport.parseText(stok, "Animation Author");
                ParseSupport.consumeIncludingEOL(stok, "EOL after animation author");
            } else {
                stok.pushBack();
            }
            tmpAnimation = this.programImport(createNewAnimation);
            if (localWidth > 0.0 && localHeight > 0.0 && localWidth != Double.MAX_VALUE && localHeight != Double.MAX_VALUE) {
                tmpAnimation.setWidth((int)localWidth);
                tmpAnimation.setHeight((int)localHeight);
                AnimationWindow animWin = AnimalConfiguration.getDefaultConfiguration().getWindowCoordinator().getAnimationWindow(true);
                animWin.getAnimationCanvas().setSize((int)localWidth, (int)localHeight);
                animWin.pack();
            }
            tmpAnimation.setAuthor(this.author);
            tmpAnimation.setTitle(this.title);
            br.close();
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("IO-Error while reading " + e.getMessage(), 4);
            e.printStackTrace();
            return null;
        }
        tmpAnimation.resetChange();
        tmpAnimation.setInteractionBackend(extActionSupport.getInteractionBackend());
        return tmpAnimation;
    }

    /*
     * Unable to fully structure code
     */
    public Animation programImport(boolean createNewAnimation) throws IOException {
        token = 0;
        tmpStore = AnimalScriptParser.anim;
        if (createNewAnimation || tmpStore == null) {
            this.clearTables();
            AnimalScriptParser.anim = new Animation();
            AnimalScriptParser.anim.resetNextGraphicObjectNum();
            AnimalScriptParser.currentlyVisible = new Hashtable<K, V>(503);
            AnimalScriptParser.currentStep = 0;
        } else {
            AnimalScriptParser.anim = tmpStore;
            if (AnimalScriptParser.currentlyVisible == null) {
                AnimalScriptParser.currentlyVisible = new Hashtable<K, V>(503);
            }
            lastLink = AnimalScriptParser.anim.getLink(AnimalScriptParser.currentStep);
            lastLink.setNextStep(AnimalScriptParser.currentStep + 1);
        }
        while (this.canContinueParsing()) {
            token = AnimalScriptParser.stok.nextToken();
            if (token != -1) ** GOTO lbl21
            this.popTokenizer();
            continue;
lbl-1000:
            // 1 sources

            {
                token = AnimalScriptParser.stok.nextToken();
lbl21:
                // 2 sources

                ** while (token == 10)
            }
lbl22:
            // 1 sources

            if (token == -1) break;
            if (token != -3) {
                if (token == 123 || token == 125) {
                    AnimalScriptParser.groupedStepMode = token == 123;
                    v0 = AnimalScriptParser.sameStep = token == 123;
                    if (AnimalScriptParser.groupedStepMode) {
                        AnimalScriptParser.newLink();
                    }
                    ParseSupport.consumeIncludingEOL(AnimalScriptParser.stok, "step begin/end mark");
                } else {
                    MessageDisplay.errorMsg("Expected Word, read in " + token + "/" + AnimalScriptParser.stok.nval + "/" + AnimalScriptParser.stok.sval + "/" + AnimalScriptParser.stok.ttype + 10 + " in line " + AnimalScriptParser.stok.lineno(), 4);
                }
            } else {
                s = AnimalScriptParser.stok.sval;
                this.process(AnimalScriptParser.stok, s);
            }
            if (!AnimalScriptParser.debugMode) continue;
            System.err.print('.');
        }
        if (AnimalScriptParser.debugMode) {
            System.err.println(' ');
        }
        lastLink = AnimalScriptParser.anim.getLink(AnimalScriptParser.currentStep);
        lastLink.setNextStep(0x7FFFFFFF);
        displayFilename = this.currentFilename;
        if (displayFilename == null || displayFilename.startsWith("%Animal")) {
            displayFilename = "(internal String input)";
        }
        MessageDisplay.message(AnimalTranslator.translateMessage("animalScriptParseFinished", new String[]{Integer.toString(AnimalScriptParser.errorCounter), displayFilename, Long.toString(System.currentTimeMillis() - this.startTime)}));
        AnimalScriptParser.errorCounter = 0;
        AnimalScriptParser.anim.setLanguage(AnimalScriptParser.chosenLanguage);
        if (this.unknownCommands.size() != 0) {
            message = new StringBuilder(1000);
            message.append("Animal detected some unknown commands while parsing the file.\n\nThis may be due to the following reasons:\n\n  * mistyped commands(wrong spelling),\n\n  * missing or incorrect entries in the local 'handlers.dat' file\n    All handlers must be entered in this file with their full class name,\n    e.g. animalscript.core.BaseAdminParser\n    Animal looks for the file in the local directory and will then search\n    the CLASSPATH.  Make sure that the correct 'handlers.dat'\n    was loaded; if needed, change the directory for this purpose.\n\n  * missing or invalid extension classes\n    Animal must be able to locate the classes from the CLASSPATH.\n\nIf after checking these hints you still believe Animal is wrong,\n    query the Animal WWW server which has a full listing of all\n    currently registered.  The URL is\n\n  http://www.informatik.uni-siegen.de/~roesslin/Animal/checkKW.pm\n");
            message.append("\n").append("\t\tOffending commands:");
            message.append("\n");
            enumerate = this.unknownCommands.keys();
            while (enumerate.hasMoreElements()) {
                entry = enumerate.nextElement();
                message.append((Object)entry).append(" - ");
                message.append(this.unknownCommands.get(entry));
                message.append("\n");
            }
        }
        return AnimalScriptParser.anim;
    }

    @Override
    public XProperties process(StreamTokenizer aStok, String currentCommand) throws IOException {
        XProperties props;
        block7: {
            props = null;
            try {
                AnimalScriptInterface handler = this.getHandlerForCommand(currentCommand.toLowerCase());
                if (handler != null) {
                    props = handler.process(aStok, currentCommand);
                } else {
                    ++errorCounter;
                    if (this.unknownCommands.containsKey(currentCommand.toLowerCase())) {
                        this.unknownCommands.put(currentCommand.toLowerCase(), String.valueOf(this.unknownCommands.get(currentCommand.toLowerCase())) + ", " + aStok.lineno());
                    } else {
                        this.unknownCommands.put(currentCommand.toLowerCase(), "in line(s) " + aStok.lineno());
                    }
                    MessageDisplay.errorMsg("Handler is null for " + currentCommand + " in line " + aStok.lineno() + ", skipping rest of line", 4);
                    String unknownLine = ParseSupport.consumeIncludingEOL(aStok, "***error line***");
                    MessageDisplay.message(String.valueOf(currentCommand.toLowerCase()) + " [line " + aStok.lineno() + "]: " + unknownLine);
                }
            }
            catch (IOException e) {
                MessageDisplay.errorMsg("# *** Error parsing file: " + e.getMessage() + " current state: " + aStok.toString(), 4);
                if (++errorCounter < 20) break block7;
                throw new IOException("Animation contains at least 20 errors, aborting!");
            }
        }
        if (props == null) {
            props = new XProperties();
        }
        return props;
    }

    public void setCompressed(boolean compressed) {
        this.isCompressed = compressed;
    }
}

