/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.misc.MessageDisplay;
import animal.misc.NamedColor;
import java.awt.Color;
import java.util.StringTokenizer;
import javax.swing.JComboBox;

public class ColorChoice
extends JComboBox {
    private static final long serialVersionUID = -7612429913525980839L;
    private static NamedColor[] STANDARD_COLORS = new NamedColor[]{new NamedColor(Color.black, "black"), new NamedColor(Color.blue, "blue"), new NamedColor(Color.cyan, "cyan"), new NamedColor(Color.darkGray, "dark Gray"), new NamedColor(Color.gray, "gray"), new NamedColor(Color.green, "green"), new NamedColor(Color.lightGray, "light Gray"), new NamedColor(Color.magenta, "magenta"), new NamedColor(Color.orange, "orange"), new NamedColor(Color.pink, "pink"), new NamedColor(Color.red, "red"), new NamedColor(Color.white, "white"), new NamedColor(Color.yellow, "yellow"), new NamedColor(new Color(0, 0, 144), "blue4"), new NamedColor(new Color(0, 0, 176), "blue3"), new NamedColor(new Color(0, 0, 208), "blue2"), new NamedColor(new Color(135, 206, 255), "light_blue"), new NamedColor(new Color(0, 144, 0), "green4"), new NamedColor(new Color(0, 176, 0), "green3"), new NamedColor(new Color(0, 208, 0), "green2"), new NamedColor(new Color(0, 144, 144), "cyan4"), new NamedColor(new Color(0, 176, 176), "cyan3"), new NamedColor(new Color(0, 208, 208), "cyan2"), new NamedColor(new Color(144, 0, 0), "red4"), new NamedColor(new Color(176, 0, 0), "red3"), new NamedColor(new Color(208, 0, 0), "red2"), new NamedColor(new Color(144, 0, 144), "magenta4"), new NamedColor(new Color(176, 0, 176), "magenta3"), new NamedColor(new Color(208, 0, 208), "magenta2"), new NamedColor(new Color(128, 48, 0), "brown4"), new NamedColor(new Color(160, 64, 0), "brown3"), new NamedColor(new Color(192, 96, 0), "brown2"), new NamedColor(new Color(255, 128, 128), "pink4"), new NamedColor(new Color(255, 160, 160), "pink3"), new NamedColor(new Color(255, 192, 192), "pink2"), new NamedColor(new Color(255, 224, 224), "pink"), new NamedColor(new Color(255, 215, 0), "gold")};

    public ColorChoice() {
        String[] colors = ColorChoice.getAllColorNames();
        int a = 0;
        while (a < colors.length) {
            this.addItem(colors[a]);
            ++a;
        }
    }

    public static String getColorName(Color color) {
        int a = 0;
        while (a < STANDARD_COLORS.length) {
            if (ColorChoice.STANDARD_COLORS[a].color.equals(color)) {
                return ColorChoice.STANDARD_COLORS[a].name;
            }
            ++a;
        }
        return color == null ? "none" : "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    public static String[] getAllColorNames() {
        String[] result = new String[STANDARD_COLORS.length];
        int a = 0;
        while (a < STANDARD_COLORS.length) {
            result[a] = ColorChoice.STANDARD_COLORS[a].name;
            ++a;
        }
        return result;
    }

    public static Color getColor(String name) {
        int a = 0;
        while (a < STANDARD_COLORS.length) {
            if (ColorChoice.STANDARD_COLORS[a].name.equals(name)) {
                return ColorChoice.STANDARD_COLORS[a].color;
            }
            ++a;
        }
        if (name.startsWith("(")) {
            StringTokenizer stringTokenizer = new StringTokenizer(name.substring(1, name.length() - 1), ", ");
            int red = Integer.valueOf(stringTokenizer.nextToken());
            int green = Integer.valueOf(stringTokenizer.nextToken());
            int blue = Integer.valueOf(stringTokenizer.nextToken());
            return new Color(red, green, blue);
        }
        MessageDisplay.errorMsg("unknownColorNowBlack", new String[]{name, "black"}, 4);
        return Color.black;
    }

    public static boolean validColorName(String name) {
        int a = 0;
        while (a < STANDARD_COLORS.length) {
            if (ColorChoice.STANDARD_COLORS[a].name.equalsIgnoreCase(name)) {
                return true;
            }
            ++a;
        }
        return false;
    }

    public Color getColor() {
        return ColorChoice.getColor((String)this.getSelectedItem());
    }

    public void setColor(Color c) {
        this.setSelectedItem(ColorChoice.getColorName(c));
    }
}

