/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.gui.AnimalMainWindow;
import animal.gui.AnimationOverview;
import animal.gui.DrawWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.main.AnimationListEntry;
import animal.main.AnimationWindow;
import animal.main.TimeLineEntry;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import translator.AnimalTranslator;

public class TimeLineWindow
extends AnimalFrame
implements ListSelectionListener {
    private static final long serialVersionUID = -2979784584485924348L;
    private TimeLineEntry[] entries;
    private JList labelList;
    Animation anim;
    int currentIndex;

    public TimeLineWindow(Animal animalInstance, Animation a) {
        super(animalInstance, AnimalConfiguration.getDefaultConfiguration().getProperties());
        this.setTitle(AnimalTranslator.translateMessage("tlwTitle"));
        this.anim = a;
        this.labelList = AnimalTranslator.getGUIBuilder().generateJList("timeLineList", null, null, 0, this, -1);
        this.updateList(a);
        JScrollPane scrollPane = new JScrollPane(this.labelList);
        this.getContentPane().add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("timeLineList.label", null), "North");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.pack();
    }

    public void updateList(Animation a) {
        Vector<TimeLineEntry> headers = new Vector<TimeLineEntry>(30);
        if (a == null) {
            TimeLineEntry entry = new TimeLineEntry("start", 1);
            this.labelList.setListData(new TimeLineEntry[]{entry});
            return;
        }
        AnimationListEntry[] listEntries = a.getAnimatorList();
        int i = 0;
        while (i < listEntries.length) {
            if (listEntries[i].mode == 2 && listEntries[i].link.getLinkLabel() != null && listEntries[i].link.getLinkLabel().length() > 0) {
                headers.addElement(new TimeLineEntry(listEntries[i].link.getLinkLabel(), listEntries[i].link.getStep()));
            }
            ++i;
        }
        this.entries = new TimeLineEntry[headers.size()];
        headers.copyInto(this.entries);
        this.labelList.setListData(this.entries);
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.labelList && !e.getValueIsAdjusting()) {
            Animal.get();
            int targetElement = this.labelList.getSelectedIndex();
            if (targetElement > -1) {
                AnimationOverview ao;
                AnimationWindow animationWindow;
                int targetStep = this.entries[targetElement].getStep();
                DrawWindow dw = AnimalMainWindow.WINDOW_COORDINATOR.getDrawWindow(false);
                if (dw != null && dw.isVisible()) {
                    dw.setStep(targetStep);
                }
                if ((animationWindow = AnimalMainWindow.WINDOW_COORDINATOR.getAnimationWindow(false)) != null) {
                    animationWindow.setStep(targetStep, true);
                }
                if ((ao = AnimalMainWindow.WINDOW_COORDINATOR.getAnimationOverview(false)) != null && ao.isVisible()) {
                    ao.setStep(targetStep, true);
                }
            }
        }
    }
}

