/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPolyline;
import animal.handler.GraphicObjectHandlerExtension;
import animal.misc.MSMath;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolylineHandlerExtension
extends GraphicObjectHandlerExtension {
    public PolylineHandlerExtension() {
        this.type = "Polyline";
    }

    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        if (obj instanceof Point) {
            result.addElement("translateNodes22...");
        }
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        String what;
        PTPolyline polyline = null;
        if (ptgo instanceof PTPolyline) {
            polyline = (PTPolyline)ptgo;
        }
        if ((what = e.getPropertyName()).startsWith("translateNodes22 ") || what.startsWith("translateWithFixedNodes ")) {
            boolean moveMode = what.startsWith("translateNodes22");
            StringTokenizer stringTok = new StringTokenizer(what.substring(moveMode ? 17 : 26));
            int nodeCount = polyline.getNodeCount();
            boolean[] map = new boolean[nodeCount];
            if (!moveMode) {
                int i = 0;
                while (i < nodeCount) {
                    map[i] = true;
                    ++i;
                }
            }
            int currentNode = 0;
            while (stringTok.hasMoreTokens()) {
                currentNode = Integer.parseInt(stringTok.nextToken());
                if (currentNode <= 0 || currentNode > nodeCount) continue;
                map[currentNode - 1] = moveMode;
            }
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            polyline.translate(map, diff.x, diff.y);
        }
    }
}

