/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.animator.Rotation;
import animal.animator.ScaleParams;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Vector;

public class PointHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        if (obj instanceof Color) {
            result.addElement("color");
        }
        if (obj instanceof Point) {
            result.addElement("translate");
        }
        if (obj instanceof Rotation) {
            result.addElement("rotate");
        }
        if (obj instanceof ScaleParams) {
            result.addElement("scale");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        PTPoint point = null;
        if (ptgo instanceof PTPoint) {
            point = (PTPoint)ptgo;
            String what = e.getPropertyName();
            if (what.equalsIgnoreCase("color")) {
                point.setColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("translate")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                point.translate(diff.x, diff.y);
            } else if (what.equalsIgnoreCase("rotate")) {
                Rotation r = (Rotation)e.getNewValue();
                point.rotate(r.getAngle() - ((Rotation)e.getOldValue()).getAngle(), r.getCenter());
            } else if (what.equalsIgnoreCase("scale")) {
                ScaleParams s = (ScaleParams)e.getNewValue();
                point.translate(-s.getCenter().getX(), -s.getCenter().getY());
                double xFactor = s.getXScaleFactor() / ((ScaleParams)e.getOldValue()).getXScaleFactor();
                double yFactor = s.getYScaleFactor() / ((ScaleParams)e.getOldValue()).getYScaleFactor();
                point.scale(xFactor, yFactor);
                point.translate(s.getCenter().getX(), s.getCenter().getY());
            } else {
                super.propertyChange(ptgo, e);
            }
        }
    }
}

