/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.animator.Highlight;
import animal.animator.HighlightEdge;
import animal.graphics.PTGraph;
import animal.graphics.PTGraphicObject;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class GraphHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>(12, 2);
        PTGraph graph = null;
        if (!(ptgo instanceof PTGraph)) {
            return result;
        }
        graph = (PTGraph)ptgo;
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
            int i = 0;
            while (i < graph.getLength()) {
                result.addElement("showNode " + i);
                result.addElement("hideNode " + i);
                ++i;
            }
        } else if (obj instanceof String) {
            result.addElement("setEdgeWeight");
        } else if (obj instanceof Color) {
            result.addElement("bgColor");
            result.addElement("outlineColor");
            result.addElement("nodeFontColor");
            result.addElement("edgeFontColor");
        } else if (obj instanceof Point) {
            result.addElement("translate");
            int a = 0;
            while (a < graph.getSize()) {
                result.addElement("translate #" + (a + 1));
                ++a;
            }
            result.addElement("translateNodes...");
            result.addElement("translateWithFixedNodes...");
        } else if (obj instanceof double[]) {
            result.addElement("highlight node elements");
            result.addElement("highlight nodes");
            result.addElement("unhighlight node elements");
            result.addElement("unhighlight nodes");
            result.addElement("deactivate nodes");
            result.addElement("activate nodes");
            result.addElement("set nodes visible");
            result.addElement("set nodes invisible");
        } else if (obj instanceof double[][]) {
            result.addElement("highlight edge elements");
            result.addElement("highlight edges");
            result.addElement("unhighlight edge elements");
            result.addElement("unhighlight edges");
            result.addElement("deactivate edges");
            result.addElement("activate edges");
            result.addElement("set edges visible");
            result.addElement("set edges invisible");
            result.addElement("hide edge weight");
            result.addElement("show edge weight");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        PTGraph graph = null;
        if (ptgo instanceof PTGraph) {
            graph = (PTGraph)ptgo;
            String what = e.getPropertyName();
            if (what.equalsIgnoreCase("bgColor")) {
                graph.setBGColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("nodeFontColor")) {
                graph.setNodeFontColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("edgeFontColor")) {
                graph.setEdgeFontColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("outlineColor")) {
                graph.setOutlineColor((Color)e.getNewValue());
            } else if (what.startsWith("setEdgeWeight")) {
                StringTokenizer stok = new StringTokenizer(what, "(),");
                stok.nextToken();
                int startNode = Integer.valueOf(stok.nextToken());
                int endNode = Integer.valueOf(stok.nextToken());
                graph.enterValueEdge(startNode, endNode, (String)e.getNewValue());
            } else if (what.equalsIgnoreCase("translate")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                graph.translate(diff.x, diff.y);
            } else if (what.length() > 11 && what.substring(0, 11).equalsIgnoreCase("translate #")) {
                int num = Integer.parseInt(what.substring(11));
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                graph.translateNode(num - 1, diff.x, diff.y);
            } else if (what.startsWith("translateNodes ") || what.startsWith("translateWithFixedNodes ")) {
                boolean moveMode = what.startsWith("translateNodes");
                StringTokenizer stringTok = new StringTokenizer(what.substring(moveMode ? 15 : 24));
                int nodeCount = graph.getSize();
                boolean[] map = new boolean[nodeCount];
                if (!moveMode) {
                    int i = 0;
                    while (i < nodeCount) {
                        map[i] = true;
                        ++i;
                    }
                }
                int currentNode = 0;
                while (stringTok.hasMoreTokens()) {
                    currentNode = Integer.parseInt(stringTok.nextToken());
                    if (currentNode <= 0 || currentNode > nodeCount) continue;
                    map[currentNode - 1] = moveMode;
                }
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                graph.translateNodes(map, diff.x, diff.y);
            } else if (what.contains("highlight") && what.contains("node")) {
                double[] states = (double[])e.getNewValue();
                int i = 0;
                while (i < graph.length) {
                    if (what.startsWith("un")) {
                        if (what.endsWith("elements")) {
                            if (states[i] >= 0.0 && graph.isElemHighlightedNode(i)) {
                                graph.getPTTextNode(i).setColor(Highlight.fadeColor(graph.getElemHighlightColor(), graph.getNodeFontColor(), states[i]));
                                if (states[i] >= 0.99) {
                                    graph.setElemHighlightedNode(i, false);
                                }
                            }
                        } else if (what.endsWith("nodes") && states[i] >= 0.0 && graph.isHighlightedNode(i)) {
                            graph.getNode(i).setFillColor(Highlight.fadeColor(graph.getHighlightColor(), graph.getBGColor(), states[i]));
                            if (states[i] >= 0.99) {
                                graph.setHighlightedNode(i, false);
                            }
                        }
                    } else if (what.endsWith("elements")) {
                        if (states[i] >= 0.0 && !graph.isElemHighlightedNode(i)) {
                            graph.getPTTextNode(i).setColor(Highlight.fadeColor(graph.getNodeFontColor(), graph.getElemHighlightColor(), states[i]));
                            if (states[i] >= 0.99) {
                                graph.setElemHighlightedNode(i, true);
                            }
                        }
                    } else if (what.endsWith("nodes") && states[i] >= 0.0 && !graph.isHighlightedNode(i)) {
                        graph.getNode(i).setFillColor(Highlight.fadeColor(graph.getBGColor(), graph.getHighlightColor(), states[i]));
                        if (states[i] >= 0.99) {
                            graph.setHighlightedNode(i, true);
                        }
                    }
                    ++i;
                }
            } else if (what.contains("activate") && what.contains("node")) {
                double[] states = (double[])e.getNewValue();
                int i = 0;
                while (i < graph.length) {
                    if (states[i] >= 0.5) {
                        graph.setActivatedNode(i, !what.startsWith("de"));
                        int j = 0;
                        while (j < graph.length) {
                            graph.setActivatedEdge(i, j, !what.startsWith("de") && graph.isActivatedNode(j));
                            graph.setActivatedEdge(j, i, !what.startsWith("de") && graph.isActivatedNode(j));
                            ++j;
                        }
                    }
                    ++i;
                }
            } else if (what.contains("visible") && what.contains("node")) {
                double[] states = (double[])e.getNewValue();
                int i = 0;
                while (i < graph.length) {
                    if (states[i] >= 0.5) {
                        graph.setVisibleNode(i, !what.contains("in"));
                        int j = 0;
                        while (j < graph.length) {
                            graph.setVisibleEdge(i, j, !what.contains("in") && graph.isVisibleNode(j));
                            graph.setVisibleEdge(j, i, !what.contains("in") && graph.isVisibleNode(j));
                            ++j;
                        }
                    }
                    ++i;
                }
            } else if (what.contains("highlight") && what.contains("edge")) {
                double[][] states = (double[][])e.getNewValue();
                int i = 0;
                while (i < graph.length) {
                    int j = 0;
                    while (j < graph.length) {
                        if (what.startsWith("un")) {
                            if (what.endsWith("elements")) {
                                if (states[i][j] >= 0.0 && graph.isElemHighlightedEdge(i, j)) {
                                    graph.getPTTextEdge(i, j).setColor(HighlightEdge.fadeColor(graph.getElemHighlightColor(), graph.getEdgeFontColor(), states[i][j]));
                                    if (states[i][j] >= 0.99) {
                                        graph.setElemHighlightedEdge(i, j, false);
                                    }
                                }
                            } else if (what.endsWith("edges") && states[i][j] >= 0.0 && graph.isHighlightedEdge(i, j)) {
                                if (i != j) {
                                    graph.getEdge(i, j).setColor(HighlightEdge.fadeColor(graph.getHighlightColor(), graph.getOutlineColor(), states[i][j]));
                                } else {
                                    graph.getEdgeLoop(i).setColor(HighlightEdge.fadeColor(graph.getHighlightColor(), graph.getOutlineColor(), states[i][j]));
                                }
                                if (states[i][j] >= 0.99) {
                                    graph.setHighlightedEdge(i, j, false);
                                }
                            }
                        } else if (what.endsWith("elements")) {
                            if (states[i][j] >= 0.0 && !graph.isElemHighlightedEdge(i, j)) {
                                graph.getPTTextEdge(i, j).setColor(HighlightEdge.fadeColor(graph.getEdgeFontColor(), graph.getElemHighlightColor(), states[i][j]));
                                if (states[i][j] >= 0.99) {
                                    graph.setElemHighlightedEdge(i, j, true);
                                }
                            }
                        } else if (what.endsWith("edges") && states[i][j] >= 0.0 && !graph.isHighlightedEdge(i, j)) {
                            if (i != j) {
                                graph.getEdge(i, j).setColor(HighlightEdge.fadeColor(graph.getOutlineColor(), graph.getHighlightColor(), states[i][j]));
                            } else {
                                graph.getEdgeLoop(i).setColor(HighlightEdge.fadeColor(graph.getOutlineColor(), graph.getHighlightColor(), states[i][j]));
                            }
                            if (states[i][j] >= 0.99) {
                                graph.setHighlightedEdge(i, j, true);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (what.contains("activate") && what.contains("edge")) {
                double[][] states = (double[][])e.getNewValue();
                int i = 0;
                while (i < graph.length) {
                    int j = 0;
                    while (j < graph.length) {
                        if (states[i][j] >= 0.5) {
                            graph.setActivatedEdge(i, j, !what.startsWith("de") && graph.isActivatedNode(i) && graph.isActivatedNode(j));
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (what.contains("visible") && what.contains("edge")) {
                double[][] states = (double[][])e.getNewValue();
                int i = 0;
                while (i < graph.length) {
                    int j = 0;
                    while (j < graph.length) {
                        if (states[i][j] >= 0.5) {
                            graph.setVisibleEdge(i, j, !what.contains("in") && graph.isVisibleNode(i) && graph.isVisibleNode(j));
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (what.equalsIgnoreCase("show edge weight") || what.equalsIgnoreCase("hide edge weight")) {
                boolean isShow = what.startsWith("show");
                double[][] states = (double[][])e.getNewValue();
                int i = 0;
                while (i < graph.length) {
                    int j = 0;
                    while (j < graph.length) {
                        if (states[i][j] >= 0.5) {
                            graph.setEdgeWeightVisibility(i, j, isShow && graph.isVisibleNode(i) && graph.isVisibleNode(j) && graph.isVisibleEdge(i, j));
                        }
                        ++j;
                    }
                    ++i;
                }
            } else if (what.startsWith("hideNode") || what.startsWith("showNode")) {
                boolean isHideMode = what.startsWith("hide");
                StringTokenizer stok = new StringTokenizer(what);
                String elem = stok.nextToken();
                while (stok.hasMoreTokens()) {
                    elem = stok.nextToken();
                    int value = new Integer(elem);
                    if (isHideMode) {
                        graph.hideNode(value);
                        continue;
                    }
                    graph.showNode(value);
                }
            } else if (what.startsWith("hideEdge") || what.startsWith("showEdge")) {
                boolean isHideMode = what.startsWith("hide");
                StringTokenizer stok = new StringTokenizer(what, "(), ", false);
                String elem = stok.nextToken();
                while (stok.hasMoreTokens()) {
                    elem = stok.nextToken();
                    int startNode = new Integer(elem);
                    elem = stok.nextToken();
                    int targetNode = new Integer(elem);
                    if (isHideMode) {
                        graph.hideEdge(startNode, targetNode);
                        continue;
                    }
                    graph.showEdge(startNode, targetNode);
                }
            } else {
                super.propertyChange(ptgo, e);
            }
        }
    }
}

