/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Vector;

public class BoxPointerHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        PTBoxPointer boxPointer = null;
        if (!(ptgo instanceof PTBoxPointer)) {
            return new Vector<String>();
        }
        boxPointer = (PTBoxPointer)ptgo;
        if (obj instanceof Point) {
            result.addElement("translate");
            int nrPointers = 0;
            if (boxPointer.getPointers() != null) {
                nrPointers = boxPointer.getPointers().size();
            }
            if (nrPointers > 0) {
                result.addElement("setTip");
                result.addElement("translateWithFixedTip");
            }
        }
        if (obj instanceof Color) {
            result.addElement("text box frame & pointer color");
            result.addElement("fillColor");
            result.addElement("pointer box frame color");
            result.addElement("pointer background color");
            result.addElement("color");
            result.addElement("textcolor");
        }
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        PTBoxPointer boxPointer = null;
        if (ptgo instanceof PTBoxPointer) {
            boxPointer = (PTBoxPointer)ptgo;
            String what = e.getPropertyName();
            if (what.equalsIgnoreCase("setTip")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                if (boxPointer.getPointers() != null) {
                    boxPointer.setTip(0, MSMath.sum(boxPointer.getTip(0), diff));
                }
            } else if (what.equalsIgnoreCase("translate")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                boxPointer.translate(diff.x, diff.y);
            } else if (what.equalsIgnoreCase("translateWithFixedTip")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                boxPointer.translateWithFixedTips(diff.x, diff.y);
            } else if (what.equalsIgnoreCase("text box frame & pointer color")) {
                boxPointer.setColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("fillColor")) {
                boxPointer.getTextBox().setFillColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("pointer box frame color")) {
                boxPointer.getPointerArea().setColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("pointer background color") || what.equalsIgnoreCase("color")) {
                boxPointer.getPointerArea().setFillColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("textcolor")) {
                boxPointer.getTextComponent().setColor((Color)e.getNewValue());
            } else {
                super.propertyChange(ptgo, e);
            }
        }
    }
}

