/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.VariableTableModel;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.main.Animation;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;

public class VariableView
extends AnimalFrame
implements TableModelListener {
    private static final long serialVersionUID = 6000473356719369903L;
    private Animation anim;
    private JScrollPane scrollPane;
    private JTable table;
    private VariableTableModel tableModel = null;

    public VariableView(Animal animalInstance, Animation anim) {
        super(animalInstance, AnimalConfiguration.getDefaultConfiguration().getProperties());
        this.anim = anim;
        this.init();
    }

    @Override
    public void init() {
        super.init();
        if (this.anim == null) {
            this.anim = Animal.get().getAnimation();
        }
        this.tableModel = new VariableTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setFillsViewportHeight(true);
        this.table.getModel().addTableModelListener(this);
        this.scrollPane = new JScrollPane(this.table);
        JPanel buttonPanel = new JPanel();
        ExtendedActionButton cancelButton = AnimalTranslator.getGUIBuilder().generateActionButton("cancel", AnimalTranslator.getGUIBuilder().generateAction("cancel", null, this, null, true));
        buttonPanel.add(cancelButton);
        this.workContainer().removeAll();
        this.workContainer().setLayout(new BorderLayout(0, 0));
        this.workContainer().add("Center", this.scrollPane);
        this.workContainer().add("South", buttonPanel);
        this.setTitle("Variable List");
        this.setSize(400, 400);
        this.setLocation(0, 275);
        this.setVisible(true);
    }

    public void setStep(int step) {
        this.tableModel.setStep(step);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.scrollPane.repaint();
    }

    public void cancelOperation() {
        this.setVisible(false);
    }
}

