/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.main.AnimationState;
import animal.variables.Variable;
import javax.swing.table.AbstractTableModel;

public class VariableTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4525246143284609287L;
    private static final String[] columnNames = new String[]{"Name", "Value"};
    private String[][] data = null;
    private AnimationState animState;

    public void setStep(int stepNr) {
        this.updateDataForStep();
        this.fireTableDataChanged();
    }

    public void updateDataForStep() {
        this.animState = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).getAnimationState();
        int pos = 0;
        int nrVars = this.animState.getVariables().size();
        if (nrVars > 0) {
            this.data = new String[nrVars][columnNames.length];
            for (String variableName : this.animState.getVariables().keySet()) {
                Variable var = this.animState.getVariables().get(variableName);
                this.data[pos][0] = var.getName();
                this.data[pos][1] = var.getValue();
                ++pos;
            }
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public String getValueAt(int row, int col) {
        if (this.data == null || this.data.length < row || this.data[row].length < col) {
            return null;
        }
        return this.data[row][col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

