/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.editor.graphics.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.gui.DrawCanvas;
import animal.gui.InternPanel;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import java.awt.Point;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class AnimalUndoAdapter
implements UndoableEditListener {
    private UndoManager undoManager;
    private UndoableEditSupport undoSupport;
    DrawCanvas dc;
    private InternPanel ip;

    AnimalUndoAdapter(DrawCanvas aDrawCanvas, InternPanel anInternalPanel) {
        this.dc = aDrawCanvas;
        this.ip = anInternalPanel;
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this);
        this.refreshUndoRedo();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent evt) {
        UndoableEdit edit = evt.getEdit();
        this.undoManager.addEdit(edit);
        this.refreshUndoRedo();
    }

    public void refreshUndoRedo() {
        this.ip.undoButton.setToolTipText(this.undoManager.getUndoPresentationName());
        this.ip.undoButton.setEnabled(this.undoManager.canUndo());
        this.ip.redoButton.setToolTipText(this.undoManager.getRedoPresentationName());
        this.ip.redoButton.setEnabled(this.undoManager.canRedo());
    }

    void undo() {
        this.undoManager.undo();
        this.refreshUndoRedo();
    }

    void redo() {
        this.undoManager.redo();
        this.refreshUndoRedo();
    }

    void reset() {
        this.undoManager.discardAllEdits();
        this.refreshUndoRedo();
    }

    void move(int[] nums, int editPointNum, Point from, Point to) {
        if (from.equals(to)) {
            return;
        }
        MoveEdit edit = new MoveEdit(nums, editPointNum, from, to);
        this.undoSupport.postEdit(edit);
    }

    void insert(PTGraphicObject object) {
        InsertEdit edit = new InsertEdit(object);
        this.undoSupport.postEdit(edit);
    }

    void insert(PTGraphicObject[] objects) {
        InsertEdit edit = new InsertEdit(objects);
        this.undoSupport.postEdit(edit);
    }

    void delete(PTGraphicObject[] objects) {
        if (objects != null) {
            DeleteEdit edit = new DeleteEdit(objects);
            this.undoSupport.postEdit(edit);
        }
    }

    class DeleteEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -4671083947785992899L;
        PTGraphicObject[] deletedObjects;

        DeleteEdit(PTGraphicObject[] objects) {
            this.deletedObjects = objects;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            int a = 0;
            while (a < this.deletedObjects.length) {
                AnimalUndoAdapter.this.dc.getObjects().addElement(this.deletedObjects[a], 1);
                ++a;
            }
            AnimalUndoAdapter.this.dc.repaintAll();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            int a = 0;
            while (a < this.deletedObjects.length) {
                AnimalUndoAdapter.this.dc.getObjects().removeElement(this.deletedObjects[a]);
                ++a;
            }
            AnimalUndoAdapter.this.dc.repaintAll();
        }

        @Override
        public String getPresentationName() {
            return "Delete";
        }
    }

    class InsertEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -8344678427364013220L;
        PTGraphicObject[] objects;
        boolean cloned;

        InsertEdit(PTGraphicObject object) {
            this.objects = new PTGraphicObject[]{object};
            this.cloned = false;
        }

        InsertEdit(PTGraphicObject[] graphicalObjects) {
            this.objects = graphicalObjects;
            this.cloned = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.objects != null) {
                int a = 0;
                while (a < this.objects.length) {
                    AnimalUndoAdapter.this.dc.getObjects().removeElement(this.objects[a]);
                    ++a;
                }
            }
            if (AnimalUndoAdapter.this.dc.getGraphicEditor() != null) {
                AnimalUndoAdapter.this.dc.getGraphicEditor().createObject();
            }
            AnimalUndoAdapter.this.dc.repaintAll();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (this.objects != null) {
                int a = 0;
                while (a < this.objects.length) {
                    AnimalUndoAdapter.this.dc.getObjects().addElement(this.objects[a], 1);
                    ++a;
                }
            }
            AnimalUndoAdapter.this.dc.repaintAll();
        }

        @Override
        public String getPresentationName() {
            if (this.cloned) {
                return "Clone";
            }
            return "Insert";
        }
    }

    class MoveEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -6684116853542352810L;
        private int[] objectNums;
        private int editPointNum;
        private Point from;
        private Point to;

        MoveEdit(int[] theObjectNums, int theEditPointNum, Point fromPoint, Point toPoint) {
            this.objectNums = theObjectNums;
            this.editPointNum = theEditPointNum;
            this.from = fromPoint;
            this.to = toPoint;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            int a = 0;
            while (a < this.objectNums.length) {
                PTGraphicObject go = AnimalUndoAdapter.this.dc.getObjects().getGVEByNum((int)this.objectNums[a]).go;
                if (this.editPointNum <= 0) {
                    Point diff = new Point(MSMath.diff(this.from, this.to));
                    go.translate(diff.x, diff.y);
                } else {
                    EditableObject oldObject = go.getEditor().getCurrentObject(false);
                    go.getEditor().linkToEditor(go);
                    ((GraphicEditor)go.getEditor()).nextPoint(this.editPointNum, this.from);
                    go.getEditor().linkToEditor(oldObject);
                }
                ++a;
            }
            AnimalUndoAdapter.this.dc.repaintAll();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            int a = 0;
            while (a < this.objectNums.length) {
                PTGraphicObject go = AnimalUndoAdapter.this.dc.getObjects().getGVEByNum((int)this.objectNums[a]).go;
                if (this.editPointNum <= 0) {
                    Point diff = new Point(MSMath.diff(this.from, this.to));
                    go.translate(-diff.x, -diff.y);
                } else {
                    EditableObject oldObject = go.getEditor().getCurrentObject(false);
                    go.getEditor().linkToEditor(go);
                    ((GraphicEditor)go.getEditor()).nextPoint(this.editPointNum, this.to);
                    go.getEditor().linkToEditor(oldObject);
                }
                ++a;
            }
            AnimalUndoAdapter.this.dc.repaintAll();
        }

        @Override
        public String getPresentationName() {
            return "Move";
        }
    }
}

