/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.animator.MoveBase;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.meta.OpenLineBasedShape;
import animal.misc.MSMath;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class LineBasedShape
extends PTGraphicObject
implements MoveBase {
    protected Vector<PTPoint> nodes;

    protected void fillNodesVector(int size) {
        this.nodes = new Vector(size);
        int i = 0;
        while (i < size) {
            this.nodes.addElement(new PTPoint(0, 0));
            ++i;
        }
    }

    protected void fillNodesVector(int size, Vector<PTPoint> defaults) {
        this.nodes = new Vector(size);
        int i = 0;
        while (i < defaults.size()) {
            this.nodes.addElement((PTPoint)defaults.elementAt(i).clone());
            ++i;
        }
        i = defaults.size();
        while (i < size) {
            this.nodes.addElement(new PTPoint(0, 0));
            ++i;
        }
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.getNodeCount() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = new Rectangle(this.getNodeAt(0).toPoint());
        int i = 1;
        while (i < this.getNodeCount()) {
            Point p = this.getNodeAt(i).toPoint();
            r = SwingUtilities.computeUnion(p.x, p.y, 0, 0, r);
            ++i;
        }
        return r;
    }

    @Override
    public int getLength() {
        int result = 0;
        int i = 0;
        while (i < this.getNodeCount() - 1) {
            result += MSMath.dist(this.getNodeAt(i), this.getNodeAt(i + 1));
            ++i;
        }
        return result;
    }

    public int getNodeCount() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public Point getNodeAsPoint(int index) {
        PTPoint point = this.getNodeAt(index);
        if (point != null) {
            return point.toPoint();
        }
        return null;
    }

    protected PTPoint getNodeAt(int index) {
        if (this.nodes == null || index < 0 || index > this.nodes.size()) {
            return new PTPoint(0, 0);
        }
        return this.nodes.get(index);
    }

    @Override
    public Point getPointAtLength(int length) {
        int currentLength = length;
        if (this.nodes == null || this.nodes.size() < 2) {
            return new Point(0, 0);
        }
        int i = 0;
        while (i < this.getNodeCount() - 1) {
            Point b;
            Point a = this.getNodeAt(i).toPoint();
            int lineLength = MSMath.dist(a, b = this.getNodeAt(i + 1).toPoint());
            if (lineLength >= currentLength) {
                float percent = 1.0f * (float)currentLength / (float)lineLength;
                return new Point((int)((float)a.x + (float)(b.x - a.x) * percent), (int)((float)a.y + (float)(b.y - a.y) * percent));
            }
            currentLength -= lineLength;
            ++i;
        }
        return this.getNodeAt(0).toPoint();
    }

    public String nodeToString(Point node) {
        StringBuilder sb = new StringBuilder(32);
        if (node != null) {
            sb.append("(").append(node.x).append(",").append(node.y).append(") ");
        }
        return sb.toString();
    }

    protected void setNode(int index, int x, int y) {
        this.nodes.ensureCapacity(index);
        if (index >= this.nodes.size()) {
            this.nodes.add(new PTPoint(x, y));
        }
        this.nodes.set(index, new PTPoint(x, y));
    }

    public void setNode(int index, Point p) {
        if (p != null) {
            this.setNode(index, p.x, p.y);
        }
    }

    public void setNode(int index, PTPoint p) {
        if (p != null) {
            this.setNode(index, p.getX(), p.getY());
        }
    }

    public Polygon toPolygon() {
        int numNodes = this.nodes.size();
        int[] xpoints = new int[numNodes + 1];
        int[] ypoints = new int[numNodes + 1];
        Point oldP = null;
        int counter = 0;
        int i = 0;
        while (i < numNodes) {
            Point p = this.getNodeAt(i).toPoint();
            if (!p.equals(oldP)) {
                xpoints[counter] = p.x;
                ypoints[counter] = p.y;
                ++counter;
            }
            oldP = p;
            ++i;
        }
        return new Polygon(xpoints, ypoints, counter);
    }

    public void rotate(double angle) {
        int maxIndex = this.getNodeCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            this.nodes.elementAt(nodeNr).rotate(angle);
            ++nodeNr;
        }
    }

    public void rotate(double angle, PTPoint center) {
        int maxIndex = this.getNodeCount();
        int nodeNr = 0;
        while (nodeNr < maxIndex) {
            if (this.nodes.elementAt(nodeNr) != null) {
                this.nodes.elementAt(nodeNr).rotate(angle, center);
            }
            ++nodeNr;
        }
    }

    public void scale(double scaleX, double scaleY) {
        if (this.nodes == null) {
            return;
        }
        for (PTPoint node : this.nodes) {
            if (node == null) continue;
            node.scale(scaleX, scaleY);
        }
    }

    @Override
    public void translate(int deltaX, int deltaY) {
        for (PTPoint aNode : this.nodes) {
            if (aNode == null) continue;
            aNode.translate(deltaX, deltaY);
        }
    }

    protected void updateShape() {
    }

    protected void cloneCommonFeaturesInto(OpenLineBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        int nrNodes = this.getNodeCount();
        targetShape.fillNodesVector(nrNodes, this.nodes);
    }

    @Override
    public void discard() {
        super.discard();
        this.nodes.clear();
        this.nodes = null;
        this.color = null;
    }
}

