/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.meta.ArcBasedShape;
import animal.graphics.meta.FillablePrimitive;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public abstract class ClosedArcBasedShape
extends ArcBasedShape
implements FillablePrimitive {
    protected Color fillColor;
    protected boolean isFilled;

    @Override
    public void discard() {
        super.discard();
        this.fillColor = null;
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        this.center = new Point(0, 0);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isFilled = config.getDefaultBooleanValue(primitiveName, "filled", false);
        this.fillColor = config.getDefaultColor(primitiveName, "fillColor", Color.BLACK);
    }

    protected void cloneCommonFeaturesInto(ClosedArcBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFilled(this.isFilled());
        targetShape.setFillColor(this.createColor(this.getFillColor()));
    }

    @Override
    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = Color.BLACK;
        }
        return this.fillColor;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    protected void paint(Graphics g, int rx, int ry, int sa, int ta) {
        if (this.center == null) {
            return;
        }
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillArc(this.center.x - rx, this.center.y - ry, rx * 2, ry * 2, sa, ta);
        }
        g.setColor(this.color);
        g.drawArc(this.center.x - rx, this.center.y - ry, rx * 2, ry * 2, sa, ta);
    }

    @Override
    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    @Override
    public void setFillColor(Color targetFillColor) {
        this.fillColor = targetFillColor;
    }

    protected String toString(String typeName, boolean isCircular, int rx, int ry) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(typeName).append(" ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center=(");
        sb.append(this.center.x).append(", ").append(this.center.y).append("), radius");
        if (isCircular) {
            sb.append("=").append(rx);
        } else {
            sb.append(" (").append(rx).append(", ").append(ry).append(")");
        }
        return sb.toString();
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".filled", this.isFilled());
        defaultProperties.put(String.valueOf(this.getType()) + ".fillColor", this.getFillColor());
    }

    @Override
    public void useAsMoveBase() {
        this.setFilled(false);
    }
}

