/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTRectangle;
import animal.graphics.PTText;
import animal.graphics.meta.FillablePrimitive;
import animal.graphics.meta.IndexableContentContainer;
import animal.main.Animal;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public abstract class PTMatrix
extends PTGraphicObject
implements FillablePrimitive,
IndexableContentContainer {
    public static final String KIND_OF_OBJECT_CELL = "Matrix.cellIdentifier";
    public static final String KIND_OF_OBJECT_ROW = "Matrix.rowIdentifier";
    public static final String PRIMARY_DIMENSION_IDENTIFIER = "Matrix.rowIndex";
    public static final String SECONDARY_DIMENSION_IDENTIFIER = "Matrix.columnIndex";
    private Point location = new Point(0, 0);
    protected Vector<Vector<PTText>> vTextData = new Vector();
    private Vector<Vector<PTRectangle>> vCellRectangles = new Vector();
    protected int[] columntextwidths = new int[0];
    private int[] margin = new int[]{5, 5, 5, 5};
    private Alignment textAlignment = Alignment.LEFT;
    private Alignment rowAlignment = Alignment.LEFT;
    private Color fillColor = Color.WHITE;
    private Color cellHighlightColor = Color.YELLOW;
    private Color elemHighlightColor = Color.RED;
    private boolean filled = false;
    private Font font = new Font("SansSerif", 0, 20);
    private Color textColor = Color.BLACK;
    private boolean layoutChanged = false;
    private boolean visualPropertiesChanged = false;
    protected final byte OUTLINED = 1;
    protected final byte HIGHLIGHTED = (byte)2;
    protected final byte ELEMENT_HIGHLIGHTED = (byte)4;
    protected final byte VISIBLE = (byte)8;
    protected Vector<Vector<Byte>> vCellStatus = new Vector();

    protected void init() {
        this.setDepth(2);
        this.layoutChanged = true;
        int i = 0;
        while (i < this.columntextwidths.length) {
            this.columntextwidths[i] = 0;
            ++i;
        }
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    public byte getCellStatus(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return this.vCellStatus.get(r).get(c);
        }
        return 127;
    }

    public boolean isCellOutlined(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return (this.vCellStatus.get(r).get(c) & 1) == 1;
        }
        return true;
    }

    public boolean isCellHighlighted(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return (this.vCellStatus.get(r).get(c) & 2) == 2;
        }
        return true;
    }

    public boolean isCellElementHighlighted(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return (this.vCellStatus.get(r).get(c) & 4) == 4;
        }
        return true;
    }

    public boolean isCellVisible(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return (this.vCellStatus.get(r).get(c) & 8) == 8;
        }
        return true;
    }

    @Override
    public String getType() {
        return "IndexableContentContainer";
    }

    public abstract int getRowCount();

    public abstract int getColumnCount(int var1);

    public int getMaxColumnCount() {
        int cnt = 0;
        int rowCount = this.getRowCount();
        int r = 0;
        while (r < rowCount) {
            if (this.getColumnCount(r) > cnt) {
                cnt = this.getColumnCount(r);
            }
            ++r;
        }
        return cnt;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{"Matrix"};
    }

    @Override
    public Rectangle getBoundingBox() {
        int width = 0;
        int height = 0;
        int c = 0;
        while (c < this.columntextwidths.length) {
            width += this.columntextwidths[c];
            ++c;
        }
        width += this.getMaxColumnCount() * (this.margin[1] + this.margin[3] + 1);
        int r = 0;
        while (r < this.getRowCount()) {
            height += this.getTextHeight(r, 0);
            ++r;
        }
        return new Rectangle(this.location.x, this.location.y, width, height += this.getRowCount() * (this.margin[0] + this.margin[2] + 1));
    }

    private int getTextHeight(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return this.vTextData.get((int)r).get((int)c).getBoundingBox().height;
        }
        return 0;
    }

    public abstract String getElementAt(int var1, int var2);

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getHighlightColor() {
        return this.cellHighlightColor;
    }

    public Color getElemHighlightColor() {
        return this.elemHighlightColor;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public boolean isFilled() {
        return this.filled;
    }

    public int getMargin(int value) {
        return this.margin[value % 4];
    }

    public Alignment getTextAlignment() {
        return this.textAlignment;
    }

    public Alignment getRowAlignment() {
        return this.rowAlignment;
    }

    public Color getTextColor(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return this.vTextData.get(r).get(c).getColor();
        }
        return this.getTextColor();
    }

    public Color getFillColor(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return this.vCellRectangles.get(r).get(c).getFillColor();
        }
        return this.getFillColor();
    }

    public Color getColor(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return this.vCellRectangles.get(r).get(c).getColor();
        }
        return this.getColor();
    }

    public void setOutlined(int r, int c, boolean value) {
        if (this.indicesAreInRange(r, c)) {
            if (value) {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) | 1)));
            } else {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) & 0xFFFFFFFE)));
            }
            this.layoutChanged = true;
        }
    }

    public void setHighlighted(int r, int c, boolean value) {
        if (this.indicesAreInRange(r, c)) {
            if (value) {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) | 2)));
            } else {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) & 0xFFFFFFFD)));
            }
            this.layoutChanged = true;
        }
    }

    public void setElementHighlighted(int r, int c, boolean value) {
        if (this.indicesAreInRange(r, c)) {
            if (value) {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) | 4)));
            } else {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) & 0xFFFFFFFB)));
            }
            this.layoutChanged = true;
        }
    }

    public void setVisible(int r, int c, boolean value) {
        if (this.indicesAreInRange(r, c)) {
            if (value) {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) | 8)));
            } else {
                this.vCellStatus.get(r).set(c, new Byte((byte)(this.vCellStatus.get(r).get(c) & 0xFFFFFFF7)));
            }
            this.layoutChanged = true;
        }
    }

    public void setSize(int r, int c) {
        this.setRowCount(r);
        int rowIndex = 0;
        while (rowIndex < r) {
            this.setColumnCount(rowIndex, c);
            ++rowIndex;
        }
    }

    public void setColumnCount(int rowIndex, int value) {
        if (value > 0 && rowIndex >= 0 && rowIndex < this.getRowCount()) {
            int columncount;
            int oldMaxColumnCount = this.getMaxColumnCount();
            if (value > oldMaxColumnCount) {
                this.enlargeColumnTextWidthsTo(value);
            }
            if (value > (columncount = this.getColumnCount(rowIndex))) {
                int i;
                this.addColumns(rowIndex, value - columncount);
                if (this.getRowAlignment() == Alignment.RIGHT) {
                    i = this.getMaxColumnCount() - this.getColumnCount(rowIndex);
                    while (i < this.getMaxColumnCount()) {
                        this.updateColumnWidth(i);
                        ++i;
                    }
                } else if (this.getRowAlignment() == Alignment.CENTER) {
                    i = 0;
                    while (i < this.getMaxColumnCount()) {
                        this.updateColumnWidth(i);
                        ++i;
                    }
                }
            }
            if (value < columncount) {
                int columnsToDelete = columncount - value;
                this.shrinkDataRow(rowIndex, value);
                this.vTextData.get(rowIndex).setSize(value);
                this.vCellRectangles.get(rowIndex).setSize(value);
                this.vCellStatus.get(rowIndex).setSize(value);
                if (oldMaxColumnCount > this.getMaxColumnCount()) {
                    this.shrinkColumnTextWidthsTo(this.getMaxColumnCount());
                }
                if (this.getRowAlignment() == Alignment.LEFT) {
                    int i = columncount;
                    while (i < columncount + columnsToDelete) {
                        this.updateColumnWidth(i);
                        ++i;
                    }
                } else if (this.getRowAlignment() == Alignment.RIGHT) {
                    int i = oldMaxColumnCount - this.getColumnCount(rowIndex) - columnsToDelete;
                    while (i < this.getMaxColumnCount()) {
                        this.updateColumnWidth(i);
                        ++i;
                    }
                } else if (this.getRowAlignment() == Alignment.CENTER) {
                    int columnStartIndex = (oldMaxColumnCount - this.getColumnCount(rowIndex) - columnsToDelete) % 2 == 0 ? (oldMaxColumnCount - this.getColumnCount(rowIndex) - columnsToDelete) / 2 : (oldMaxColumnCount - this.getColumnCount(rowIndex) - columnsToDelete - 1) / 2;
                    int i = columnStartIndex;
                    while (i < this.getMaxColumnCount()) {
                        this.updateColumnWidth(i);
                        ++i;
                    }
                }
            }
            this.layoutChanged = true;
        }
    }

    public void setRowCount(int value) {
        if (value > 0) {
            int rowcount = this.getRowCount();
            if (value > rowcount) {
                int columnCnt = this.getMaxColumnCount();
                int i = rowcount;
                while (i < value) {
                    this.addRow(columnCnt);
                    ++i;
                }
                this.layoutChanged = true;
            }
            if (value < rowcount) {
                this.setDataRowCount(value);
                this.vTextData.setSize(value);
                this.vCellRectangles.setSize(value);
                this.vCellStatus.setSize(value);
            }
        }
    }

    public void setDiagonalElements(int r, int c, String value, boolean down) {
        block6: {
            int maxcolumncount = this.getMaxColumnCount();
            int rowcount = this.getRowCount();
            if (r < 0 || r >= rowcount || c < 0 || c >= maxcolumncount) break block6;
            if (down) {
                int x = c;
                int y = r;
                while (x < maxcolumncount && y < rowcount) {
                    if (x < this.getColumnCount(y)) {
                        this.setDataOfSpecialType(y, x, value);
                        this.setTextDataAt(y, x, value);
                    }
                    ++x;
                    ++y;
                }
            } else {
                int x = c;
                int y = r;
                while (x < maxcolumncount && y >= 0) {
                    if (x < this.getColumnCount(y)) {
                        this.setDataOfSpecialType(y, x, value);
                        this.setTextDataAt(y, x, value);
                    }
                    ++x;
                    --y;
                }
            }
        }
    }

    public void setToIdentity() {
        int maxcolumncount = this.getMaxColumnCount();
        int r = 0;
        while (r < this.getRowCount()) {
            this.setColumnCount(r, maxcolumncount);
            int c = 0;
            while (c < maxcolumncount) {
                this.setElementAt(r, c, "0");
                ++c;
            }
            ++r;
        }
        this.setDiagonalElements(0, 0, "1", true);
    }

    public void setElementAt(int r, int c, String value) {
        if (this.indicesAreInRange(r, c)) {
            this.setDataOfSpecialType(r, c, value);
            this.setTextDataAt(r, c, value);
        }
    }

    protected void setTextDataAt(int r, int c, String value) {
        int oldWidth = this.vTextData.get((int)r).get((int)c).getBoundingBox().width;
        this.vTextData.get(r).get(c).setText(value);
        if (oldWidth == this.columntextwidths[c] && Animal.getStringWidth(value, this.vTextData.get(r).get(c).getFont()) < this.columntextwidths[c]) {
            this.updateColumnWidth(c);
        } else {
            this.setColumnWidth(this.vTextData.get(r).get(c).getText(), this.vTextData.get(r).get(c).getFont(), r, c);
        }
        this.layoutChanged = true;
    }

    public void setCellStatus(byte b, int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            this.vCellStatus.get(r).set(c, b);
            this.visualPropertiesChanged = true;
        }
    }

    @Override
    public void setLocation(Point location) {
        this.location = location;
        this.updateLocations();
    }

    @Override
    public void setDepth(int depth) {
        if (depth > 1) {
            super.setDepth(depth);
            this.visualPropertiesChanged = true;
        }
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        this.visualPropertiesChanged = true;
    }

    @Override
    public void setFillColor(Color fillcolor) {
        this.fillColor = fillcolor;
        this.visualPropertiesChanged = true;
    }

    public void setHighlightColor(Color highlightColor) {
        this.cellHighlightColor = highlightColor;
        this.visualPropertiesChanged = true;
    }

    public void setElemHighlightColor(Color highlightColor) {
        this.elemHighlightColor = highlightColor;
        this.visualPropertiesChanged = true;
    }

    public void setFont(Font font) {
        int c;
        this.font = font;
        int r = 0;
        while (r < this.getRowCount()) {
            c = 0;
            while (c < this.getColumnCount(r)) {
                this.vTextData.get(r).get(c).setFont(font);
                ++c;
            }
            ++r;
        }
        int maxcolumncount = this.getMaxColumnCount();
        c = 0;
        while (c < maxcolumncount) {
            this.updateColumnWidth(c);
            ++c;
        }
        this.layoutChanged = true;
    }

    public void setTextColor(Color textcolor) {
        this.textColor = textcolor;
        this.visualPropertiesChanged = true;
    }

    @Override
    public void setFilled(boolean filled) {
        this.filled = filled;
        this.visualPropertiesChanged = true;
    }

    public void setMargin(int direction, int value) {
        if (value >= 0) {
            this.margin[direction % 4] = value;
            this.layoutChanged = true;
        }
    }

    public void setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
        this.layoutChanged = true;
    }

    public void setRowAlignment(Alignment rowAlignment) {
        this.rowAlignment = rowAlignment;
        this.layoutChanged = true;
    }

    public void setCellTextColor(int r, int c, Color endColor) {
        if (this.indicesAreInRange(r, c)) {
            this.vTextData.get(r).get(c).setColor(endColor);
        }
    }

    public void setCellFillColor(int r, int c, Color Color2) {
        if (this.indicesAreInRange(r, c)) {
            this.vCellRectangles.get(r).get(c).setFillColor(Color2);
        }
    }

    public void setCellColor(int r, int c, Color Color2) {
        if (this.indicesAreInRange(r, c)) {
            this.vCellRectangles.get(r).get(c).setColor(Color2);
        }
    }

    public void setPosition(Point node) {
        this.location = node;
        this.layoutChanged = true;
    }

    @Override
    public void paint(Graphics g) {
        if (this.layoutChanged) {
            this.updateLocations();
            this.layoutChanged = false;
        }
        if (this.visualPropertiesChanged) {
            this.updateCellProperties();
            this.visualPropertiesChanged = false;
        }
        int rowcount = this.getRowCount();
        int r = 0;
        while (r < rowcount) {
            int columncount = this.getColumnCount(r);
            int c = 0;
            while (c < columncount) {
                if (this.isFilled() || (this.vCellStatus.get(r).get(c) & 1) == 1 || (this.vCellStatus.get(r).get(c) & 8) == 8) {
                    this.vCellRectangles.get(r).get(c).paint(g);
                }
                if ((this.vCellStatus.get(r).get(c) & 8) == 8) {
                    this.vTextData.get(r).get(c).paint(g);
                }
                ++c;
            }
            ++r;
        }
    }

    @Override
    public void translate(int delta_x, int delta_y) {
        this.location.translate(delta_x, delta_y);
        int rowcount = this.getRowCount();
        int r = 0;
        while (r < rowcount) {
            int columncount = this.getColumnCount(r);
            int c = 0;
            while (c < columncount) {
                this.vCellRectangles.get(r).get(c).translate(delta_x, delta_y);
                this.vTextData.get(r).get(c).translate(delta_x, delta_y);
                ++c;
            }
            ++r;
        }
    }

    protected void cloneCommonFeaturesInto(PTMatrix targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        int rowcount = this.getRowCount();
        targetShape.setRowCount(rowcount);
        int r = 0;
        while (r < rowcount) {
            int columncount = this.getColumnCount(r);
            targetShape.setColumnCount(r, columncount);
            int c = 0;
            while (c < columncount) {
                targetShape.setOutlined(r, c, this.isCellOutlined(r, c));
                targetShape.setHighlighted(r, c, this.isCellHighlighted(r, c));
                targetShape.setElementHighlighted(r, c, this.isCellElementHighlighted(r, c));
                targetShape.setVisible(r, c, this.isCellVisible(r, c));
                targetShape.setElementAt(r, c, this.vTextData.get(r).get(c).getText());
                ++c;
            }
            ++r;
        }
        if (this.location != null) {
            targetShape.setLocation(new Point(this.location.x, this.location.y));
        }
        targetShape.setFilled(this.isFilled());
        targetShape.setFillColor(this.createColor(this.getFillColor()));
        targetShape.setHighlightColor(this.createColor(this.getHighlightColor()));
        targetShape.setElemHighlightColor(this.createColor(this.getElemHighlightColor()));
        targetShape.setFont(new Font(this.getFont().getFamily(), this.getFont().getStyle(), this.getFont().getSize()));
        targetShape.setTextColor(this.createColor(this.getTextColor()));
        targetShape.setMargin(0, this.getMargin(0));
        targetShape.setMargin(1, this.getMargin(1));
        targetShape.setMargin(2, this.getMargin(2));
        targetShape.setMargin(3, this.getMargin(3));
        targetShape.setRowAlignment(this.getRowAlignment());
        targetShape.setTextAlignment(this.getTextAlignment());
    }

    protected abstract void shrinkDataRow(int var1, int var2);

    protected abstract void setDataRowCount(int var1);

    protected abstract PTMatrix getPreClone();

    protected abstract void addDataRow();

    protected abstract void addDataItem(int var1);

    protected abstract void setDataOfSpecialType(int var1, int var2, String var3);

    private void setColumnWidth(String textstring, Font font, int row, int column) {
        if (this.getRowAlignment() == Alignment.LEFT) {
            int width;
            if (column < this.columntextwidths.length && (width = Animal.getStringWidth(textstring, font)) > this.columntextwidths[column]) {
                this.columntextwidths[column] = width;
            }
        } else if (this.getRowAlignment() == Alignment.RIGHT) {
            if (column < this.columntextwidths.length) {
                int columnStartIndex = this.getMaxColumnCount() - this.getColumnCount(row);
                if (Animal.getStringWidth(textstring, font) > this.columntextwidths[columnStartIndex + column]) {
                    this.columntextwidths[columnStartIndex + column] = Animal.getStringWidth(textstring, font);
                }
            }
        } else if (this.getRowAlignment() == Alignment.CENTER) {
            int maxColumnCnt = this.getMaxColumnCount();
            if ((maxColumnCnt - this.getColumnCount(row)) % 2 == 0) {
                int columnStartIndex = (maxColumnCnt - this.getColumnCount(row)) / 2;
                if (Animal.getStringWidth(textstring, font) > this.columntextwidths[columnStartIndex + column]) {
                    this.columntextwidths[columnStartIndex + column] = Animal.getStringWidth(textstring, font);
                }
            } else {
                int columnStartIndex = (maxColumnCnt - this.getColumnCount(row) - 1) / 2;
                int textWidth = Animal.getStringWidth(textstring, font);
                if (textWidth > this.columntextwidths[columnStartIndex + column]) {
                    this.columntextwidths[columnStartIndex + column] = Animal.getStringWidth(textstring, font);
                }
                if (textWidth > this.columntextwidths[columnStartIndex + column + 1]) {
                    this.columntextwidths[columnStartIndex + column + 1] = Animal.getStringWidth(textstring, font);
                }
            }
        }
    }

    private void enlargeColumnTextWidthsTo(int value) {
        int[] newwidths = new int[value];
        int i = 0;
        while (i < this.columntextwidths.length) {
            newwidths[i] = this.columntextwidths[i];
            ++i;
        }
        i = this.columntextwidths.length;
        while (i < value) {
            newwidths[i] = 0;
            ++i;
        }
        this.columntextwidths = newwidths;
    }

    private void shrinkColumnTextWidthsTo(int value) {
        int[] newwidths = new int[value];
        int i = 0;
        while (i < value) {
            newwidths[i] = this.columntextwidths[i];
            ++i;
        }
        this.columntextwidths = newwidths;
    }

    private void addRow(int columnCnt) {
        this.addDataRow();
        Vector tmpPTTextRowVector = new Vector();
        this.vTextData.add(tmpPTTextRowVector);
        Vector tmpPTRectangleRowVector = new Vector();
        this.vCellRectangles.add(tmpPTRectangleRowVector);
        Vector tmpByteRowVector = new Vector();
        this.vCellStatus.add(tmpByteRowVector);
        this.addColumns(this.getRowCount() - 1, columnCnt);
    }

    private void addColumns(int rowIndex, int columnCount) {
        if (columnCount > 0) {
            int oldColumnCount = this.getColumnCount(rowIndex);
            int c = 0;
            while (c < columnCount) {
                this.addDataItem(rowIndex);
                PTText tmpText = new PTText();
                tmpText.setText("0");
                tmpText.setFont(this.font);
                this.vTextData.get(rowIndex).add(tmpText);
                this.setColumnWidth("0", tmpText.getFont(), rowIndex, c + oldColumnCount);
                this.vCellRectangles.get(rowIndex).add(new PTRectangle());
                this.vCellStatus.get(rowIndex).add(new Byte(9));
                ++c;
            }
        }
    }

    private void updateLocations() {
        int x = this.location.x;
        int y = this.location.y;
        int cellheight = 0;
        int cellwidth = 0;
        int maxColumnCnt = this.getMaxColumnCount();
        boolean onGrid = true;
        int columnStartIndex = 0;
        int r = 0;
        while (r < this.getRowCount()) {
            int i;
            if (this.getRowAlignment() == Alignment.RIGHT) {
                columnStartIndex = maxColumnCnt - this.getColumnCount(r);
                i = 0;
                while (i < columnStartIndex) {
                    x += this.columntextwidths[i];
                    ++i;
                }
                x += columnStartIndex * (this.margin[3] + this.margin[1] + 1);
            } else if (this.getRowAlignment() == Alignment.CENTER) {
                if ((maxColumnCnt - this.getColumnCount(r)) % 2 == 0) {
                    columnStartIndex = (maxColumnCnt - this.getColumnCount(r)) / 2;
                    onGrid = true;
                } else {
                    columnStartIndex = (maxColumnCnt - (this.getColumnCount(r) + 1)) / 2;
                    onGrid = false;
                    x += this.columntextwidths[columnStartIndex] / 2 + this.margin[3];
                }
                i = 0;
                while (i < columnStartIndex) {
                    x += this.columntextwidths[i];
                    ++i;
                }
                x += columnStartIndex * (this.margin[3] + this.margin[1] + 1);
            }
            int c = 0;
            while (c < this.getColumnCount(r)) {
                cellheight = this.vTextData.get((int)r).get((int)c).getBoundingBox().height + this.margin[0];
                if (this.getRowAlignment() == Alignment.CENTER && !onGrid) {
                    cellwidth = this.margin[3] + this.columntextwidths[c + columnStartIndex] / 2 + this.columntextwidths[c + columnStartIndex + 1] / 2 + this.margin[1];
                    if (this.textAlignment == Alignment.LEFT) {
                        this.vTextData.get(r).get(c).setLocation(new Point(x + this.margin[3], y + this.margin[0]));
                    } else if (this.textAlignment == Alignment.CENTER) {
                        this.vTextData.get(r).get(c).setLocation(new Point(x + this.margin[3] + (this.columntextwidths[c + columnStartIndex] / 2 + this.columntextwidths[c + columnStartIndex + 1] / 2 - Animal.getStringWidth(this.vTextData.get(r).get(c).getText(), this.vTextData.get(r).get(c).getFont())) / 2, y + this.margin[0]));
                    } else {
                        this.vTextData.get(r).get(c).setLocation(new Point(x + this.margin[3] + (this.columntextwidths[c + columnStartIndex] / 2 + this.columntextwidths[c + columnStartIndex + 1] / 2 - Animal.getStringWidth(this.vTextData.get(r).get(c).getText(), this.vTextData.get(r).get(c).getFont())), y + this.margin[0]));
                    }
                } else {
                    cellwidth = this.margin[3] + this.columntextwidths[c + columnStartIndex] + this.margin[1];
                    if (this.textAlignment == Alignment.LEFT) {
                        this.vTextData.get(r).get(c).setLocation(new Point(x + this.margin[3], y + this.margin[0]));
                    } else if (this.textAlignment == Alignment.CENTER) {
                        this.vTextData.get(r).get(c).setLocation(new Point(x + this.margin[3] + (this.columntextwidths[c + columnStartIndex] - Animal.getStringWidth(this.vTextData.get(r).get(c).getText(), this.vTextData.get(r).get(c).getFont())) / 2, y + this.margin[0]));
                    } else {
                        this.vTextData.get(r).get(c).setLocation(new Point(x + this.margin[3] + (this.columntextwidths[c + columnStartIndex] - Animal.getStringWidth(this.vTextData.get(r).get(c).getText(), this.vTextData.get(r).get(c).getFont())), y + this.margin[0]));
                    }
                }
                this.vCellRectangles.get(r).get(c).setLocation(new Point(x, y));
                this.vCellRectangles.get(r).get(c).setHeight(cellheight += this.margin[2]);
                this.vCellRectangles.get(r).get(c).setWidth(cellwidth);
                x += cellwidth + 1;
                ++c;
            }
            x = this.location.x;
            y += cellheight + 1;
            ++r;
        }
    }

    private void updateCellProperties() {
        int r = 0;
        while (r < this.getRowCount()) {
            int c = 0;
            while (c < this.getColumnCount(r)) {
                if (this.isCellHighlighted(r, c) && !this.isCellOutlined(r, c)) {
                    this.vCellRectangles.get(r).get(c).setColor(this.getHighlightColor());
                } else if (!this.isCellOutlined(r, c)) {
                    this.vCellRectangles.get(r).get(c).setColor(this.getFillColor());
                } else {
                    this.vCellRectangles.get(r).get(c).setColor(this.getColor());
                }
                this.vCellRectangles.get(r).get(c).setDepth(this.depth);
                if (this.isCellHighlighted(r, c)) {
                    this.vCellRectangles.get(r).get(c).setFillColor(this.getHighlightColor());
                } else {
                    this.vCellRectangles.get(r).get(c).setFillColor(this.getFillColor());
                }
                this.vCellRectangles.get(r).get(c).setFilled(this.filled);
                if (this.isCellElementHighlighted(r, c)) {
                    this.vTextData.get(r).get(c).setColor(this.getElemHighlightColor());
                } else {
                    this.vTextData.get(r).get(c).setColor(this.textColor);
                }
                this.vTextData.get(r).get(c).setDepth(this.depth - 2);
                ++c;
            }
            ++r;
        }
    }

    protected abstract void updateTextualRepresentation();

    private void updateColumnWidth(int c) {
        block6: {
            block8: {
                block7: {
                    if (c >= this.columntextwidths.length) break block6;
                    this.columntextwidths[c] = 0;
                    if (this.getRowAlignment() != Alignment.LEFT) break block7;
                    int r = 0;
                    while (r < this.getRowCount()) {
                        if (c < this.getColumnCount(r)) {
                            this.setColumnWidth(this.vTextData.get(r).get(c).getText(), this.vTextData.get(r).get(c).getFont(), r, c);
                        }
                        ++r;
                    }
                    break block6;
                }
                if (this.getRowAlignment() != Alignment.RIGHT) break block8;
                int maxColumnCount = this.getMaxColumnCount();
                int r = 0;
                while (r < this.getRowCount()) {
                    int columnIndexIntoData = this.getColumnCount(r) - maxColumnCount + c;
                    if (columnIndexIntoData >= 0) {
                        this.setColumnWidth(this.vTextData.get(r).get(columnIndexIntoData).getText(), this.vTextData.get(r).get(columnIndexIntoData).getFont(), r, columnIndexIntoData);
                    }
                    ++r;
                }
                break block6;
            }
            if (this.getRowAlignment() != Alignment.CENTER) break block6;
            int maxColumnCount = this.getMaxColumnCount();
            int r = 0;
            while (r < this.getRowCount()) {
                int columnIndexIntoData = (maxColumnCount - this.getColumnCount(r)) % 2 == 0 ? c - (maxColumnCount - this.getColumnCount(r)) / 2 : c - (maxColumnCount - this.getColumnCount(r) - 1) / 2;
                if (columnIndexIntoData >= 0 && columnIndexIntoData < this.getColumnCount(r)) {
                    this.setColumnWidth(this.vTextData.get(r).get(columnIndexIntoData).getText(), this.vTextData.get(r).get(columnIndexIntoData).getFont(), r, columnIndexIntoData);
                }
                ++r;
            }
        }
    }

    @Override
    public void discard() {
        int r = 0;
        while (r < this.getRowCount()) {
            int c = 0;
            while (c < this.getColumnCount(r)) {
                this.vCellRectangles.get(r).get(c).discard();
                this.vTextData.get(r).get(c).discard();
                ++c;
            }
            ++r;
        }
        this.location = null;
        this.vTextData = null;
        this.vCellRectangles = null;
        this.columntextwidths = null;
        this.margin = null;
        super.discard();
    }

    protected boolean indicesAreInRange(int r, int c) {
        return r >= 0 && r < this.getRowCount() && c >= 0 && c < this.getColumnCount(r);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.valueOf(this.getType()) + " ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("count of rows ").append(this.getRowCount());
        sb.append("columns per row (r,c) ");
        int r = 0;
        while (r < this.getRowCount()) {
            sb.append(" (").append(r).append(",").append(this.getColumnCount(r)).append(") ");
            ++r;
        }
        return sb.toString();
    }

    @Override
    public String[] getDimensionIdentifiers(String kindOfObject) {
        if (kindOfObject.equals(KIND_OF_OBJECT_CELL)) {
            String[] tmpArray = new String[]{PRIMARY_DIMENSION_IDENTIFIER, SECONDARY_DIMENSION_IDENTIFIER};
            return tmpArray;
        }
        if (kindOfObject.equals(KIND_OF_OBJECT_ROW)) {
            String[] tmpArray = new String[]{PRIMARY_DIMENSION_IDENTIFIER};
            return tmpArray;
        }
        return null;
    }

    @Override
    public int getDimensionLength(String kindOfObject, String dimensionIdentifier, Vector<Integer> indices) {
        if (kindOfObject.equals(KIND_OF_OBJECT_CELL) && dimensionIdentifier.equals(PRIMARY_DIMENSION_IDENTIFIER)) {
            return this.getRowCount();
        }
        if (kindOfObject.equals(KIND_OF_OBJECT_CELL) && dimensionIdentifier.equals(SECONDARY_DIMENSION_IDENTIFIER) && indices.size() > 0 && indices.get(0) >= 0 && indices.get(0) < this.getRowCount()) {
            return this.getColumnCount(indices.get(0));
        }
        if (kindOfObject.equals(KIND_OF_OBJECT_ROW) && dimensionIdentifier.equals(PRIMARY_DIMENSION_IDENTIFIER)) {
            return this.getRowCount();
        }
        return 0;
    }

    @Override
    public String[] getKindsOfObjects() {
        String[] tmpArray = new String[]{KIND_OF_OBJECT_CELL, KIND_OF_OBJECT_ROW};
        return tmpArray;
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

