/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.OpenLineBasedShape;
import animal.misc.XProperties;
import java.awt.Point;

public class PTLine
extends OpenLineBasedShape {
    public static final String LINE_TYPE = "Line";
    private static final long serialVersionUID = 5293164474737251118L;

    public PTLine() {
        this.initializeWithDefaults(this.getType());
        this.fillNodesVector(2);
    }

    public PTLine(int x1, int y1, int x2, int y2) {
        this();
        this.nodes.set(0, new PTPoint(x1, y1));
        this.nodes.set(1, new PTPoint(x2, y2));
    }

    public PTLine(Point nodeA, Point nodeB) {
        this(nodeA.x, nodeA.y, nodeB.x, nodeB.y);
    }

    @Override
    public String getType() {
        return LINE_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{this.getType()};
    }

    public String toString() {
        return this.toString(this.getType());
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".start", this.getFirstNode().toPoint());
        defaultProperties.put(String.valueOf(this.getType()) + ".end", this.getLastNode().toPoint());
    }

    @Override
    public Object clone() {
        PTLine targetShape = new PTLine();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTLine targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFirstNode(this.getFirstNode().getX(), this.getFirstNode().getY());
        targetShape.setLastNode(this.getLastNode().getX(), this.getLastNode().getY());
    }

    @Override
    public int getFileVersion() {
        return 1;
    }
}

