/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTArray;
import animal.graphics.PTText;
import java.awt.Font;

public class PTIntArray
extends PTArray {
    public static final String TYPE_LABEL = "IntArray";

    public PTIntArray() {
        this.initializeWithDefaults(this.getType());
        int targetSize = this.getSize();
        if (targetSize == 0) {
            targetSize = 10;
        }
        this.init(targetSize);
    }

    public PTIntArray(int nrEntries) {
        this();
        this.init(nrEntries);
    }

    public PTIntArray(int[] x) {
        this(x.length);
        int i = 0;
        while (i < x.length) {
            this.enterValue(i, x[i]);
            ++i;
        }
    }

    @Override
    public Object clone() {
        PTIntArray targetShape = new PTIntArray();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public int enterValue(int index, int val) {
        if (index >= 0 && index < this.entry.length) {
            this.entry[index].setText(String.valueOf(val));
            int delta = index == 0 ? this.cellWidth(0) - this.entryPos[0] : this.cellWidth(index) - this.getBoundingBox((int)index).width;
            int i = index;
            while (i < this.entry.length) {
                if (i == index) {
                    this.resizeCell(i, delta, false);
                } else {
                    this.translate(i, delta, 0, true, true);
                }
                this.entryPos[i] = this.entryPos[i] + delta;
                ++i;
            }
            return 0;
        }
        return -1;
    }

    public int[] getValues() {
        int[] result = new int[this.getSize()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getValue(i);
            ++i;
        }
        return result;
    }

    public int getValue(int index) {
        if (index >= 0 && index < this.entry.length) {
            return Integer.parseInt(this.entry[index].getText());
        }
        return 0;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public int getFileVersion() {
        return 3;
    }

    @Override
    public void enterStringValueAt(int index, String text) {
        int value = 0;
        try {
            value = Integer.parseInt(text);
            this.enterValue(index, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    protected PTText createInternalValue(int cellPosition, Font targetFont) {
        return new PTText(String.valueOf(cellPosition), targetFont);
    }
}

