/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTPoint;
import animal.graphics.meta.CircularShape;
import animal.graphics.meta.ClosedArcBasedShape;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTCircle
extends ClosedArcBasedShape
implements CircularShape {
    public static final String CIRCLE_TYPE = "Circle";
    private int radius;
    private static final long serialVersionUID = 4711724437159551059L;

    @Override
    public int getFileVersion() {
        return 1;
    }

    public PTCircle() {
        this.initializeWithDefaults(this.getType());
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.radius, this.radius, 0, 360);
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    public int getAngle(Point p) {
        return this.getAngle(p, this.radius, this.radius);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBoundingBox(this.radius, this.radius);
    }

    @Override
    public int getLength() {
        return 360;
    }

    @Override
    public Point getPointAtLength(int alpha) {
        return this.getPointAtLength(alpha, this.radius, this.radius);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public String getType() {
        return CIRCLE_TYPE;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{CIRCLE_TYPE};
    }

    @Override
    public void setRadius(int r) {
        this.radius = r;
    }

    public String toString() {
        return this.toString(this.getType(), true, this.radius, this.radius);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
    }

    @Override
    public Object clone() {
        PTCircle targetShape = new PTCircle();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTCircle targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setRadius(this.radius);
    }
}

