/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.Polyline;
import algoanim.primitives.generators.Language;
import algoanim.properties.PolylineProperties;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import java.util.Vector;

public class PTPolylineExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTPolyline shape = (PTPolyline)ptgo;
        if (PTPolylineExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Node[] vertices = new Node[shape.getNodeCount()];
        Vector<PTPoint> nodes = shape.getNodes();
        int pos = 0;
        for (PTPoint node : nodes) {
            vertices[pos++] = Node.convertToNode(node.toPoint());
        }
        PolylineProperties pp = new PolylineProperties();
        this.installStandardProperties(pp, shape, isVisible);
        pp.set("bwArrow", shape.hasBWArrow());
        pp.set("fwArrow", shape.hasFWArrow());
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        Polyline result = lang.newPolyline(vertices, shape.getObjectName(), t, pp);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

