/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.EllipseSeg;
import algoanim.primitives.generators.Language;
import algoanim.properties.EllipseSegProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTOpenEllipseSegment;

public class PTOpenEllipseSegmentExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTOpenEllipseSegment shape = (PTOpenEllipseSegment)ptgo;
        if (PTOpenEllipseSegmentExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates center = Node.convertToNode(shape.getCenter());
        Coordinates radius = Node.convertToNode(shape.getRadius());
        EllipseSegProperties esp = new EllipseSegProperties();
        this.installStandardProperties(esp, shape, isVisible);
        esp.set("angle", shape.getTotalAngle());
        esp.set("startAngle", shape.getStartAngle());
        esp.set("clockwise", shape.isClockwise());
        esp.set("counterclockwise", !shape.isClockwise());
        esp.set("closed", true);
        esp.set("fwArrow", shape.hasFWArrow());
        esp.set("bwArrow", shape.hasBWArrow());
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        EllipseSeg result = lang.newEllipseSeg(center, radius, shape.getObjectName(), t, esp);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

