/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.Ellipse;
import algoanim.primitives.generators.Language;
import algoanim.properties.EllipseProperties;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTEllipse;
import animal.graphics.PTGraphicObject;

public class PTEllipseExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTEllipse shape = (PTEllipse)ptgo;
        if (PTEllipseExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates center = Node.convertToNode(shape.getCenter());
        Coordinates radius = Node.convertToNode(shape.getRadius());
        EllipseProperties cp = new EllipseProperties();
        this.installStandardProperties(cp, shape, isVisible);
        cp.set("filled", shape.isFilled());
        if (shape.isFilled()) {
            cp.set("fillColor", shape.getFillColor());
        }
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        Ellipse result = lang.newEllipse(center, radius, shape.getObjectName(), t, cp);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

