/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.DoubleArray;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayProperties;
import algoanim.util.ArrayDisplayOptions;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTDoubleArray;
import animal.graphics.PTGraphicObject;
import animal.misc.ColorChoice;
import java.awt.Font;

public class PTDoubleArrayExporter
extends PTGraphicObjectExporter {
    public String getExportString(PTGraphicObject ptgo) {
        StringBuilder sb = new StringBuilder(200);
        PTDoubleArray shape = (PTDoubleArray)ptgo;
        if (PTDoubleArrayExporter.getExportStatus(ptgo)) {
            return "# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName();
        }
        sb.append("array \"").append(shape.getObjectName()).append("\"");
        sb.append(" (");
        sb.append(shape.getLocation().x);
        sb.append(',');
        sb.append(shape.getLocation().y);
        sb.append(')');
        sb.append(" color " + ColorChoice.getColorName(shape.getColor()));
        sb.append(" fillColor " + ColorChoice.getColorName(shape.getBGColor()));
        sb.append(" elementColor " + ColorChoice.getColorName(shape.getFontColor()));
        sb.append(" elemHighlight " + ColorChoice.getColorName(shape.getElemHighlightColor()));
        sb.append(" cellHighlight " + ColorChoice.getColorName(shape.getHighlightColor()));
        int size = shape.getSize();
        sb.append(" length " + size);
        int i = 0;
        while (i < size) {
            sb.append('\"').append(shape.getStringValueAt(i)).append("\" ");
            ++i;
        }
        Font font = shape.getFont();
        sb.append(" font ");
        sb.append(font.getName());
        sb.append(" size ");
        sb.append(font.getSize());
        if (font.isBold()) {
            sb.append(" bold");
        }
        if (font.isItalic()) {
            sb.append(" italic");
        }
        sb.append(" depth " + shape.getDepth());
        return sb.toString();
    }

    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTDoubleArray shape = (PTDoubleArray)ptgo;
        if (PTDoubleArrayExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        Coordinates location = Node.convertToNode(shape.getLocation());
        ArrayProperties ap = new ArrayProperties();
        this.installStandardProperties(ap, shape, isVisible);
        ap.set("fillColor", shape.getBGColor());
        ap.set("color", shape.getColor());
        ap.set("filled", true);
        ap.set("elementColor", shape.getFontColor());
        ap.set("elemHighlight", shape.getElemHighlightColor());
        ap.set("cellHighlight", shape.getHighlightColor());
        ap.set("vertical", true);
        ap.set("cascaded", false);
        double[] values = new double[shape.getSize()];
        int i = 0;
        while (i < values.length) {
            values[i] = shape.getValue(i);
            ++i;
        }
        ArrayDisplayOptions t = new ArrayDisplayOptions(null, null, false);
        DoubleArray result = lang.newDoubleArray(location, values, shape.getObjectName(), t, ap);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

