/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript;

import animal.exchange.animalscript.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTStringArray;
import animal.misc.ColorChoice;
import java.awt.Font;

public class PTStringArrayExporter
extends PTGraphicObjectExporter {
    @Override
    public String getExportString(PTGraphicObject ptgo) {
        StringBuilder sb = new StringBuilder(200);
        PTStringArray shape = (PTStringArray)ptgo;
        if (PTStringArrayExporter.getExportStatus(ptgo)) {
            return "# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName();
        }
        sb.append("array \"").append(shape.getObjectName()).append("\"");
        sb.append(" (");
        sb.append(shape.getLocation().x);
        sb.append(',');
        sb.append(shape.getLocation().y);
        sb.append(')');
        sb.append(" color " + ColorChoice.getColorName(shape.getColor()));
        sb.append(" fillColor " + ColorChoice.getColorName(shape.getBGColor()));
        sb.append(" elementColor " + ColorChoice.getColorName(shape.getFontColor()));
        sb.append(" elemHighlight " + ColorChoice.getColorName(shape.getElemHighlightColor()));
        sb.append(" cellHighlight " + ColorChoice.getColorName(shape.getHighlightColor()));
        int size = shape.getSize();
        sb.append(" length " + size);
        int i = 0;
        while (i < size) {
            sb.append('\"').append(shape.getStringValueAt(i)).append("\" ");
            ++i;
        }
        Font font = shape.getFont();
        sb.append(" font ");
        sb.append(font.getName());
        sb.append(" size ");
        sb.append(font.getSize());
        if (font.isBold()) {
            sb.append(" bold");
        }
        if (font.isItalic()) {
            sb.append(" italic");
        }
        sb.append(" depth " + shape.getDepth());
        hasBeenExported.put(shape, shape.getObjectName());
        return sb.toString();
    }
}

