/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript;

import animal.exchange.animalscript.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.misc.ColorChoice;
import java.awt.Color;

public class PTPolylineExporter
extends PTGraphicObjectExporter {
    @Override
    public String getExportString(PTGraphicObject ptgo) {
        StringBuilder sb = new StringBuilder(200);
        PTPolyline polyline = (PTPolyline)ptgo;
        if (PTPolylineExporter.getExportStatus(polyline)) {
            return "# previously exported: '" + polyline.getNum(false) + "/" + polyline.getObjectName();
        }
        sb.append("polyline ");
        sb.append("\"").append(polyline.getObjectName()).append("\"");
        int n = polyline.getNodeCount();
        PTPoint node = null;
        int i = 0;
        while (i < n) {
            node = polyline.getNodeAt(i);
            sb.append(" (");
            sb.append(node.getX());
            sb.append(",");
            sb.append(node.getY());
            sb.append(")");
            ++i;
        }
        Color color = polyline.getColor();
        sb.append(" color ").append(ColorChoice.getColorName(color));
        sb.append(" depth ").append(polyline.getDepth());
        if (polyline.hasFWArrow()) {
            sb.append(" fwArrow");
        }
        if (polyline.hasBWArrow()) {
            sb.append(" bwArrow");
        }
        hasBeenExported.put(polyline, polyline.getObjectName());
        return sb.toString();
    }
}

