/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTDoubleArray;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import java.awt.Font;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTDoubleArrayImporter
extends PTGraphicObjectImporter {
    @Override
    public Object importFrom(int version, StreamTokenizer stok) {
        PTDoubleArray array;
        try {
            array = new PTDoubleArray();
            if (version > array.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(array.getFileVersion()), stok.toString()});
            }
            ParseSupport.parseMandatoryWord(stok, "DoubleArray keyword 'size'", "size");
            int size = ParseSupport.parseInt(stok, "size", 0);
            array = new PTDoubleArray(size);
            ParseSupport.parseMandatoryWord(stok, "DoubleArray keyword 'entries'", "entries");
            ParseSupport.parseMandatoryChar(stok, "{", '{');
            int i = 0;
            while (i < size) {
                array.enterValue(i, ParseSupport.parseDouble(stok, "DoubleArray[" + i + "]"));
                ++i;
            }
            ParseSupport.parseMandatoryChar(stok, "}", '}');
            ParseSupport.parseMandatoryWord(stok, "DoubleArray location", "location");
            array.setOrigin(ParseSupport.parseNode(stok, "location"));
            array.setBGColor(ParseSupport.parseColor(stok, "background color", "bgColor"));
            ParseSupport.parseMandatoryWord(stok, "DoubleArray keyword 'font'", "font");
            ParseSupport.parseMandatoryChar(stok, "DoubleArray keyword font '('", '(');
            String fontName = ParseSupport.parseWord(stok, "font name");
            ParseSupport.parseMandatoryChar(stok, "DoubleArray keyword font ','", ',');
            int fontSize = ParseSupport.parseInt(stok, "font size");
            ParseSupport.parseMandatoryChar(stok, "DoubleArray keyword font ')'", ')');
            Font font = new Font(fontName, 0, fontSize);
            array.setFont(font);
            array.setFontColor(ParseSupport.parseColor(stok, "DoubleArray font color", "fontColor"));
            array.setOutlineColor(ParseSupport.parseColor(stok, "DoubleArray outline color", "outlineColor"));
            array.setHighlightColor(ParseSupport.parseColor(stok, "DoubleArray highlight color", "highlightColor"));
            if (version >= 3) {
                array.setElemHighlightColor(ParseSupport.parseColor(stok, "DoubleArray element highlight color", "elementHighlightColor"));
            }
            if (version >= 2) {
                array.showIndices(ParseSupport.parseOptionalWord(stok, "Show cell indices?", "showIndices"));
            }
            ParseSupport.parseMandatoryWord(stok, "DoubleArray keyword 'depth'", "depth");
            array.setDepth(ParseSupport.parseInt(stok, "DoubleArray depth", 2));
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
            array = new PTDoubleArray();
        }
        return array;
    }
}

