/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTLine;
import animal.graphics.PTPolyline;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class PTBoxPointerImporter
extends PTGraphicObjectImporter {
    @Override
    public Object importFrom(int version, StreamTokenizer stok) {
        PTBoxPointer shape = new PTBoxPointer();
        shape.init();
        try {
            if (version > shape.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(shape.getFileVersion()), stok.toString()});
            }
            shape.setColor(ParseSupport.parseColor(stok, "BoxPointer"));
            Color fillColor = ParseSupport.parseColor(stok, "BoxPointer fill", "fillColor");
            shape.getTextBox().setFillColor(fillColor);
            Color pointerAreaColor = shape.getColor();
            if (version >= 5) {
                pointerAreaColor = ParseSupport.parseColor(stok, "Pointer area color", "pointerAreaColor");
            }
            shape.getPointerArea().setFillColor(pointerAreaColor);
            Color pointerAreaFillColor = ParseSupport.parseColor(stok, "BoxPointer area fill", "pointerFillColor");
            shape.getPointerArea().setFillColor(pointerAreaFillColor);
            ParseSupport.parseMandatoryWord(stok, "BoxPointer keyword 'textBox'", "textBox");
            PTPolyline box = AnimalParseSupport.parsePolyline(stok, "BoxPointer text box");
            Rectangle bb = box.getBoundingBox();
            shape.setLocation(new Point(bb.x, bb.y));
            ParseSupport.parseMandatoryWord(stok, "pointerArea of BoxPointer expected", "pointerArea");
            AnimalParseSupport.parsePolyline(stok, "BoxPointer pointer area");
            ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'pointerPosition'", "pointerPosition");
            shape.setPointerPosition(ParseSupport.parseInt(stok, "BoxPtr pointer position", 0, 4));
            ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'pointers'", "pointers");
            ParseSupport.parseMandatoryChar(stok, "BoxPointer pointers open brace", '{');
            Vector<PTPolyline> pointers = new Vector<PTPolyline>(10, 5);
            int nrPointers = 0;
            while (!ParseSupport.parseOptionalChar(stok, "BoxPointer pointers close brace", '}')) {
                PTPolyline polyline = AnimalParseSupport.parsePolyline(stok, "BoxPointer pointer area");
                if (polyline == null) continue;
                Point node0 = polyline.getNodeAsPoint(0);
                Point node1 = polyline.getNodeAsPoint(1);
                node1.translate(-node0.x, -node0.y);
                pointers.addElement(polyline);
                polyline.setFWArrow(true);
                ++nrPointers;
            }
            shape.setPointerCountWithoutReinitialization(nrPointers);
            int pos = 0;
            while (pos < pointers.size()) {
                PTPolyline currentPointer = (PTPolyline)pointers.elementAt(pos);
                shape.setTip(pos, currentPointer.getNodeAsPoint(1));
                ++pos;
            }
            ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword text", "text");
            ParseSupport.parseMandatoryChar(stok, "BoxPtr keyword text ':'", ':');
            shape.getTextComponent().setText(AnimalParseSupport.parseText(stok, "BoxPtr text component"));
            if (version >= 4) {
                shape.getTextComponent().setColor(ParseSupport.parseColor(stok, "BoxPtr text color", "textColor"));
            } else {
                shape.getTextComponent().setColor(Color.BLACK);
            }
            if (version >= 5) {
                ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'Font'", "Font");
                ParseSupport.parseMandatoryChar(stok, "BoxPtr keyword text '{'", '{');
                String fn = AnimalParseSupport.parseText(stok, "BoxPtr FontName");
                int fontStyle = ParseSupport.parseInt(stok, "BoxPtr textStyle");
                int fontSize = ParseSupport.parseInt(stok, "BoxPtr textSize");
                shape.getTextComponent().setFont(new Font(fn, fontStyle, fontSize));
                ParseSupport.parseMandatoryChar(stok, "BoxPtr keyword text '}'", '}');
                ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'depth'", "depth");
                int basicDepth = ParseSupport.parseInt(stok, "BoxPtr depth");
                shape.setDepth(basicDepth);
                shape.getPointerArea().setDepth(basicDepth + 1);
                if (shape.getPointers() != null) {
                    for (PTLine currentPointer : shape.getPointers()) {
                        if (currentPointer == null) continue;
                        currentPointer.setDepth(basicDepth);
                    }
                }
                shape.getTextBox().setDepth(basicDepth + 1);
                shape.getTextComponent().setDepth(basicDepth);
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        shape.init();
        return shape;
    }
}

