/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.AnimalASCIIImporter;
import animal.exchange.animalascii.Importer;
import animal.main.Link;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;

public class LinkImporter
implements Importer {
    @Override
    public Object importFrom(int version, StreamTokenizer stok) {
        XProperties props = new XProperties();
        try {
            if (version > Link.getFileVersion()) {
                throw new StreamCorruptedException(AnimalASCIIImporter.translateMessage("wrongLinkVersion", new Integer[]{version, Link.getFileVersion()}));
            }
            if (!ParseSupport.parseOptionalWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "end"), "END")) {
                props.put("Link.step", ParseSupport.parseInt(stok, "Link number"));
                ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "next"), "next");
                ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "step"), "step");
                props.put("Link.nextStep", ParseSupport.parseInt(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "next link number")));
                ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "after"), "after");
                if (ParseSupport.parseOptionalWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "time"), "time")) {
                    props.put("Link.mode", 2);
                    props.put("Link.time", ParseSupport.parseInt(stok, AnimalASCIIImporter.translateMessage("linkTimedWaitPeriod")));
                    ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "ms"), "ms");
                } else if (ParseSupport.parseOptionalWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "key"), "key")) {
                    props.put("Link.mode", 1);
                    ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "press"), "press");
                } else if (ParseSupport.parseOptionalWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "click"), "click")) {
                    props.put("Link.mode", 4);
                    ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "on"), "on");
                    ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "ID"), "id");
                    props.put("Link.clickTargetID", ParseSupport.parseInt(stok, AnimalASCIIImporter.translateMessage("linkTargetID")));
                } else {
                    ParseSupport.formatException(AnimalASCIIImporter.translateMessage("unknownLinkTransition", (Object)stok.sval), stok);
                }
            } else {
                props.put("Link.step", Integer.MAX_VALUE);
                props.put("Link.nextStep", Integer.MAX_VALUE);
            }
            if (ParseSupport.parseOptionalWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Link", "label"), "label")) {
                props.put("Link.label", AnimalParseSupport.parseText(stok, "Link label"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("ZZZ" + e.getMessage(), 4);
        }
        return new Link(props);
    }
}

