/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.animator.Animator;
import animal.exchange.AnimationImporter;
import animal.exchange.animalascii.AnimatorImporter;
import animal.exchange.animalascii.Importer;
import animal.exchange.animalascii.LinkImporter;
import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTGraphicObject;
import animal.main.Animal;
import animal.main.Animation;
import animal.main.Link;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import translator.Translator;

public class AnimalASCIIImporter
extends AnimationImporter {
    private static Hashtable<String, Importer> asciiImporters = new Hashtable(73);
    protected Animal animal;
    private Animation animation;
    private boolean isCompressed = true;
    private XProperties objectIDMapper;
    private StreamTokenizer stok;
    public static Translator translator = new Translator("AnimalASCIIRes", Locale.US);
    public static StringBuilder fileContents = null;

    @Override
    public void init(String format) {
        super.init(format);
        this.isCompressed = format.endsWith("-compressed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Animation importAnimationFrom(String filename) {
        Animation anim = new Animation();
        InputStream in = null;
        if (filename == null) return new Animation();
        if (filename.equals("")) {
            return new Animation();
        }
        try {
            if (filename.startsWith("http:") || filename.startsWith("https:") || filename.startsWith("file:")) {
                URL targetURL = new URL(filename);
                if (targetURL == null) {
                    return null;
                }
                in = targetURL.openStream();
            } else {
                in = new FileInputStream(filename);
            }
            try {
                in = new GZIPInputStream(in);
            }
            catch (IOException e) {
                in.close();
                this.isCompressed = false;
                in = new FileInputStream(filename);
            }
            anim = this.importAnimationFrom(in, filename);
            in.close();
            return anim;
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("importException", filename, e.getMessage()), 4);
        }
        return anim;
    }

    @Override
    public Animation importAnimationFrom(InputStream inStream, String filename) {
        InputStream actualStream = inStream;
        try {
            if (filename != null && (filename.endsWith(".aml") || filename.endsWith(".animal")) && !(actualStream instanceof GZIPInputStream)) {
                actualStream = new GZIPInputStream(actualStream);
            }
            InputStreamReader isr = new InputStreamReader(actualStream);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder(65536);
            String currentLine = null;
            while ((currentLine = br.readLine()) != null) {
                sb.append(currentLine).append("\n");
            }
            this.stok = new StreamTokenizer(new StringReader(sb.toString()));
            this.stok.eolIsSignificant(true);
            this.stok.quoteChar(34);
            if (this.animal == null) {
                this.animal = Animal.get();
            }
            this.animal.getEditors();
            this.objectIDMapper = new XProperties();
            long timeTaken = System.currentTimeMillis();
            this.animation = this.importAnim();
            fileContents = sb;
            if (this.animation == null) {
                this.animation = new Animation();
            }
            timeTaken = System.currentTimeMillis() - timeTaken;
            this.objectIDMapper = null;
            br.close();
            isr.close();
            MessageDisplay.message(AnimalASCIIImporter.translateMessage("loadedInIn", String.valueOf(timeTaken)));
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("importException", filename, e.getMessage()), 4);
        }
        return this.animation;
    }

    protected Animation importAnim() {
        int fileID = 0;
        try {
            ParseSupport.parseMandatoryChar(this.stok, "#", '#');
        }
        catch (StreamCorruptedException scee) {
            MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("incorrectFormat"), 4);
            return null;
        }
        try {
            this.animation = new Animation();
            ParseSupport.parseMandatoryWord(this.stok, "Animal", "Animal");
            ParseSupport.parseMandatoryWord(this.stok, AnimalASCIIImporter.translateMessage("keyword", (Object)"protocol"), "protocol");
            int p_version = ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("protocol"));
            if (p_version > 1) {
                throw new StreamCorruptedException(AnimalASCIIImporter.translateMessage("invalidOrMissingProtocol", String.valueOf(this.stok.nval)));
            }
            if (ParseSupport.parseOptionalWord(this.stok, AnimalASCIIImporter.translateMessage("animBoundingBox"), "size")) {
                try {
                    this.animation.setWidth(ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("animW"), 0));
                    ParseSupport.parseMandatoryChar(this.stok, AnimalASCIIImporter.translateMessage("animAsterisk"), '*');
                    this.animation.setHeight(ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("animW"), 0));
                }
                catch (StreamCorruptedException e2) {
                    MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("animBoundingBoxCorruptButNoMatter", (Object)e2.getMessage()), 4);
                }
            }
            ParseSupport.consumeIncludingEOL(this.stok, AnimalASCIIImporter.translateMessage("expectedEOL"));
            if (ParseSupport.parseOptionalWord(this.stok, AnimalASCIIImporter.translateMessage("titleKw"), "title")) {
                this.animation.setTitle(ParseSupport.parseText(this.stok, AnimalASCIIImporter.translateMessage("title")));
                ParseSupport.consumeIncludingEOL(this.stok, AnimalASCIIImporter.translateMessage("expectedEOL"));
            }
            if (ParseSupport.parseOptionalWord(this.stok, AnimalASCIIImporter.translateMessage("authorKw"), "author")) {
                this.animation.setAuthor(ParseSupport.parseText(this.stok, AnimalASCIIImporter.translateMessage("author")));
                ParseSupport.consumeIncludingEOL(this.stok, AnimalASCIIImporter.translateMessage("expectedEOL"));
            }
            this.parseAndInsertGraphicObjects();
            ParseSupport.parseMandatoryWord(this.stok, AnimalASCIIImporter.translateMessage("linkSteps"), "STEPS");
            ParseSupport.parseMandatoryChar(this.stok, AnimalASCIIImporter.translateMessage("linkColon"), ':');
            ParseSupport.consumeIncludingEOL(this.stok, AnimalASCIIImporter.translateMessage("expectedEOL"));
            int token = 0;
            while (!ParseSupport.parseOptionalWord(this.stok, AnimalASCIIImporter.translateMessage("end"), "Next")) {
                this.stok.pushBack();
                fileID = ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("cVersion"));
                if (ParseSupport.parseOptionalWord(this.stok, AnimalASCIIImporter.translateMessage("linkKw"), "Link")) {
                    this.parseAndInsertLink(fileID);
                } else if (ParseSupport.parseOptionalWord(this.stok, AnimalASCIIImporter.translateMessage("linkKw"), "Step")) {
                    this.parseAndInsertAnimator(fileID);
                } else {
                    MessageDisplay.errorMsg(String.valueOf(this.stok.sval) + "/" + this.stok.nval + "/" + this.stok.ttype + " @ " + this.stok.lineno(), 4);
                }
                while ((token = this.stok.nextToken()) != 10 && token != -1) {
                }
            }
            int throwAway = ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("nextGOID"));
            this.animation.setNextGraphicObjectNum(throwAway + 1);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("******" + e.getMessage(), 4);
        }
        return this.animation;
    }

    private Importer getLocalImporterFor(String className) {
        try {
            if (!asciiImporters.containsKey(className)) {
                StringBuilder handlerName = new StringBuilder("animal.exchange.animalascii.");
                handlerName.append(className.substring(className.lastIndexOf(46) + 1));
                handlerName.append("Importer");
                String subName = handlerName.toString();
                Class<?> c = Class.forName(subName);
                Importer handler = (Importer)c.newInstance();
                asciiImporters.put(className, handler);
            }
        }
        catch (Exception e) {
            MessageDisplay.errorMsg(String.valueOf(e.getClass().getName()) + "**********" + e.getMessage(), 4);
        }
        return asciiImporters.get(className);
    }

    public void parseAndInsertAnimator(int version) {
        AnimatorImporter importer = null;
        Animator currentAnimator = null;
        Hashtable<String, String> registeredTypes = Animator.registeredHandlers;
        String objectName = null;
        try {
            this.stok.pushBack();
            ParseSupport.parseMandatoryWord(this.stok, AnimalASCIIImporter.translateMessage("aStepKw"), "Step");
            int stepNr = ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("stepNr"));
            objectName = ParseSupport.parseWord(this.stok, AnimalASCIIImporter.translateMessage("objectType"));
            if (registeredTypes.containsKey(objectName.toLowerCase())) {
                String targetType = registeredTypes.get(objectName.toLowerCase());
                try {
                    importer = (AnimatorImporter)this.getLocalImporterFor(targetType);
                    Object dummyObject = importer.importFrom(version, stepNr, this.stok);
                    currentAnimator = dummyObject instanceof Animator ? (Animator)dummyObject : null;
                }
                catch (Exception e) {
                    MessageDisplay.errorMsg("****" + e.getMessage() + " / " + e.toString(), 4);
                }
            } else {
                MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("noSuchHandler", new Object[]{objectName.toLowerCase(), String.valueOf(this.stok.lineno())}), 4);
            }
            if (currentAnimator != null) {
                this.animation.insertAnimator(currentAnimator);
            }
            this.stok.pushBack();
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("******" + e.getMessage(), 4);
        }
    }

    public void parseAndInsertGraphicObjects() {
        PTGraphicObjectImporter importer = null;
        PTGraphicObject currentObject = null;
        Hashtable<String, String> registeredTypes = PTGraphicObject.registeredTypes;
        String objectName = null;
        try {
            while (this.stok.nextToken() != -3) {
                this.stok.pushBack();
                int fileID = ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("goVersion"), 1);
                ParseSupport.parseMandatoryWord(this.stok, AnimalASCIIImporter.translateMessage("goObjectKw"), "object");
                int objectID = ParseSupport.parseInt(this.stok, AnimalASCIIImporter.translateMessage("goid"), 1);
                objectName = ParseSupport.parseWord(this.stok, AnimalASCIIImporter.translateMessage("goType"));
                if (registeredTypes.containsKey(objectName.toLowerCase())) {
                    String targetType = registeredTypes.get(objectName.toLowerCase());
                    try {
                        importer = (PTGraphicObjectImporter)this.getLocalImporterFor(targetType);
                        Object dummyObject = importer.importFrom(fileID, this.stok);
                        currentObject = dummyObject instanceof PTGraphicObject ? (PTGraphicObject)dummyObject : null;
                        ParseSupport.consumeIncludingEOL(this.stok, "++");
                    }
                    catch (Exception e) {
                        MessageDisplay.errorMsg("****" + e.getMessage() + " / " + e.toString(), 4);
                    }
                } else {
                    MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("noSuchHandler", new Object[]{objectName.toLowerCase(), String.valueOf(this.stok.lineno())}), 4);
                    int token = -21;
                    while ((token = this.stok.nextToken()) != 10) {
                    }
                }
                if (currentObject == null) continue;
                currentObject.resetNum();
                currentObject.setNum(objectID);
                this.animation.insertGraphicObject(currentObject);
                this.objectIDMapper.put(String.valueOf(objectID), currentObject.getNum(false));
            }
            this.stok.pushBack();
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("******" + e.getMessage(), 4);
        }
    }

    public void parseAndInsertLink(int version) {
        LinkImporter linkImporter;
        Object linkObject;
        Importer importer = this.getLocalImporterFor("animal.main.Link");
        if (importer != null && importer instanceof LinkImporter && (linkObject = (linkImporter = (LinkImporter)importer).importFrom(version, this.stok)) != null && linkObject instanceof Link && ((Link)linkObject).getStep() != Integer.MAX_VALUE) {
            this.animation.insertLink((Link)linkObject);
        }
    }

    @Override
    public String getDefaultExtension() {
        return this.isCompressed ? "aml" : "ama";
    }

    @Override
    public String getMIMEType() {
        return "animation/animal-ascii" + (this.isCompressed ? "-compressed" : "");
    }

    @Override
    public String getFormatDescription() {
        return this.toString();
    }

    @Override
    public String toString() {
        return AnimalASCIIImporter.translateMessage("asciiImportDescription");
    }

    public static String translateMessage(String key) {
        return translator.translateMessage(key);
    }

    public static String translateMessage(String key, Object[] params) {
        return translator.translateMessage(key, params);
    }

    public static String translateMessage(String key, String ... params) {
        return translator.translateMessage(key, params);
    }

    public static String translateMessage(String key, Object param) {
        return translator.translateMessage(key, new Object[]{param});
    }
}

