/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.properties;

import animal.editor.properties.PropertyEditor;
import animal.main.PropertiedObject;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class StringPropertyEditor
extends PropertyEditor
implements ActionListener {
    private JTextField textField;

    public StringPropertyEditor(String type, XProperties properties) {
        super(type, properties);
    }

    @Override
    public void addEditorTo(Container container) {
        String property = this.getProperties().getProperty("property");
        String currentText = this.getTargetObject().getProperties().getProperty(property);
        JLabel myLabel = new JLabel(this.getProperties().getProperty("param0"));
        this.textField = new JTextField(currentText, 20);
        this.textField.addActionListener(this);
        container.add(myLabel);
        container.add(this.textField);
    }

    @Override
    public void storeProperty() {
        String propertyToChange = this.getProperties().getProperty("property");
        this.getTargetObject().getProperties().put(propertyToChange, this.textField.getText());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PropertiedObject targetObject = this.getTargetObject();
        if (targetObject != null && targetObject.getProperties() != null) {
            String propertyToChange = this.getProperties().getProperty("property");
            targetObject.getProperties().put(propertyToChange, actionEvent.getActionCommand());
        } else {
            MessageDisplay.errorMsg("objectNull", new Object[]{this.getClass()});
        }
    }
}

