/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JLabel;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class PointEditor
extends GraphicEditor
implements PropertyChangeListener {
    private static final long serialVersionUID = 2295451210977833754L;
    private ColorChooserAction colorChooser;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box colorBox = generator.generateBorderedBox(2, "GenericEditor.colorBL");
        JLabel colorLabel = AnimalTranslator.getGUIBuilder().generateJLabel("GenericEditor.colorLabel");
        colorBox.add(colorLabel);
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTPoint)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"Point"}), initialColor);
        ExtendedActionButton button = new ExtendedActionButton(this.colorChooser, 67);
        colorBox.add(button);
        this.addBox(colorBox);
        this.finishBoxes();
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Point.color", Color.black));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("Point.color", this.colorChooser.getColor());
    }

    @Override
    public int pointsNeeded() {
        return 1;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        if (num == 1) {
            ((PTPoint)this.getCurrentObject()).set(p);
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(((PTPoint)go).toPoint(), p);
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        return new EditPoint[]{new EditPoint(-1, ((PTPoint)go).toPoint())};
    }

    @Override
    public EditableObject createObject() {
        PTPoint result = new PTPoint();
        this.storeAttributesInto(result);
        return result;
    }

    @Override
    public Editor getSecondaryEditor(EditableObject e) {
        PointEditor result = new PointEditor();
        result.extractAttributesFrom(e);
        return result;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTPoint point = (PTPoint)eo;
        point.setColor(this.colorChooser.getColor());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTPoint point = (PTPoint)eo;
        this.colorChooser.setColor(point.getColor());
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("PointEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTPoint point = (PTPoint)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            point.setColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "Point";
    }
}

