/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import translator.AnimalTranslator;

public abstract class GraphicEditor
extends Editor {
    private static final long serialVersionUID = 633413558545294186L;

    public GraphicEditor() {
        super(AnimalMainWindow.getWindowCoordinator().getDrawWindow(false));
        this.buildGUI();
    }

    protected abstract void buildGUI();

    public abstract int pointsNeeded();

    public abstract boolean nextPoint(int var1, Point var2);

    @Override
    public void repaintNow() {
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).getDrawCanvas().repaintAll();
    }

    public abstract int getMinDist(PTGraphicObject var1, Point var2);

    public abstract EditPoint[] getEditPoints(PTGraphicObject var1);

    public ColorChooserAction createColorChooser(String translatedColorName, Color initialColor) {
        return this.createColorChooser("color", "GenericEditor.chooseColor", translatedColorName, initialColor);
    }

    public ColorChooserAction createColorChooser(String colorName, String translatedColorName, Color initialColor) {
        return this.createColorChooser(colorName, "GenericEditor.chooseColor", translatedColorName, initialColor);
    }

    public ColorChooserAction createColorChooser(String colorName, String promptMessage, String translatedColorName, Color initialColor) {
        ColorChooserAction colorChooserAction = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), colorName, AnimalTranslator.translateMessage(promptMessage, new Object[]{AnimalTranslator.translateMessage(translatedColorName)}), initialColor);
        return colorChooserAction;
    }

    public abstract String getBasicType();

    public void paintObject(Graphics g) {
        ((PTGraphicObject)this.getCurrentObject()).paint(g);
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        if (eo instanceof PTGraphicObject) {
            PTGraphicObject go = (PTGraphicObject)eo;
            go.setDepth(Integer.valueOf((String)this.depthBox.getSelectedItem()));
            go.setObjectName(this.objectNameField.getText());
        }
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        if (eo instanceof PTGraphicObject) {
            PTGraphicObject p = (PTGraphicObject)eo;
            if (p.getDepth() > 16 && p.getDepth() != Integer.MAX_VALUE) {
                this.depthBox.addItem(String.valueOf(p.getDepth()));
            }
            this.depthBox.addItem(String.valueOf(Integer.MAX_VALUE));
            this.depthBox.setSelectedItem(String.valueOf(p.getDepth()));
            this.objectNameField.setText(p.getObjectName());
        }
    }

    public String getStatusLineMsg() {
        return null;
    }
}

