/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.AbstractTextEditor;
import animal.graphics.PTGraph;
import animal.graphics.PTGraphicObject;
import animal.gui.DrawCanvas;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class GraphEditor
extends AbstractTextEditor
implements ChangeListener,
ActionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 4686563153442163179L;
    private ColorChooserAction colorChooser;
    private ColorChooserAction highlightColorChooser;
    private ColorChooserAction elemHighlightColorChooser;
    private ColorChooserAction outlineColorChooser;
    private ColorChooserAction fontColorNodeChooser;
    private ColorChooserAction fontColorEdgeChooser;
    private JTextField nodeSize;
    private JTextField contentNode;
    private JTextField contentEdge;
    private JTextField xNodePosition;
    private JTextField yNodePosition;
    private JSpinner nodeSpinner;
    private JSpinner edgeStartSpinner;
    private JSpinner edgeEndSpinner;
    private JSpinner nodePositionSpinner;
    private JComboBox fontChooserEdge;
    private JComboBox fontSizeEdge;
    private JCheckBox weighted;
    private JCheckBox directed;
    private JCheckBox showIndices;
    private JCheckBox edgeBold;
    private JCheckBox edgeItalic;
    public static final String BG_COLOR = "bgColorLabel";
    public static final String HIGHLIGHT_COLOR = "AbstractIndexedStructureEditor.hlColorLabel";
    public static final String ELEM_HIGHLIGHT_COLOR = "AbstractIndexedStructureEditor.elemHighlightColorLabel";
    public static final String OUTLINE_COLOR = "outlineColorLabel";
    public static final String FONT_COLOR_NODE = "fontColorLabelNode";
    public static final String FONT_COLOR_EDGE = "fontColorLabelEdge";
    public static final String SIZE = "size";
    public static final String GRAPH_CELL_NODE = "graphCellNode";
    public static final String GRAPH_CELL_EDGE_START = "graphCellEdgeStart";
    public static final String GRAPH_CELL_EDGE_END = "graphCellEdgeEnd";
    public static final String GRAPH_CONTENTS = "graphContents";
    public static final String GRAPH_COLORS = "graphColors";
    public static final String GRAPH_OPTIONS = "options";
    public static final String CONTENT_NODE = "cellContentNode";
    public static final String CONTENT_EDGE = "cellContentEdge";
    public static final String FONT_LABEL_NODE = "fontLabelNode";
    public static final String FONT_LABEL_EDGE = "fontLabelEdge";
    public static final String FONT = "font";
    public static final String FONT_SIZE_NODE = "fontSizeLabelNode";
    public static final String FONT_SIZE_EDGE = "fontSizeLabelEdge";
    public static final String WEIGHT_LABEL = "weight";
    public static final String DIRECTION_LABEL = "direction";
    public static final String SHOW_INDICES_LABEL = "AbstractIndexedStructureEditor.showIndices";
    public static final String POSITION_NODE_LABEL = "positionNodeLabel";
    public static final String X_POSITION_NODE_LABEL = "xPositionNodeLabel";
    public static final String Y_POSITION_NODE_LABEL = "yPositionNodeLabel";
    public static final String POSITION_LABEL = "positionLabel";

    public GraphEditor() {
    }

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createGraphSizeBox(generator));
        this.addBox(this.createOptionsBox(generator));
        this.addBox(this.createColorBox(generator));
        this.addBox(this.generateFontAndStyleBox(generator, "fontNodeBL"));
        this.addBox(this.generateEdgeFontAndStyleBox(generator, "fontEdgeBL"));
        this.finishBoxes();
    }

    private GraphEditor(int i) {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createGraphSizeBox(generator));
        this.addBox(this.createNodePositionBox(generator, i));
        this.addBox(this.createPositionsBox(generator, i));
        this.addBox(this.createOptionsBox(generator));
        this.addBox(this.createColorBox(generator));
        this.addBox(this.generateFontAndStyleBox(generator, "fontNodeBL"));
        this.addBox(this.generateEdgeFontAndStyleBox(generator, "fontEdgeBL"));
        this.finishBoxes();
    }

    protected Box createNodePositionBox(TranslatableGUIElement generator, int graphSize) {
        Box contentBox = generator.generateBorderedBox(2, "nodePosBL");
        contentBox.add(generator.generateJLabel(POSITION_NODE_LABEL));
        SpinnerNumberModel spinnerModelPositionNode = new SpinnerNumberModel(0, 0, graphSize - 1, 1);
        this.nodePositionSpinner = new JSpinner(spinnerModelPositionNode);
        contentBox.add(this.nodePositionSpinner);
        this.nodePositionSpinner.addChangeListener(this);
        contentBox.add(new JLabel(" of " + String.valueOf(graphSize)));
        contentBox.add(generator.generateJLabel(X_POSITION_NODE_LABEL));
        String textNodePositionX = this.getCurrentObject(false) == null ? "" : String.valueOf(((PTGraph)this.getCurrentObject(false)).getXNode(spinnerModelPositionNode.getNumber().intValue()));
        this.xNodePosition = new JTextField(15);
        this.xNodePosition.setText(textNodePositionX);
        this.xNodePosition.addKeyListener(this);
        contentBox.add(this.xNodePosition);
        contentBox.add(generator.generateJLabel(Y_POSITION_NODE_LABEL));
        String textNodePositionY = this.getCurrentObject(false) == null ? "" : String.valueOf(((PTGraph)this.getCurrentObject(false)).getYNode(spinnerModelPositionNode.getNumber().intValue()));
        this.yNodePosition = new JTextField(15);
        this.yNodePosition.setText(textNodePositionY);
        this.yNodePosition.addKeyListener(this);
        contentBox.add(this.yNodePosition);
        return contentBox;
    }

    protected Box createPositionsBox(TranslatableGUIElement generator, int graphSize) {
        Box contentBox = generator.generateBorderedBox(3, "graphPosBL");
        Box lineBox = new Box(2);
        lineBox.add(generator.generateJLabel(GRAPH_CELL_NODE));
        SpinnerNumberModel spinnerModelNode = new SpinnerNumberModel(0, 0, graphSize - 1, 1);
        this.nodeSpinner = new JSpinner(spinnerModelNode);
        lineBox.add(this.nodeSpinner);
        this.nodeSpinner.addChangeListener(this);
        lineBox.add(new JLabel(" of " + String.valueOf(graphSize)));
        lineBox.add(generator.generateJLabel(CONTENT_NODE));
        String textNode = this.getCurrentObject(false) == null ? "" : ((PTGraph)this.getCurrentObject(false)).getValueNode(spinnerModelNode.getNumber().intValue());
        this.contentNode = new JTextField(15);
        this.contentNode.setText(textNode);
        this.contentNode.addKeyListener(this);
        lineBox.add(this.contentNode);
        contentBox.add(lineBox);
        Box thirdLineBox = new Box(2);
        thirdLineBox.add(generator.generateJLabel(GRAPH_CELL_EDGE_START));
        SpinnerNumberModel spinnerModelEdgeStart = new SpinnerNumberModel(0, 0, graphSize - 1, 1);
        this.edgeStartSpinner = new JSpinner(spinnerModelEdgeStart);
        thirdLineBox.add(this.edgeStartSpinner);
        this.edgeStartSpinner.addChangeListener(this);
        thirdLineBox.add(new JLabel(" of " + String.valueOf(graphSize)));
        thirdLineBox.add(generator.generateJLabel(GRAPH_CELL_EDGE_END));
        SpinnerNumberModel spinnerModelEdgeEnd = new SpinnerNumberModel(0, 0, graphSize - 1, 1);
        this.edgeEndSpinner = new JSpinner(spinnerModelEdgeEnd);
        thirdLineBox.add(this.edgeEndSpinner);
        this.edgeEndSpinner.addChangeListener(this);
        thirdLineBox.add(new JLabel(" of " + String.valueOf(graphSize)));
        thirdLineBox.add(generator.generateJLabel(CONTENT_EDGE));
        String textEdge = this.getCurrentObject(false) == null ? "" : ((PTGraph)this.getCurrentObject(false)).getValueEdge(spinnerModelEdgeStart.getNumber().intValue(), spinnerModelEdgeEnd.getNumber().intValue());
        this.contentEdge = new JTextField(15);
        this.contentEdge.setText(textEdge);
        this.contentEdge.addKeyListener(this);
        thirdLineBox.add(this.contentEdge);
        contentBox.add(thirdLineBox);
        return contentBox;
    }

    public Box generateEdgeFontAndStyleBox(TranslatableGUIElement generator, String borderKey) {
        Box fontBox = generator.generateBorderedBox(3, borderKey);
        Box fontNameBox = new Box(2);
        fontNameBox.add(generator.generateJLabel("GenericEditor.nameLabel"));
        String[] fonts = Animal.GLOBAL_FONTS;
        this.fontChooserEdge = new JComboBox();
        int j = 0;
        while (j < fonts.length) {
            this.fontChooserEdge.addItem(fonts[j]);
            ++j;
        }
        this.fontChooserEdge.addActionListener(this);
        fontNameBox.add(this.fontChooserEdge);
        fontBox.add(fontNameBox);
        Box fontSizeBox = new Box(2);
        fontSizeBox.add(generator.generateJLabel("AbstractTextEditor.fontSizeLabel"));
        this.fontSizeEdge = new JComboBox();
        this.fontSizeEdge.setEditable(true);
        this.fontSizeEdge.addItem("8");
        this.fontSizeEdge.addItem("10");
        this.fontSizeEdge.addItem("12");
        this.fontSizeEdge.addItem("14");
        this.fontSizeEdge.addItem("16");
        this.fontSizeEdge.addItem("24");
        this.fontSizeEdge.setSelectedItem("12");
        this.fontSizeEdge.addActionListener(this);
        fontSizeBox.add(this.fontSizeEdge);
        fontBox.add(fontSizeBox);
        Box fontTypeBox = new Box(2);
        fontTypeBox.add(generator.generateJLabel("AbstractTextEditor.fontStyleLabel"));
        this.edgeItalic = generator.generateJCheckBox("italic", null, this);
        this.edgeItalic.setHorizontalAlignment(0);
        fontTypeBox.add(this.edgeItalic);
        this.edgeBold = generator.generateJCheckBox("bold", null, this);
        this.edgeBold.setHorizontalAlignment(0);
        fontTypeBox.add(this.edgeBold);
        fontBox.add(fontTypeBox);
        return fontBox;
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Graph.bgColor", Color.WHITE));
        this.highlightColorChooser.setColor(props.getColorProperty("Graph.highlightColor", Color.YELLOW));
        this.elemHighlightColorChooser.setColor(props.getColorProperty("Graph.elemHighlightColor", Color.RED));
        this.outlineColorChooser.setColor(props.getColorProperty("Graph.outlineColor", Color.BLACK));
        this.fontColorNodeChooser.setColor(props.getColorProperty("Graph.nodeFontColor", Color.BLACK));
        this.fontColorEdgeChooser.setColor(props.getColorProperty("Graph.edgeFontColor", Color.BLACK));
        this.nodeSize.setText(String.valueOf(props.getIntProperty("Graph.graphSize", 1)));
        this.fontName.setSelectedItem(props.getProperty("Graph.nodeFontName", "Monospaced"));
        this.fontSize.setSelectedItem(props.getProperty("Graph.nodeFontSize", "14"));
        int fontStyle = props.getIntProperty("Graph.nodeFontStyle", 0);
        this.italic.setSelected((fontStyle & 2) == 2);
        this.bold.setSelected((fontStyle & 1) == 1);
        this.fontChooserEdge.setSelectedItem(props.getProperty("Graph.edgeFontName", "Monospaced"));
        this.fontSizeEdge.setSelectedItem(props.getProperty("Graph.edgeFontSize", "14"));
        fontStyle = props.getIntProperty("Graph.edgeFontStyle", 0);
        this.edgeItalic.setSelected((fontStyle & 2) == 2);
        this.edgeBold.setSelected((fontStyle & 1) == 1);
        this.weighted.setSelected(props.getBoolProperty("Graph.weighted", true));
        this.directed.setSelected(props.getBoolProperty("Graph.directed", true));
        this.showIndices.setSelected(props.getBoolProperty("Graph.showIndices", false));
    }

    private Box createColorBox(TranslatableGUIElement generator) {
        Box colorBox = generator.generateBorderedBox(2, "GenericEditor.colorBL");
        Box firstColumnBox = new Box(3);
        firstColumnBox.add(generator.generateJLabel(OUTLINE_COLOR));
        Color outlineInitialColor = this.getCurrentObject(false) == null ? Color.black : ((PTGraph)this.getCurrentObject(false)).getOutlineColor();
        this.outlineColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(outlineInitialColor), "outlineColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"Graph"}), outlineInitialColor);
        firstColumnBox.add(new ExtendedActionButton(this.outlineColorChooser, 79));
        firstColumnBox.add(generator.generateJLabel(FONT_COLOR_NODE));
        Color fontInitialColorNode = this.getCurrentObject(false) == null ? Color.black : ((PTGraph)this.getCurrentObject(false)).getNodeFontColor();
        this.fontColorNodeChooser = new ColorChooserAction(this, ColorChoice.getColorName(outlineInitialColor), "fontColorNodeChooser", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"Graph"}), fontInitialColorNode);
        firstColumnBox.add(new ExtendedActionButton(this.fontColorNodeChooser, 70));
        firstColumnBox.add(generator.generateJLabel(FONT_COLOR_EDGE));
        Color fontInitialColorEdge = this.getCurrentObject(false) == null ? Color.black : ((PTGraph)this.getCurrentObject(false)).getEdgeFontColor();
        this.fontColorEdgeChooser = new ColorChooserAction(this, ColorChoice.getColorName(outlineInitialColor), "fontColorEdge", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"Graph"}), fontInitialColorEdge);
        firstColumnBox.add(new ExtendedActionButton(this.fontColorEdgeChooser, 71));
        colorBox.add(firstColumnBox);
        Box secondColumnBox = new Box(3);
        secondColumnBox.add(generator.generateJLabel(BG_COLOR));
        Color initialColor = this.getCurrentObject(false) == null ? Color.white : ((PTGraph)this.getCurrentObject(false)).getBGColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "bgColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"Graph"}), initialColor);
        secondColumnBox.add(new ExtendedActionButton(this.colorChooser, 67));
        secondColumnBox.add(generator.generateJLabel(HIGHLIGHT_COLOR));
        Color highlightInitialColor = this.getCurrentObject(false) == null ? Color.yellow : ((PTGraph)this.getCurrentObject(false)).getHighlightColor();
        this.highlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(highlightInitialColor), "highlightColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"Graph"}), highlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.highlightColorChooser, 72));
        secondColumnBox.add(generator.generateJLabel(ELEM_HIGHLIGHT_COLOR));
        Color elemHighlightInitialColor = this.getCurrentObject(false) == null ? Color.red : ((PTGraph)this.getCurrentObject(false)).getElemHighlightColor();
        this.elemHighlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(elemHighlightInitialColor), "elemHighlightColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"Graph"}), elemHighlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.elemHighlightColorChooser, 69));
        colorBox.add(secondColumnBox);
        return colorBox;
    }

    private Box createGraphSizeBox(TranslatableGUIElement generator) {
        Box sizeBox = generator.generateBorderedBox(3, "graphSizeBL");
        Box internalBox = new Box(2);
        internalBox.add(generator.generateJLabel("graphSize"));
        this.nodeSize = new JTextField(8);
        this.nodeSize.addActionListener(this);
        internalBox.add(this.nodeSize);
        sizeBox.add(internalBox);
        return sizeBox;
    }

    private Box createOptionsBox(TranslatableGUIElement generator) {
        Box optionsBox = generator.generateBorderedBox(3, "graphOptionsBL");
        this.weighted = generator.generateJCheckBox(WEIGHT_LABEL, null, this);
        optionsBox.add(this.weighted);
        this.directed = generator.generateJCheckBox(DIRECTION_LABEL, null, this);
        optionsBox.add(this.directed);
        this.showIndices = generator.generateJCheckBox(SHOW_INDICES_LABEL, null, this);
        optionsBox.add(this.showIndices);
        return optionsBox;
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("Graph.bgColor", this.colorChooser.getColor());
        props.put("Graph.highlightColor", this.highlightColorChooser.getColor());
        props.put("Graph.elemHighlightColor", this.elemHighlightColorChooser.getColor());
        props.put("Graph.outlineColor", this.outlineColorChooser.getColor());
        props.put("Graph.nodeFontColor", this.fontColorNodeChooser.getColor());
        props.put("Graph.edgeFontColor", this.fontColorEdgeChooser.getColor());
        props.put("Graph.graphSize", this.getInt(this.nodeSize.getText(), 1));
        props.put((Object)"Graph.nodeFontName", this.fontName.getSelectedItem());
        props.put((Object)"Graph.edgeFontName", this.fontChooserEdge.getSelectedItem());
        props.put((Object)"Graph.nodeFontSize", this.fontSize.getSelectedItem());
        props.put((Object)"Graph.edgeFontSize", this.fontSizeEdge.getSelectedItem());
        props.put("Graph.nodeFont", new Font((String)this.fontName.getSelectedItem(), 0, this.getInt((String)this.fontSize.getSelectedItem(), 14)));
        props.put("Graph.edgeFont", new Font((String)this.fontChooserEdge.getSelectedItem(), 0, this.getInt((String)this.fontSizeEdge.getSelectedItem(), 14)));
        props.put("Graph.weighted", this.weighted.isSelected());
        props.put("Graph.directed", this.directed.isSelected());
        props.put("Graph.showIndices", this.showIndices.isSelected());
    }

    @Override
    public int pointsNeeded() {
        return 1;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        switch (num) {
            case 1: 
            case 2: {
                ((PTGraph)this.getCurrentObject()).setOrigin(p);
            }
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(p, go.getBoundingBox());
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        Rectangle bBox = ((PTGraph)go).getBoundingBox();
        return new EditPoint[]{new EditPoint(-1, new Point(bBox.x, bBox.y)), new EditPoint(-2, new Point(bBox.x + bBox.width, bBox.y)), new EditPoint(-3, new Point(bBox.x, bBox.y + bBox.height)), new EditPoint(-4, new Point(bBox.x + bBox.width, bBox.y + bBox.height)), new EditPoint(-5, new Point(bBox.x + bBox.width / 2, bBox.y + bBox.height / 2))};
    }

    @Override
    public EditableObject createObject() {
        PTGraph result = new PTGraph(this.getInt(this.nodeSize.getText(), 1));
        this.storeAttributesInto(result);
        return result;
    }

    @Override
    public Editor getSecondaryEditor(EditableObject e) {
        GraphEditor result = new GraphEditor(((PTGraph)e).getLength());
        result.extractAttributesFrom(e);
        return result;
    }

    @Override
    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTGraph Graph2 = (PTGraph)eo;
        Graph2.setBGColor(this.colorChooser.getColor());
        Graph2.setHighlightColor(this.highlightColorChooser.getColor());
        Graph2.setElemHighlightColor(this.elemHighlightColorChooser.getColor());
        Graph2.setOutlineColor(this.outlineColorChooser.getColor());
        Graph2.setNodeFontColor(this.fontColorNodeChooser.getColor());
        Graph2.setEdgeFontColor(this.fontColorEdgeChooser.getColor());
        if (this.nodeSize != null) {
            Graph2.setSize(this.getInt(this.nodeSize.getText(), 1));
        }
        Graph2.enterValueNode(this.calcIndexNode(), this.getContentNode());
        Graph2.enterValueEdge(this.calcIndexEdgeStart(), this.calcIndexEdgeEnd(), this.getContentEdge());
        Graph2.setNodeFont(this.storeFontNode());
        Graph2.setEdgeFont(this.storeFontEdge());
        Graph2.setWeight(this.weighted.isSelected());
        Graph2.setDirection(this.directed.isSelected());
        Graph2.setIndices(this.showIndices.isSelected());
    }

    private String getContentNode() {
        return this.contentNode == null ? "" : this.contentNode.getText();
    }

    private String getContentEdge() {
        return this.contentEdge == null ? "" : this.contentEdge.getText();
    }

    private int getContentXNodePosition() {
        return this.xNodePosition == null ? 0 : Integer.parseInt(this.xNodePosition.getText());
    }

    private int getContentYNodePosition() {
        return this.yNodePosition == null ? 0 : Integer.parseInt(this.yNodePosition.getText());
    }

    Font storeFontNode() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        int fontStyle = 0;
        if (this.italic.isSelected()) {
            fontStyle |= 2;
        }
        if (this.bold.isSelected()) {
            fontStyle |= 1;
        }
        return new Font(name, fontStyle, this.getInt(size, 12));
    }

    Font storeFontEdge() {
        String name = (String)this.fontChooserEdge.getSelectedItem();
        String size = (String)this.fontSizeEdge.getSelectedItem();
        int fontStyle = 0;
        if (this.edgeItalic.isSelected()) {
            fontStyle |= 2;
        }
        if (this.edgeBold.isSelected()) {
            fontStyle |= 1;
        }
        return new Font(name, fontStyle, this.getInt(size, 12));
    }

    void extractFontNode(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    void extractFontEdge(Font f) {
        this.fontChooserEdge.setSelectedItem(f.getName());
        this.fontSizeEdge.setSelectedItem(String.valueOf(f.getSize()));
        this.edgeItalic.setSelected(f.isItalic());
        this.edgeBold.setSelected(f.isBold());
    }

    private int calcIndexNode() {
        return this.nodeSpinner == null ? -1 : ((SpinnerNumberModel)this.nodeSpinner.getModel()).getNumber().intValue();
    }

    private int calcIndexEdgeStart() {
        return this.edgeStartSpinner == null ? -1 : ((SpinnerNumberModel)this.edgeStartSpinner.getModel()).getNumber().intValue();
    }

    private int calcIndexEdgeEnd() {
        return this.edgeEndSpinner == null ? -1 : ((SpinnerNumberModel)this.edgeEndSpinner.getModel()).getNumber().intValue();
    }

    private int calcIndexNodePosition() {
        return this.nodePositionSpinner == null ? 0 : ((SpinnerNumberModel)this.nodePositionSpinner.getModel()).getNumber().intValue();
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTGraph graph = (PTGraph)eo;
        this.colorChooser.setColor(graph.getBGColor());
        this.highlightColorChooser.setColor(graph.getHighlightColor());
        this.elemHighlightColorChooser.setColor(graph.getElemHighlightColor());
        this.outlineColorChooser.setColor(graph.getOutlineColor());
        this.fontColorNodeChooser.setColor(graph.getNodeFontColor());
        this.fontColorEdgeChooser.setColor(graph.getEdgeFontColor());
        if (this.nodeSize != null) {
            this.nodeSize.setText(String.valueOf(graph.getSize()));
        }
        this.contentNode.setText(graph.getValueNode(this.calcIndexNode()));
        this.contentEdge.setText(graph.getValueEdge(this.calcIndexEdgeStart(), this.calcIndexEdgeEnd()));
        this.xNodePosition.setText(String.valueOf(graph.getXNode(this.calcIndexNodePosition())));
        this.yNodePosition.setText(String.valueOf(graph.getYNode(this.calcIndexNodePosition())));
        this.extractFontNode(graph.getNodeFont());
        this.extractFontEdge(graph.getEdgeFont());
        this.weighted.setSelected(graph.hasWeight());
        this.directed.setSelected(graph.hasDirection());
        this.showIndices.setSelected(graph.indicesShown());
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("GraphEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTGraph Graph2 = (PTGraph)this.getCurrentObject();
        if (e.getSource() == this.contentNode) {
            Graph2.enterValueNode(this.calcIndexNode(), this.contentNode.getText());
        }
        if (e.getSource() == this.contentEdge) {
            Graph2.enterValueEdge(this.calcIndexEdgeStart(), this.calcIndexEdgeEnd(), this.contentEdge.getText());
        }
        if (e.getSource() == this.nodeSize) {
            Graph2.setSize(this.getInt(this.nodeSize.getText(), 1));
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontName) {
            Graph2.setNodeFont(this.storeFontNode());
        }
        if (e.getSource() == this.fontChooserEdge || e.getSource() == this.fontSizeEdge) {
            Graph2.setEdgeFont(this.storeFontEdge());
        }
        if (e.getSource() == this.weighted) {
            Graph2.setWeight(this.weighted.isSelected());
        }
        if (e.getSource() == this.directed) {
            Graph2.setDirection(this.directed.isSelected());
        }
        if (e.getSource() == this.showIndices) {
            Graph2.setIndices(this.showIndices.isSelected());
        }
        if (e.getSource() == this.xNodePosition || e.getSource() == this.yNodePosition) {
            Graph2.setPositionNode(this.calcIndexNodePosition(), this.getContentXNodePosition(), this.getContentYNodePosition());
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        PTGraph Graph2 = (PTGraph)this.getCurrentObject();
        if (e.getSource() == this.contentNode) {
            Graph2.enterValueNode(this.calcIndexNode(), this.contentNode.getText());
        }
        if (e.getSource() == this.contentEdge) {
            Graph2.enterValueEdge(this.calcIndexEdgeStart(), this.calcIndexEdgeEnd(), this.contentEdge.getText());
        }
        if (e.getSource() == this.xNodePosition || e.getSource() == this.yNodePosition) {
            Graph2.setPositionNode(this.calcIndexNodePosition(), this.getContentXNodePosition(), this.getContentYNodePosition());
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        PTGraph Graph2 = (PTGraph)this.getCurrentObject();
        if (e.getSource() == this.contentNode) {
            Graph2.enterValueNode(this.calcIndexNode(), this.contentNode.getText());
        }
        if (e.getSource() == this.contentEdge) {
            Graph2.enterValueEdge(this.calcIndexEdgeStart(), this.calcIndexEdgeEnd(), this.contentEdge.getText());
        }
        if (e.getSource() == this.xNodePosition || e.getSource() == this.yNodePosition) {
            Graph2.setPositionNode(this.calcIndexNodePosition(), this.getContentXNodePosition(), this.getContentYNodePosition());
        }
        this.repaintNow();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PTGraph Graph2 = (PTGraph)this.getCurrentObject();
        if (e.getSource() == this.nodeSpinner) {
            this.contentNode.setText(Graph2.getValueNode(this.calcIndexNode()));
        }
        if (e.getSource() == this.edgeStartSpinner || e.getSource() == this.edgeEndSpinner) {
            this.contentEdge.setText(Graph2.getValueEdge(this.calcIndexEdgeStart(), this.calcIndexEdgeEnd()));
        }
        if (e.getSource() == this.nodePositionSpinner) {
            this.xNodePosition.setText(String.valueOf(Graph2.getXNode(this.calcIndexNodePosition())));
            this.yNodePosition.setText(String.valueOf(Graph2.getYNode(this.calcIndexNodePosition())));
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTGraph Graph2 = (PTGraph)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("bgColor")) {
            Graph2.setBGColor((Color)event.getNewValue());
        }
        if (eventName.equals("highlightColor")) {
            Graph2.setHighlightColor((Color)event.getNewValue());
        }
        if (eventName.equals("elemHighlightColor")) {
            Graph2.setElemHighlightColor((Color)event.getNewValue());
        }
        if (eventName.equals("outlineColor")) {
            Graph2.setOutlineColor((Color)event.getNewValue());
        }
        if (eventName.equals("fontColorNode")) {
            Graph2.setNodeFontColor((Color)event.getNewValue());
        }
        if (eventName.equals("fontColorEdge")) {
            Graph2.setEdgeFontColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            Animation.get().doChange();
        }
    }

    @Override
    public String getBasicType() {
        return "Graph";
    }
}

