/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.OrientedArcBasedShapeEditor;
import animal.graphics.PTClosedCircleSegment;
import animal.graphics.PTGraphicObject;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class ClosedCircleSegmentEditor
extends OrientedArcBasedShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonClosedArcElements(generator);
        Box addOnBox = new Box(2);
        this.filledCB = generator.generateJCheckBox("GenericEditor.filled", null, this);
        this.filledCB.addItemListener(this);
        addOnBox.add(this.filledCB);
        this.clockwise = generator.generateJCheckBox("ArcBasedShapeEditor.clockwise", null, this);
        this.clockwise.addItemListener(this);
        addOnBox.add(this.clockwise);
        contentBox.add(addOnBox);
        this.finishBoxes();
    }

    @Override
    public int pointsNeeded() {
        return 4;
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTClosedCircleSegment shape = (PTClosedCircleSegment)this.getCurrentObject();
        switch (num) {
            case 1: {
                shape.setCenter(p.x, p.y);
                break;
            }
            case 2: {
                shape.setRadius(p.x - shape.getCenter().x);
                break;
            }
            case 3: {
                shape.setStartAngle(shape.getAngle(p));
                break;
            }
            case 4: {
                int angle = shape.getAngle(p) - shape.getStartAngle();
                if (angle <= 0) {
                    angle += 360;
                }
                shape.setTotalAngle(angle);
                shape.setFilled(this.filledCB.isSelected());
            }
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        PTClosedCircleSegment pg = (PTClosedCircleSegment)go;
        Point a = new Point(pg.getCenter().x, pg.getCenter().y);
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        Point b = new Point(a.x + pg.getRadius(), a.y);
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        b.translate(0, pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        a.translate(pg.getRadius(), pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, a, pg.getCenter())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTClosedCircleSegment pg = (PTClosedCircleSegment)go;
        int radius = pg.getRadius();
        EditPoint[] result = new EditPoint[7];
        Point helper = pg.getCenter();
        int nr = 0;
        result[nr++] = new EditPoint(2, new Point(helper.x + radius, helper.y + radius));
        result[nr++] = new EditPoint(3, pg.getPointAtLength(pg.getStartAngle()));
        result[nr++] = new EditPoint(4, pg.getPointAtLength(pg.getStartAngle() + pg.getTotalAngle()));
        int x = helper.x;
        int y = helper.y;
        result[nr++] = new EditPoint(-1, new Point(x - radius, y));
        result[nr++] = new EditPoint(-2, new Point(x, y + radius));
        result[nr++] = new EditPoint(-3, new Point(x + radius, y));
        result[nr++] = new EditPoint(-4, new Point(x, y - radius));
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("ClosedCircleSegment.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("ClosedCircleSegment.depth", "16"));
        this.fillColorChooser.setColor(props.getColorProperty("ClosedCircleSegment.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("ClosedCircleSegment.filled"));
    }

    @Override
    public void getProperties(XProperties props) {
        props.put("ClosedCircleSegment.color", this.colorChooser.getColor());
        props.put((Object)"ClosedCircleSegment.depth", this.depthBox.getSelectedItem());
        props.put("ClosedCircleSegment.fillColor", this.fillColorChooser.getColor());
        props.put("ClosedCircleSegment.filled", this.filledCB.isSelected());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        PTClosedCircleSegment p = (PTClosedCircleSegment)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        if (e.getSource() == this.clockwise) {
            p.setClockwise(this.clockwise.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    @Override
    public EditableObject createObject() {
        PTClosedCircleSegment pg = new PTClosedCircleSegment();
        this.storeAttributesInto(pg);
        return pg;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTClosedCircleSegment p = (PTClosedCircleSegment)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setFillColor(this.fillColorChooser.getColor());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTClosedCircleSegment p = (PTClosedCircleSegment)eo;
        this.colorChooser.setColor(p.getColor());
        this.filledCB.setEnabled(true);
        this.filledCB.setSelected(p.isFilled());
        this.fillColorChooser.setColor(p.getFillColor());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject go) {
        ClosedCircleSegmentEditor result = new ClosedCircleSegmentEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("ClosedCircleSegmentEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTClosedCircleSegment p = (PTClosedCircleSegment)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTClosedCircleSegment poly = (PTClosedCircleSegment)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        } else if ("fillColor".equals(eventName)) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "ClosedCircleSegment";
    }
}

