/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.AbstractTextEditor;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTRectangle;
import animal.graphics.PTText;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComboBox;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class BoxPointerEditor
extends AbstractTextEditor
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -5358323736501168554L;
    private ColorChooserAction textBoxAndPointerColorChooser;
    private ColorChooserAction textBoxFillColorChooser;
    private ColorChooserAction pointerAreaColorChooser;
    private ColorChooserAction pointerAreaFillColorChooser;
    private JComboBox pointerCount;
    private JComboBox pointerPosition;
    private boolean isItalic;
    private boolean isBold;
    private AbstractButton nullPointerButton;

    @Override
    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.installPointerBox(generator));
        this.addBox(this.installColorSettingsBox(generator));
        this.addBox(this.generateTextComponentBox(generator));
        this.finishBoxes();
    }

    private Box installPointerBox(TranslatableGUIElement generator) {
        Box pointerPosBox = generator.generateBorderedBox(3, "BoxPointerEditor.ptrPosBL");
        Box firstRowBox = new Box(2);
        firstRowBox.add(generator.generateJLabel("BoxPointerEditor.pointerPositionLabel"));
        this.pointerPosition = new JComboBox();
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("BoxPointerEditor.positionNone"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("BoxPointerEditor.positionRight"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("BoxPointerEditor.positionLeft"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("BoxPointerEditor.positionTop"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("BoxPointerEditor.positionBottom"));
        this.pointerPosition.addActionListener(this);
        firstRowBox.add(this.pointerPosition);
        pointerPosBox.add(firstRowBox);
        Box secondRowBox = new Box(2);
        secondRowBox.add(generator.generateJLabel("BoxPointerEditor.pointerCountLabel"));
        this.pointerCount = new JComboBox();
        int j = 0;
        while (j < 10) {
            this.pointerCount.addItem(String.valueOf(j));
            ++j;
        }
        this.pointerCount.addActionListener(this);
        secondRowBox.add(this.pointerCount);
        pointerPosBox.add(secondRowBox);
        Box thirdRowBox = new Box(2);
        this.nullPointerButton = generator.generateJButton("BoxPointerEditor.nullPtrButton", null, false, this);
        thirdRowBox.add(this.nullPointerButton);
        pointerPosBox.add(thirdRowBox);
        return pointerPosBox;
    }

    private Box installColorSettingsBox(TranslatableGUIElement generator) {
        Box colorsBox = generator.generateBorderedBox(0, "GenericEditor.colorBL");
        Box colorFillColorBox = generator.generateBorderedBox(3, "BoxPointerEditor.boxColBL");
        colorFillColorBox.add(generator.generateJLabel("GenericEditor.colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTBoxPointer)this.getCurrentObject()).getColor();
        this.textBoxAndPointerColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("BoxPointerEditor.boxPtrColor", new Object[]{"boxPtrColor"}), initialColor);
        colorFillColorBox.add(new ExtendedActionButton(this.textBoxAndPointerColorChooser, 67));
        colorFillColorBox.add(generator.generateJLabel("GenericEditor.fillColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTBoxPointer)this.getCurrentObject()).getTextBox().getFillColor();
        this.textBoxFillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "textBoxFillColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"textBoxFillColor"}), initialColor);
        colorFillColorBox.add(new ExtendedActionButton(this.textBoxFillColorChooser, 70));
        colorsBox.add(colorFillColorBox);
        Box ptrBoxFillColorBox = generator.generateBorderedBox(3, "BoxPointerEditor.ptrBoxBL");
        ptrBoxFillColorBox.add(generator.generateJLabel("BoxPointerEditor.pointerBoxColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTBoxPointer)this.getCurrentObject()).getPointerArea().getColor();
        this.pointerAreaColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "pointerAreaColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"pointerBoxColor"}), initialColor);
        ptrBoxFillColorBox.add(new ExtendedActionButton(this.pointerAreaColorChooser, 80));
        ptrBoxFillColorBox.add(generator.generateJLabel("GenericEditor.fillColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTBoxPointer)this.getCurrentObject()).getPointerArea().getFillColor();
        this.pointerAreaFillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "pointerAreaFillColor", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{"pointerAreaFillColor"}), initialColor);
        ptrBoxFillColorBox.add(new ExtendedActionButton(this.pointerAreaFillColorChooser, 70));
        colorsBox.add(ptrBoxFillColorBox);
        return colorsBox;
    }

    @Override
    public int pointsNeeded() {
        return 2 + ((PTBoxPointer)this.getCurrentObject()).getPointerCount();
    }

    @Override
    public boolean nextPoint(int num, Point p) {
        PTBoxPointer bp = (PTBoxPointer)this.getCurrentObject();
        switch (num) {
            case 1: 
            case 2: {
                bp.setPosition(p);
                break;
            }
            default: {
                bp.setTip(num - 3, p);
            }
        }
        return true;
    }

    @Override
    public int getMinDist(PTGraphicObject go, Point p) {
        PTBoxPointer bp = (PTBoxPointer)go;
        PTRectangle box = bp.getTextBox();
        PTRectangle pointerArea = bp.getPointerArea();
        if (box.toPolygon().contains(p)) {
            return 0;
        }
        if (pointerArea != null && pointerArea.toPolygon().contains(p)) {
            return 0;
        }
        int minDist = Integer.MAX_VALUE;
        boolean hasSafePointerArea = pointerArea != null && pointerArea.getNodeCount() > 3;
        minDist = hasSafePointerArea ? Math.min(MSMath.dist(p, box.getLocation(), box.getEndNode()), MSMath.dist(p, pointerArea.getLocation(), pointerArea.getEndNode())) : MSMath.dist(p, box.getLocation(), box.getEndNode());
        int i = 0;
        while (i < bp.getPointerCount()) {
            minDist = Math.min(minDist, MSMath.dist(p, bp.getPointerOrigin(i), bp.getTip(i)));
            ++i;
        }
        return minDist;
    }

    @Override
    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTBoxPointer bp = (PTBoxPointer)go;
        int count = bp.getPointerArea() != null ? bp.getPointerCount() : 0;
        EditPoint[] result = new EditPoint[1 + count];
        result[0] = new EditPoint(-1, bp.getOrigin());
        int i = 0;
        while (i < count) {
            result[i + 1] = new EditPoint(i + 3, bp.getTip(i));
            ++i;
        }
        return result;
    }

    @Override
    public void setProperties(XProperties props) {
        if (this.textField != null) {
            this.textField.setText(props.getProperty("BoxPointer.text"));
        }
        this.fontName.setSelectedItem(props.getProperty("BoxPointer.fontName", "SansSerif"));
        this.fontSize.setSelectedItem(props.getProperty("BoxPointer.fontSize", "12"));
        int fontStyle = props.getIntProperty("BoxPointer.fontStyle");
        this.italic.setSelected((fontStyle & 2) == 2);
        this.bold.setSelected((fontStyle & 1) == 1);
        this.pointerPosition.setSelectedItem(props.getProperty("BoxPointer.pointerPosition", "Right"));
        this.pointerCount.setSelectedItem(String.valueOf(props.getIntProperty("BoxPointer.nrPointers", 1)));
        this.textBoxAndPointerColorChooser.setColor(props.getColorProperty("BoxPointer.color", Color.black));
        this.textBoxFillColorChooser.setColor(props.getColorProperty("BoxPointer.fillColor", Color.white));
        this.pointerAreaColorChooser.setColor(props.getColorProperty("BoxPointer.pointerAreaColor", Color.white));
        this.pointerAreaFillColorChooser.setColor(props.getColorProperty("BoxPointer.pointerAreaFillColor", Color.white));
        this.textColorChooser.setColor(props.getColorProperty("BoxPointer.textColor", Color.black));
    }

    @Override
    public void getProperties(XProperties props) {
        int fontStyle;
        props.put("BoxPointer.color", this.textBoxAndPointerColorChooser.getColor());
        props.put("BoxPointer.fillColor", this.textBoxFillColorChooser.getColor());
        props.put("BoxPointer.pointerAreaColor", this.pointerAreaColorChooser.getColor());
        props.put("BoxPointer.pointerAreaFillColor", this.pointerAreaFillColorChooser.getColor());
        props.put("BoxPointer.textColor", this.textColorChooser.getColor());
        props.put("BoxPointer.text", this.textField.getText());
        props.put((Object)"BoxPointer.fontName", this.fontName.getSelectedItem());
        props.put((Object)"BoxPointer.fontSize", this.fontSize.getSelectedItem());
        int n = fontStyle = this.italic.isSelected() ? 2 : 0;
        if (this.bold.isSelected()) {
            fontStyle |= 1;
        }
        props.put("BoxPointer.fontStyle", fontStyle);
        props.put((Object)"BoxPointer.pointerPosition", this.pointerPosition.getSelectedItem());
        props.put((Object)"BoxPointer.nrPointers", this.pointerCount.getSelectedItem());
    }

    @Override
    public EditableObject createObject() {
        PTBoxPointer bp = new PTBoxPointer();
        bp.init();
        this.storeAttributesInto(bp);
        return bp;
    }

    @Override
    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTBoxPointer bp = (PTBoxPointer)eo;
        bp.setColor(this.textBoxAndPointerColorChooser.getColor());
        PTRectangle currentBox = bp.getTextBox();
        currentBox.setFillColor(this.textBoxFillColorChooser.getColor());
        currentBox = bp.getPointerArea();
        currentBox.setColor(this.pointerAreaColorChooser.getColor());
        currentBox.setFillColor(this.pointerAreaFillColorChooser.getColor());
        PTText text = bp.getTextComponent();
        text.setColor(this.textColorChooser.getColor());
        if (this.textField == null) {
            bp.setText("");
        } else {
            bp.setText(this.textField.getText());
        }
        bp.getTextComponent().setFont(this.storeFont());
        bp.setPointerPosition(this.pointerPosition.getSelectedIndex());
        try {
            bp.setPointerCount(Integer.parseInt((String)this.pointerCount.getSelectedItem()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        return new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    @Override
    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTBoxPointer bp = (PTBoxPointer)eo;
        this.textBoxAndPointerColorChooser.setColor(bp.getColor());
        this.textBoxFillColorChooser.setColor(bp.getTextBox().getFillColor());
        this.pointerAreaColorChooser.setColor(bp.getPointerArea().getColor());
        this.pointerAreaFillColorChooser.setColor(bp.getPointerArea().getFillColor());
        this.textColorChooser.setColor(bp.getTextComponent().getColor());
        this.textField.setText(bp.getTextComponent().getText());
        this.extractFont(bp.getTextComponent().getFont());
        this.pointerPosition.setSelectedIndex(bp.getPointerPosition());
        this.pointerCount.setSelectedItem(String.valueOf(bp.getPointerCount()));
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        BoxPointerEditor result = new BoxPointerEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    @Override
    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("BoxPointerEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Font newFont;
        String size;
        String name;
        super.actionPerformed(e);
        PTBoxPointer bp = (PTBoxPointer)this.getCurrentObject();
        this.isItalic = bp.getTextComponent().getFont().isItalic();
        this.isBold = bp.getTextComponent().getFont().isBold();
        if (e.getSource() == this.textField) {
            bp.setText(this.textField.getText());
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            bp.getTextComponent().setFont(this.storeFont());
        }
        if (e.getSource() == this.italic) {
            this.isItalic = !this.isItalic;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            bp.getTextComponent().setFont(newFont);
        }
        if (e.getSource() == this.bold) {
            this.isBold = !this.isBold;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            bp.getTextComponent().setFont(newFont);
        }
        if (e.getSource() == this.pointerPosition) {
            bp.setPointerPosition(this.pointerPosition.getSelectedIndex());
        }
        if (e.getSource() == this.pointerCount) {
            try {
                bp.setPointerCount(Integer.parseInt((String)this.pointerCount.getSelectedItem()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (e.getSource() == this.nullPointerButton) {
            bp.makeNullPointer();
        }
        bp.init();
        if (Animation.get() != null) {
            Animation.get().doChange();
        }
        this.repaintNow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PTBoxPointer bp = (PTBoxPointer)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            bp.setColor((Color)event.getNewValue());
        } else if ("textBoxFillColor".equals(eventName)) {
            bp.getTextBox().setFillColor((Color)event.getNewValue());
        } else if ("pointerAreaColor".equals(eventName)) {
            if (bp.getPointerArea() != null) {
                bp.getPointerArea().setColor((Color)event.getNewValue());
            }
        } else if ("pointerAreaFillColor".equals(eventName)) {
            if (bp.getPointerArea() != null) {
                bp.getPointerArea().setFillColor((Color)event.getNewValue());
            } else if ("textColor".equals(eventName)) {
                bp.getTextComponent().setColor((Color)event.getNewValue());
            }
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    @Override
    public String getBasicType() {
        return "BoxPointer";
    }
}

