/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.Show;
import animal.editor.Editor;
import animal.editor.animators.AnimatorEditor;
import animal.misc.EditableObject;
import animal.misc.XProperties;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class ShowEditor
extends AnimatorEditor {
    private static final long serialVersionUID = -8972332883991718878L;
    private JToggleButton showCB;
    private JToggleButton hideCB;

    @Override
    protected void buildGUI() {
        JPanel p = new JPanel();
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.showCB = generator.generateJToggleButton("ShowEditor.show", null, this, true);
        p.add(this.showCB);
        this.showCB.setSelected(true);
        this.hideCB = generator.generateJToggleButton("ShowEditor.hide", null, this, true);
        p.add(this.hideCB);
        this.hideCB.setSelected(false);
        ButtonGroup g = new ButtonGroup();
        g.add(this.showCB);
        g.add(this.hideCB);
        this.addLayer(p);
        this.finish();
    }

    @Override
    public void setProperties(XProperties props) {
    }

    @Override
    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        this.setShow(((Show)eo).isShow());
    }

    @Override
    public void storeAttributesInto(EditableObject show) {
        super.storeAttributesInto(show);
        ((Show)show).setShow(this.getShow());
    }

    @Override
    public Editor getSecondaryEditor(EditableObject eo) {
        ShowEditor result = new ShowEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    void setShow(boolean b) {
        this.hideCB.setSelected(!b);
        this.showCB.setSelected(b);
    }

    boolean getShow() {
        return this.showCB.isSelected();
    }

    @Override
    public EditableObject createObject() {
        Show s = new Show();
        this.storeAttributesInto(s);
        return s;
    }
}

