/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.Move;
import animal.animator.PutType;
import animal.animator.TimedAnimator;
import animal.graphics.PTArray;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTLine;
import animal.graphics.PTText;
import animal.gui.GraphicVector;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Font;
import java.awt.Point;
import translator.AnimalTranslator;

public class Put
extends TimedAnimator
implements GraphicObjectSpecificAnimation {
    public static final String TYPE_LABEL = "Put";
    private PTText newContent;
    private PTLine moveLine;
    private Move oldFlyUp = new Move();
    private Move newFlyUp = new Move();
    private int animObjNum;
    private int cell = -1;
    private Font finalFont = new Font("Monospaced", 0, 14);
    private transient GraphicVector graphicVector;

    public Put() {
    }

    public Put(XProperties props) {
        this.setProperties(props);
    }

    public Put(int step, int objectNum, int totalTimeOrTicks, int offset, int newVal, int idx) {
        super(step, objectNum, totalTimeOrTicks, offset, "put");
        this.initPut(offset, objectNum, idx, String.valueOf(newVal));
    }

    public Put(int step, int objectNum, int totalTimeOrTicks, int offset, String newVal, int idx) {
        super(step, objectNum, totalTimeOrTicks, offset, "put");
        this.initPut(offset, objectNum, idx, newVal);
    }

    private void initPut(int offset, int objectNum, int index, String newVal) {
        this.setOffset(offset);
        PTArray theArray = (PTArray)Animation.get().getGraphicObject(objectNum);
        this.animObjNum = objectNum;
        if (theArray == null) {
            return;
        }
        this.finalFont = theArray.getFont();
        this.newContent = new PTText(newVal, this.finalFont);
        this.newContent.setObjectSelectable(false);
        this.newContent.setColor(theArray.getFontColor());
        this.newContent.setDepth(theArray.getEntry(index).getDepth());
        this.cell = index;
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.graphicVector = animationState.getCurrentObjects();
        this.graphicVector.addElement(this.newContent, 1);
        this.newContent.setFont(new Font(this.finalFont.getName(), this.finalFont.getStyle(), 0));
        PTGraphicObject ao = animationState.getCloneByNum(this.getObjectNums()[0]);
        if (ao instanceof PTArray) {
            Point node = ((PTArray)ao).getEntry(this.cell).getLocation();
            this.moveLine.setLastNode(node);
            this.moveLine.setFirstNode(node.x, node.y + ((PTArray)ao).getBoundingBox((int)this.cell).height);
            this.newContent.setColor(((PTArray)ao).getFontColor());
            this.newContent.setDepth(((PTArray)ao).getEntry(this.cell).getDepth());
            this.newContent.setPosition(this.moveLine.getPointAtLength(0));
        }
        this.oldFlyUp.init(animationState, time, ticks);
        this.newFlyUp.init(animationState, time, ticks);
    }

    @Override
    public Object getProperty(double factor) {
        if (this.newContent == null) {
            return new PutType();
        }
        double realFactor = factor != 0.0 ? factor : 1.0E-4;
        this.newContent.setFont(new Font(this.finalFont.getName(), this.finalFont.getStyle(), (int)(realFactor * (double)this.finalFont.getSize())));
        this.newContent.setPosition((Point)this.newFlyUp.getProperty(realFactor));
        this.newContent.setLocation((Point)this.newFlyUp.getProperty(realFactor));
        this.newContent.setObjectSelectable(false);
        return new PutType(this.cell, (Point)this.oldFlyUp.getProperty(realFactor), this.newContent, (Point)this.newFlyUp.getProperty(realFactor), factor, this.hasFinished());
    }

    public String getContent() {
        return this.newContent == null ? "" : this.newContent.getText();
    }

    public void setContent(String val) {
        if (this.moveLine == null) {
            this.moveLine = new PTLine(0, 0, 0, 0);
            Animation.get().insertGraphicObject(this.moveLine);
            this.moveLine.setObjectSelectable(false);
        }
        if (this.newContent == null) {
            this.newContent = new PTText(val, this.finalFont);
            this.newContent.getNum(true);
            this.newContent.setObjectSelectable(false);
            Animation.get().insertGraphicObject(this.newContent);
        } else {
            this.newContent.setText(val);
            this.newContent.setFont(this.finalFont);
        }
        PTGraphicObject go = Animation.get().getGraphicObject(this.animObjNum);
        if (go instanceof PTArray) {
            this.newContent.setColor(((PTArray)go).getFontColor());
            this.newContent.setDepth(((PTArray)go).getEntry(this.cell).getDepth());
        }
        this.newFlyUp = new Move(this.getStep(), this.newContent.getNum(true), this.getDuration(), this.getMethod(), this.moveLine.getNum(true));
    }

    public void setArray(int num) {
        this.updateAnimation(this.animObjNum, num, this.cell, this.cell);
        this.animObjNum = num;
    }

    public void setCell(int index) {
        this.updateAnimation(this.animObjNum, this.animObjNum, this.cell, index);
        this.cell = index;
    }

    public void updateAnimation(int oldObject, int newObject, int oldIndex, int newIndex) {
        if (oldObject != newObject || oldIndex != newIndex) {
            if (this.moveLine == null) {
                this.moveLine = new PTLine(0, 0, 0, 0);
                Animation.get().insertGraphicObject(this.moveLine);
                this.moveLine.setObjectSelectable(false);
            }
            if (this.oldFlyUp == null || oldObject != newObject) {
                this.oldFlyUp = new Move(this.getStep(), newObject, this.getDuration(), this.getMethod(), this.moveLine.getNum(true));
            } else {
                this.oldFlyUp.setDuration(this.getDuration());
            }
        }
    }

    public int getCell() {
        return this.cell;
    }

    public int[] exportIDs() {
        return new int[]{this.newContent.getNum(true), this.moveLine.getNum(true)};
    }

    public void restoreIDs(int[] idList) {
        if (idList.length != 2) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("putIDListLengthWrong"), 4);
        } else {
            this.newContent = (PTText)Animation.get().getGraphicObject(idList[0]);
            this.newContent.setObjectSelectable(false);
            this.moveLine = (PTLine)Animation.get().getGraphicObject(idList[1]);
            this.moveLine.setObjectSelectable(false);
        }
    }

    @Override
    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    @Override
    public void discard() {
        PTArray go;
        if (Animation.get().getGraphicObjects().contains(this.newContent)) {
            Animation.get().deleteGraphicObject(this.newContent.getNum(true));
        }
        if ((go = (PTArray)Animation.get().getGraphicObject(this.animObjNum)) != null && Animation.get().getGraphicObjects().contains(go.getEntry(this.cell))) {
            Animation.get().deleteGraphicObject(go.getEntry(this.cell).getNum(true));
        }
        this.newContent.discard();
        this.moveLine.discard();
        this.finalFont = null;
        super.discard();
    }

    public void setFinalFont(Font font) {
        this.finalFont = new Font(font.getName(), font.getStyle(), font.getSize());
    }

    @Override
    public int[] getTemporaryObjects() {
        return new int[]{this.moveLine.getNum(true)};
    }

    @Override
    public String toString() {
        if (this.newContent == null) {
            return AnimalTranslator.translateMessage("putNoObjectsSet");
        }
        if (Animation.get().getGraphicObject(this.animObjNum) instanceof PTArray) {
            return "Replace '" + ((PTArray)Animation.get().getGraphicObject(this.animObjNum)).getEntry(this.cell).getText() + "' in cell " + this.cell + " of " + super.toString() + " by '" + this.newContent.getText() + "'";
        }
        return "Put '" + this.newContent.getText() + "' into " + super.toString();
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"StringArray", "IntArray"};
    }
}

