/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.main.Animal;
import avinteraction.InteractionModule;
import avinteraction.UnknownInteractionException;
import translator.AnimalTranslator;

public class InteractionElement
extends Animator {
    public static final int INTERACTION_DEFINITION = 1;
    public static final int INTERACTION_INVOCATION = 2;
    public static final String TYPE_LABEL = "InteractionElement";
    private static final long serialVersionUID = 4835863619518931027L;
    private String actionKey = null;
    private InteractionModule interactionHandler = null;
    private int interactionType = 2;
    public boolean used = false;

    public InteractionElement() {
    }

    public InteractionElement(int step, String key, InteractionModule module) {
        this(step, key, 2, module);
    }

    public InteractionElement(int step, String key, int mode, InteractionModule module) {
        super(step, new int[]{-1});
        this.actionKey = key;
        this.interactionType = mode;
        this.interactionHandler = module;
    }

    @Override
    public void action(long time, double ticks) {
        super.execute();
        if (this.interactionType != 1) {
            try {
                if (Animal.animationLoadFinished()) {
                    this.interactionHandler.interaction(this.actionKey);
                }
            }
            catch (UnknownInteractionException uie) {
                AnimalTranslator.translateMessage("unknownInteractionElement", new String[]{this.actionKey});
            }
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{"Interaction", TYPE_LABEL};
    }

    @Override
    public void discard() {
        super.discard();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("interaction");
        if (this.interactionType == 1) {
            sb.append("Definition");
        }
        sb.append(" \"").append(this.actionKey).append("\"");
        return sb.toString();
    }
}

