/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.TimedAnimator;
import animal.main.AnimationState;
import animal.misc.ColorChoice;
import animal.misc.XProperties;
import java.awt.Color;
import java.beans.PropertyChangeEvent;

public class ColorChanger
extends TimedAnimator {
    public static final String COLOR_LABEL = "color";
    public static final String TYPE_LABEL = "ColorChanger";
    private static final long serialVersionUID = 5575863619518931027L;
    private Color[] originalColor = null;

    public ColorChanger() {
    }

    public ColorChanger(int step, int objectNum, int totalTimeOrTicks, String method, Color color) {
        this(step, new int[]{objectNum}, totalTimeOrTicks, method, color);
    }

    public ColorChanger(int step, int objectNum, int totalTimeOrTicks, String method, Color color, Color initialColor) {
        this(step, new int[]{objectNum}, totalTimeOrTicks, method, color, initialColor);
    }

    public ColorChanger(int step, int[] objectNums, int totalTimeOrTicks, String method, Color color) {
        super(step, objectNums, totalTimeOrTicks, method);
        this.setColor(color);
    }

    public ColorChanger(int step, int[] objectNums, int totalTimeOrTicks, String method, Color color, Color initialColor) {
        super(step, objectNums, totalTimeOrTicks, method);
        this.setColor(color);
    }

    public ColorChanger(XProperties props) {
        this.setProperties(props);
    }

    @Override
    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        if (this.objects != null) {
            this.originalColor = new Color[this.objects.length];
            int i = 0;
            while (i < this.originalColor.length) {
                if (this.objects != null && this.objects.length > i && this.objects[i] != null) {
                    Color c;
                    XProperties props22 = this.objects[i].getProperties();
                    String key = String.valueOf(this.objects[i].getType()) + "." + this.getMethod();
                    this.originalColor[i] = c = props22.getColorProperty(key, Color.BLACK);
                }
                ++i;
            }
        }
    }

    @Override
    public void action(long time, double ticks) {
        int totalTimeOrTicks = this.getDuration();
        if (this.hasFinished()) {
            return;
        }
        double elapsed = (this.isUnitIsTicks() ? ticks : (double)time) - (double)this.getStartTimeOrTicks() - (double)this.getOffset();
        double factor = elapsed / (double)totalTimeOrTicks;
        if (totalTimeOrTicks == 0 && elapsed >= 0.0 || factor >= 1.0) {
            this.execute();
        } else {
            if (factor < 0.0) {
                return;
            }
            Color newProperty = null;
            String methodName = this.getMethod();
            Color targetColor = this.getColor();
            int a = 0;
            while (a < this.objects.length) {
                Color origColor = null;
                origColor = this.originalColor != null && a < this.originalColor.length && this.originalColor[a] != null ? this.originalColor[a] : (this.objects != null && this.objects.length > a && this.objects[a] != null ? this.objects[a].getProperties().getColorProperty(methodName, Color.black) : Color.BLACK);
                newProperty = this.interpolateColor(origColor, targetColor, factor);
                this.objects[a].propertyChange(new PropertyChangeEvent(this, this.getMethod(), this.oldProperty, newProperty));
                this.oldProperty = newProperty;
                ++a;
            }
        }
    }

    private Color interpolateColor(Color originalColor, Color targetColor, double factor) {
        double redValue = factor * (double)targetColor.getRed() + (1.0 - factor) * (double)originalColor.getRed();
        double greenValue = factor * (double)targetColor.getGreen() + (1.0 - factor) * (double)originalColor.getGreen();
        double blueValue = factor * (double)targetColor.getBlue() + (1.0 - factor) * (double)originalColor.getBlue();
        return new Color((int)redValue, (int)greenValue, (int)blueValue);
    }

    @Override
    public String getAnimatorName() {
        return "ColorChange";
    }

    public Color getColor() {
        return this.getProperties().getColorProperty(COLOR_LABEL, Color.black);
    }

    @Override
    public int getFileVersion() {
        return 2;
    }

    @Override
    public Object getProperty(double factor) {
        int[] objectNums = this.getObjectNums();
        if (objectNums == null || objectNums.length == 0) {
            return this.getColor();
        }
        return this.getColor();
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{"ColorChange"};
    }

    public void setColor(Color color) {
        this.getProperties().put(COLOR_LABEL, color);
    }

    public void setOriginalColor(Color color) {
        int[] objectNums = this.getObjectNums();
        if (objectNums != null && objectNums.length != 0) {
            this.originalColor = new Color[objectNums.length];
            int i = 0;
            while (i < this.originalColor.length) {
                this.originalColor[i] = color;
                ++i;
            }
        }
    }

    public void storeOriginalColors() {
        int[] objectNums = this.getObjectNums();
        if (objectNums != null && objectNums.length > 0) {
            this.originalColor = new Color[objectNums.length];
            String methodName = this.getMethod();
            int i = 0;
            while (i < this.originalColor.length) {
                if (this.objects != null && this.objects.length > i && this.objects[i] != null) {
                    XProperties xp = this.objects[i].getProperties();
                    this.originalColor[i] = xp.getColorProperty(methodName, Color.black);
                } else {
                    this.originalColor[i] = Color.black;
                }
                ++i;
            }
        }
    }

    @Override
    public void discard() {
        this.setColor(null);
        super.discard();
    }

    @Override
    public String toString() {
        return "set color(" + this.getMethod() + ") to " + ColorChoice.getColorName(this.getColor()) + " on " + super.toString();
    }
}

