/*
 * Decompiled with CFR 0.152.
 */
package algoanim.variables;

import algoanim.variables.Variable;
import algoanim.variables.VariableTypes;

public class DoubleVariable
extends Variable {
    protected static final Double defaultValue = 0.0;
    protected Double value;

    public DoubleVariable() {
        this(defaultValue);
    }

    public DoubleVariable(Double value) {
        super(VariableTypes.DOUBLE);
        this.value = value;
    }

    @Override
    public void setValue(Byte value) {
        this.setValue(value.doubleValue());
    }

    @Override
    public void setValue(Long value) {
        this.setValue(value.doubleValue());
    }

    @Override
    public void setValue(Short value) {
        this.setValue(value.doubleValue());
    }

    @Override
    public <T> T getValue(Class<T> type) {
        T result = null;
        if (type == Boolean.class) {
            Boolean b = this.value != 0.0;
            result = type.cast(b);
        } else if (type == Byte.class) {
            Byte b = this.value.byteValue();
            result = type.cast(b);
        } else if (type == Double.class) {
            result = type.cast(this.value);
        } else if (type == Float.class) {
            Float f = Float.valueOf(this.value.floatValue());
            result = type.cast(f);
        } else if (type == Integer.class) {
            Integer i = this.value.intValue();
            result = type.cast(i);
        } else if (type == Long.class) {
            Long l = this.value.longValue();
            result = type.cast(l);
        } else if (type == Short.class) {
            Short s = this.value.shortValue();
            result = type.cast(s);
        } else if (type == String.class) {
            String s = this.value.toString();
            result = type.cast(s);
        } else {
            System.err.println("cannot cast variable to: " + type);
        }
        return result;
    }

    @Override
    public void setValue(Variable var) {
        this.setValue(var.getValue(Double.class));
    }

    @Override
    public void setValue(String value) {
        try {
            this.value = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            this.setError(value);
        }
    }

    @Override
    public void setValue(Integer value) {
        this.setValue(value.doubleValue());
    }

    @Override
    public void setValue(Float value) {
        this.setValue(value.doubleValue());
    }

    @Override
    public void setValue(Double value) {
        this.value = value;
        this.update();
    }

    @Override
    public void setValue(Boolean value) {
        if (value.booleanValue()) {
            this.setValue(1.0);
        } else {
            this.setValue(0.0);
        }
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

