/*
 * Decompiled with CFR 0.152.
 */
package algoanim.properties.items;

import algoanim.properties.Visitable;
import algoanim.properties.Visitor;
import algoanim.properties.items.AnimationPropertyItem;
import java.util.Vector;

public class EnumerationPropertyItem
extends AnimationPropertyItem
implements Visitable {
    private String choice = "";
    private String[] choices;

    public EnumerationPropertyItem(String defaultChoice, Vector<String> availableChoices) {
        this.choice = defaultChoice;
        this.choices = new String[availableChoices.size()];
        int choiceNr = 0;
        for (String aChoice : availableChoices) {
            this.choices[choiceNr++] = new String(aChoice);
        }
    }

    public EnumerationPropertyItem() {
    }

    public EnumerationPropertyItem(Vector<String> choices) {
        this(choices.elementAt(0), choices);
    }

    @Override
    public Vector<String> get() {
        Vector<String> outputVector = new Vector<String>(this.choices.length + 1);
        outputVector.add(this.choice);
        String[] stringArray = this.choices;
        int n = this.choices.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            outputVector.add(value);
            ++n2;
        }
        return outputVector;
    }

    @Override
    public boolean set(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null not accepted!");
        }
        String comparator = null;
        comparator = value.indexOf(",") > -1 ? value.substring(0, value.indexOf(",")) : value;
        String[] stringArray = this.choices;
        int n = this.choices.length;
        int n2 = 0;
        while (n2 < n) {
            String anOption = stringArray[n2];
            if (anOption.equals(comparator)) {
                this.choice = comparator;
                return true;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Choice '" + value + "' not in list.");
    }

    @Override
    public Object clone() {
        Vector<String> newVector = new Vector<String>(this.choices.length);
        String[] stringArray = this.choices;
        int n = this.choices.length;
        int n2 = 0;
        while (n2 < n) {
            String aChoice = stringArray[n2];
            newVector.add(new String(aChoice));
            ++n2;
        }
        EnumerationPropertyItem ret = new EnumerationPropertyItem(this.choice, newVector);
        return ret;
    }

    @Override
    public void accept(Visitor v) {
        if (v != null) {
            v.visit(this);
        }
    }
}

