/*
 * Decompiled with CFR 0.152.
 */
package algoanim.primitives;

import algoanim.primitives.VisualQueue;
import algoanim.primitives.generators.ConceptualQueueGenerator;
import algoanim.properties.QueueProperties;
import algoanim.util.DisplayOptions;
import algoanim.util.Node;
import algoanim.util.Timing;
import java.util.List;
import java.util.NoSuchElementException;

public class ConceptualQueue<T>
extends VisualQueue<T> {
    private ConceptualQueueGenerator<T> generator;

    public ConceptualQueue(ConceptualQueueGenerator<T> cqg, Node upperLeftCorner, List<T> content, String name, DisplayOptions display, QueueProperties qp) {
        super(cqg, upperLeftCorner, content, name, display, qp);
        this.generator = cqg;
        this.generator.create(this);
    }

    public void enqueue(T elem, Timing delay, Timing duration) {
        super.enqueue(elem);
        this.generator.enqueue(this, elem, delay, duration);
    }

    public T dequeue(Timing delay, Timing duration) {
        if (this.isEmpty()) {
            throw new NoSuchElementException("The queue is empty, so there is no element to be dequeued!");
        }
        this.generator.dequeue(this, delay, duration);
        return super.dequeue();
    }

    public T front(Timing delay, Timing duration) {
        if (this.isEmpty()) {
            throw new NoSuchElementException("The queue is empty, so there is no front element!");
        }
        this.generator.front(this, delay, duration);
        return super.front();
    }

    public T tail(Timing delay, Timing duration) {
        if (this.isEmpty()) {
            throw new NoSuchElementException("The queue is empty, so there is no tail element!");
        }
        this.generator.tail(this, delay, duration);
        return super.tail();
    }

    public boolean isEmpty(Timing delay, Timing duration) {
        this.generator.isEmpty(this, delay, duration);
        return super.isEmpty();
    }

    public void highlightFrontElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightFrontElem(this, delay, duration);
        }
    }

    public void unhighlightFrontElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightFrontElem(this, delay, duration);
        }
    }

    public void highlightFrontCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightFrontCell(this, delay, duration);
        }
    }

    public void unhighlightFrontCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightFrontCell(this, delay, duration);
        }
    }

    public void highlightTailElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightTailElem(this, delay, duration);
        }
    }

    public void unhighlightTailElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightTailElem(this, delay, duration);
        }
    }

    public void highlightTailCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightTailCell(this, delay, duration);
        }
    }

    public void unhighlightTailCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightTailCell(this, delay, duration);
        }
    }
}

