/*
 * Decompiled with CFR 0.152.
 */
package algoanim.animalscript;

import algoanim.animalscript.AnimalGenerator;
import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Polygon;
import algoanim.primitives.generators.Language;
import algoanim.primitives.generators.PolygonGenerator;
import algoanim.properties.PolygonProperties;
import algoanim.util.Node;
import java.awt.Color;

public class AnimalPolygonGenerator
extends AnimalGenerator
implements PolygonGenerator {
    private static int count = 1;

    public AnimalPolygonGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(Polygon p) {
        if (this.isNameUsed(p.getName()) || p.getName() == "") {
            p.setName("Polygon" + count);
            ++count;
        }
        this.lang.addItem(p);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("polygon \"" + p.getName() + "\" ");
        Node[] nodes = p.getNodes();
        int i = 0;
        while (i < nodes.length) {
            str.append(AnimalGenerator.makeNodeDef(nodes[i]));
            ++i;
        }
        PolygonProperties props = p.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
            str.append(" filled");
            if (props.get("fillColor") != null) {
                str.append(" fillColor ");
                str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(p.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

